/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IllegalLinearOperationException;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public abstract class LinearOperator {
    protected final VectorSpace inputSpace;
    protected final VectorSpace outputSpace;
    public static int DIRECT = 0;
    public static int ADJOINT = 1;
    public static int INVERSE = 2;
    public static int INVERSE_ADJOINT = ADJOINT | INVERSE;
    public static int ADJOINT_INVERSE = ADJOINT | INVERSE;

    public LinearOperator(VectorSpace vsp) {
        this.inputSpace = vsp;
        this.outputSpace = vsp;
    }

    protected LinearOperator(VectorSpace inp, VectorSpace out) {
        this.inputSpace = inp;
        this.outputSpace = out;
    }

    public VectorSpace getInputSpace() {
        return this.inputSpace;
    }

    public VectorSpace getOutputSpace() {
        return this.outputSpace;
    }

    public boolean isEndomorphism() {
        return this.outputSpace == this.inputSpace;
    }

    protected abstract void privApply(Vector var1, Vector var2, int var3) throws IncorrectSpaceException;

    public void apply(Vector src, Vector dst) throws IncorrectSpaceException {
        this.apply(src, dst, DIRECT);
    }

    public void apply(Vector src, Vector dst, int job) throws IncorrectSpaceException {
        if (job == DIRECT || job == (INVERSE | ADJOINT)) {
            if (!src.belongsTo(this.inputSpace) || !dst.belongsTo(this.outputSpace)) {
                throw new IncorrectSpaceException();
            }
        } else if (job == ADJOINT || job == INVERSE) {
            if (!src.belongsTo(this.outputSpace) || !dst.belongsTo(this.inputSpace)) {
                throw new IncorrectSpaceException();
            }
        } else {
            throw new IllegalLinearOperationException();
        }
        this.privApply(src, dst, job);
    }

    public static void checkLinearProblem(LinearOperator A, Vector b, Vector x, boolean endomorphism) throws IncorrectSpaceException {
        if (!x.belongsTo(A.getInputSpace()) || !b.belongsTo(A.getOutputSpace())) {
            throw new IncorrectSpaceException();
        }
        if (endomorphism && A.getInputSpace() != A.getOutputSpace()) {
            throw new IllegalArgumentException("LHS linear operator is not an endomorphism");
        }
    }

    public double checkAdjoint(Vector x, Vector y) {
        Vector Ax = this.outputSpace.create();
        this.apply(x, Ax);
        Vector Aty = this.inputSpace.create();
        this.apply(y, Aty, ADJOINT);
        double a = this.outputSpace.dot(y, Ax);
        double b = this.inputSpace.dot(Aty, x);
        if (a == b) {
            return 0.0;
        }
        return Math.abs(a - b) / Math.max(Math.abs(a), Math.abs(b));
    }
}

