/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.services;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.Location;
import loci.common.services.AbstractService;
import loci.common.services.ServiceException;
import loci.formats.services.NetCDFService;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NetCDFServiceImpl
extends AbstractService
implements NetCDFService,
KryoSerializable {
    public static final String NO_NETCDF_MSG = "NetCDF is required to read NetCDF/HDF variants. Please obtain the necessary JAR files from http://www.openmicroscopy.org/site/support/bio-formats/developers/java-library.html.\nRequired JAR files are netcdf-4.3.19.jar and slf4j-jdk14.jar.";
    private String currentFile;
    private Vector<String> attributeList;
    private Vector<String> variableList;
    private NetcdfFile netCDFFile;
    private Group root;

    public NetCDFServiceImpl() {
        this.checkClassDependency(Attribute.class);
        this.checkClassDependency(Array.class);
    }

    @Override
    public void setFile(String file2) throws IOException {
        this.currentFile = file2;
        this.init();
        this.attributeList = new Vector();
        this.variableList = new Vector();
        ArrayList<Group> groups = new ArrayList<Group>();
        groups.add(this.root);
        this.parseAttributesAndVariables(groups);
    }

    @Override
    public String getFile() {
        return this.currentFile;
    }

    @Override
    public Vector<String> getAttributeList() {
        return this.attributeList;
    }

    @Override
    public Vector<String> getVariableList() {
        return this.variableList;
    }

    @Override
    public String getAttributeValue(String path) {
        String groupName = this.getDirectory(path);
        String attributeName = this.getName(path);
        Group group = this.getGroup(groupName);
        Attribute attribute = group.findAttribute(attributeName);
        if (attribute == null) {
            return null;
        }
        return this.arrayToString(attribute.getValues());
    }

    @Override
    public Object getVariableValue(String name) throws ServiceException {
        return this.getArray(name, null, null);
    }

    @Override
    public Object getArray(String path, int[] origin, int[] shape) throws ServiceException {
        String groupName = this.getDirectory(path);
        String variableName = this.getName(path);
        Group group = this.getGroup(groupName);
        Variable variable = group.findVariable(variableName);
        try {
            if (origin != null && shape != null) {
                return variable.read(origin, shape).reduce().copyToNDJavaArray();
            }
            return variable.read().copyToNDJavaArray();
        }
        catch (InvalidRangeException e) {
            throw new ServiceException(e);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public Hashtable<String, Object> getVariableAttributes(String name) {
        String groupName = this.getDirectory(name);
        String variableName = this.getName(name);
        Group group = this.getGroup(groupName);
        Variable variable = group.findVariable(variableName);
        Hashtable<String, Object> toReturn = new Hashtable<String, Object>();
        if (variable != null) {
            List<Attribute> attributes = variable.getAttributes();
            for (Attribute attribute : attributes) {
                toReturn.put(attribute.getName(), this.arrayToString(attribute.getValues()));
            }
        }
        return toReturn;
    }

    @Override
    public int getDimension(String name) {
        String groupName = this.getDirectory(name);
        String variableName = this.getName(name);
        Group group = this.getGroup(groupName);
        return group.findDimension(variableName).getLength();
    }

    @Override
    public void close() throws IOException {
        if (this.netCDFFile != null) {
            this.netCDFFile.close();
        }
        this.currentFile = null;
        this.attributeList = null;
        this.variableList = null;
        this.netCDFFile = null;
        this.root = null;
    }

    private void parseAttributesAndVariables(List<Group> groups) {
        for (Group group : groups) {
            String groupName = group.getName();
            List<Attribute> attributes = group.getAttributes();
            for (Attribute attribute : attributes) {
                String attributeName = attribute.getName();
                if (!groupName.endsWith("/")) {
                    attributeName = "/" + attributeName;
                }
                this.attributeList.add(groupName + attributeName);
            }
            List<Variable> variables = group.getVariables();
            for (Variable variable : variables) {
                String variableName = variable.getName();
                if (!groupName.endsWith("/")) {
                    variableName = "/" + variableName;
                }
                this.variableList.add(variableName);
            }
            groups = group.getGroups();
            this.parseAttributesAndVariables(groups);
        }
    }

    private Group getGroup(String path) {
        String token;
        Group nextParent;
        if (path.indexOf("/") == -1) {
            return this.root;
        }
        StringTokenizer tokens = new StringTokenizer(path, "/");
        Group parent = this.root;
        while (tokens.hasMoreTokens() && (nextParent = parent.findGroup(token = tokens.nextToken())) != null) {
            parent = nextParent;
        }
        return parent == null ? this.root : parent;
    }

    private String getDirectory(String path) {
        return path.substring(0, path.lastIndexOf("/"));
    }

    private String getName(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private String arrayToString(Array values) {
        Object v = values.copyTo1DJavaArray();
        if (v instanceof Object[]) {
            Object[] array = (Object[])v;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                sb.append((String)array[i]);
            }
            return sb.toString().trim();
        }
        return values.toString().trim();
    }

    private void init() throws IOException {
        String currentId = Location.getMappedId(this.currentFile);
        PrintStream outStream = System.out;
        PrintStream throwaway = new PrintStream(new ByteArrayOutputStream(), false, "UTF-8"){

            @Override
            public void print(String s) {
            }
        };
        System.setOut(throwaway);
        throwaway.close();
        this.netCDFFile = NetcdfFile.open(currentId);
        System.setOut(outStream);
        this.root = this.netCDFFile.getRootGroup();
    }

    @Override
    public void read(Kryo kryo, Input in) {
        this.currentFile = kryo.readObjectOrNull(in, String.class);
        this.attributeList = kryo.readObjectOrNull(in, Vector.class);
        this.variableList = kryo.readObjectOrNull(in, Vector.class);
        try {
            this.init();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(Kryo kryo, Output out) {
        kryo.writeObjectOrNull(out, (Object)this.currentFile, String.class);
        kryo.writeObjectOrNull(out, this.attributeList, Vector.class);
        kryo.writeObjectOrNull(out, this.variableList, Vector.class);
    }
}

