/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.UpgradeChecker;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffSaver;
import loci.formats.tools.EditTiffG;

public class TiffComment {
    public static void main(String[] args) throws FormatException, IOException {
        UpgradeChecker checker = new UpgradeChecker();
        boolean canUpgrade = checker.newVersionAvailable("Bio-Formats utilities");
        if (canUpgrade) {
            System.out.println("*** A new stable version is available. ***");
            System.out.println("*** Install the new version using:     ***");
            System.out.println("***   'upgradechecker -install'        ***");
        }
        if (args.length == 0) {
            System.out.println("Usage:");
            System.out.println("tiffcomment [-set comment] [-edit] file1 [file2 ...]");
            System.out.println();
            System.out.println("If using the '-set' option, the new TIFF comment must be specified.");
            System.out.println("The commment may take any of the following forms:");
            System.out.println();
            System.out.println("  * the text of the comment, e.g. 'new comment!'");
            System.out.println("  * the name of the file containing the text of the comment, e.g. 'file.xml'");
            System.out.println("  * '-', to enter the comment using stdin.  Entering a blank line will");
            System.out.println("    terminate reading from stdin.");
            return;
        }
        boolean edit = false;
        String newComment = null;
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) {
                files.add(args[i]);
                continue;
            }
            if (args[i].equals("-edit")) {
                edit = true;
                continue;
            }
            if (args[i].equals("-set")) {
                if (new File(newComment = args[++i]).exists()) {
                    newComment = DataTools.readFile(newComment);
                    continue;
                }
                if (!newComment.equals("-")) continue;
                newComment = null;
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
                String line = reader.readLine();
                while (line != null && line.length() > 0) {
                    newComment = newComment == null ? line : newComment + "\n" + line;
                    line = reader.readLine();
                }
                continue;
            }
            System.out.println("Warning: unknown flag: " + args[i]);
        }
        for (String file2 : files) {
            if (edit) {
                EditTiffG.openFile(file2);
                continue;
            }
            if (newComment != null) {
                TiffComment.overwriteComment(file2, newComment);
                continue;
            }
            String comment = new TiffParser(file2).getComment();
            System.out.println(comment == null ? file2 + ": no TIFF comment found." : comment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void overwriteComment(String file2, String comment) {
        RandomAccessInputStream in = null;
        RandomAccessOutputStream out = null;
        try {
            in = new RandomAccessInputStream(file2);
            out = new RandomAccessOutputStream(file2);
            TiffSaver saver = new TiffSaver(out, file2);
            saver.overwriteComment(in, comment);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

