/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AnnotationRef
extends Reference {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SA/2015-01";
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationRef.class);
    private String id;

    public AnnotationRef() {
    }

    public AnnotationRef(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public AnnotationRef(AnnotationRef orig) {
        super(orig);
        this.id = orig.id;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"AnnotationRef".equals(tagName)) {
            LOGGER.debug("Expecting node name of AnnotationRef got {}", (Object)tagName);
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("AnnotationRef missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element AnnotationRef_element) {
        if (AnnotationRef_element == null) {
            AnnotationRef_element = document.createElementNS(NAMESPACE, "AnnotationRef");
        }
        if (this.id != null) {
            AnnotationRef_element.setAttribute("ID", this.id.toString());
        }
        return super.asXMLElement(document, AnnotationRef_element);
    }
}

