/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.map.tlong.AbstractLongIntMap;
import cern.colt.map.tlong.OpenLongIntHashMap;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.SelectedSparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix3D;

public class SparseIntMatrix1D
extends IntMatrix1D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongIntMap elements;

    public SparseIntMatrix1D(int[] values) {
        this(values.length);
        this.assign(values);
    }

    public SparseIntMatrix1D(int size) {
        this(size, size / 1000, 0.2, 0.5);
    }

    public SparseIntMatrix1D(int size, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(size);
        this.elements = new OpenLongIntHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    protected SparseIntMatrix1D(int size, AbstractLongIntMap elements, int offset, int stride) {
        this.setUp(size, offset, stride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public IntMatrix1D assign(int value) {
        if (this.isNoView && value == 0) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public AbstractLongIntMap elements() {
        return this.elements;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public synchronized int getQuick(int index) {
        return this.elements.get((long)this.zero + (long)index * (long)this.stride);
    }

    @Override
    public long index(int rank) {
        return (long)this.zero + (long)rank * (long)this.stride;
    }

    @Override
    public IntMatrix1D like(int size) {
        return new SparseIntMatrix1D(size);
    }

    @Override
    public IntMatrix2D like2D(int rows, int columns) {
        return new SparseIntMatrix2D(rows, columns);
    }

    @Override
    public IntMatrix2D reshape(int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        SparseIntMatrix2D M = new SparseIntMatrix2D(rows, columns);
        int idx = 0;
        int c = 0;
        while (c < columns) {
            int r = 0;
            while (r < rows) {
                int elem;
                if ((elem = this.getQuick(idx++)) != 0) {
                    ((IntMatrix2D)M).setQuick(r, c, elem);
                }
                ++r;
            }
            ++c;
        }
        return M;
    }

    @Override
    public IntMatrix3D reshape(int slices, int rows, int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        SparseIntMatrix3D M = new SparseIntMatrix3D(slices, rows, columns);
        int idx = 0;
        int s = 0;
        while (s < slices) {
            int c = 0;
            while (c < columns) {
                int r = 0;
                while (r < rows) {
                    int elem;
                    if ((elem = this.getQuick(idx++)) != 0) {
                        ((IntMatrix3D)M).setQuick(s, r, c, elem);
                    }
                    ++r;
                }
                ++c;
            }
            ++s;
        }
        return M;
    }

    @Override
    public synchronized void setQuick(int index, int value) {
        long i = (long)this.zero + (long)index * (long)this.stride;
        if (value == 0) {
            this.elements.removeKey(i);
        } else {
            this.elements.put(i, value);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("1 x ").append(this.size).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        int i = 0;
        while (i < this.size) {
            int elem = this.getQuick(i);
            if (elem != 0) {
                builder.append('(').append(i).append(')').append('\t').append(elem).append('\n');
            }
            ++i;
        }
        return builder.toString();
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    protected boolean haveSharedCellsRaw(IntMatrix1D other) {
        if (other instanceof SelectedSparseIntMatrix1D) {
            SelectedSparseIntMatrix1D otherMatrix = (SelectedSparseIntMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseIntMatrix1D) {
            SparseIntMatrix1D otherMatrix = (SparseIntMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected IntMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedSparseIntMatrix1D(this.elements, offsets);
    }
}

