/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tfloat.engine;

import cern.jet.random.tfloat.engine.FloatRandomEngine;
import java.util.Date;

public class FloatMersenneTwister
extends FloatRandomEngine {
    private static final long serialVersionUID = 1L;
    private int mti;
    private int[] mt = new int[624];
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private static final int mag0 = 0;
    private static final int mag1 = -1727483681;
    public static final int DEFAULT_SEED = 4357;

    public FloatMersenneTwister() {
        this(4357);
    }

    public FloatMersenneTwister(int seed) {
        this.setSeed(seed);
    }

    public FloatMersenneTwister(Date d) {
        this((int)d.getTime());
    }

    @Override
    public Object clone() {
        FloatMersenneTwister clone = (FloatMersenneTwister)super.clone();
        clone.mt = (int[])this.mt.clone();
        return clone;
    }

    protected void nextBlock() {
        int y;
        int kk = 0;
        while (kk < 227) {
            y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
            this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ ((y & 1) == 0 ? 0 : -1727483681);
            ++kk;
        }
        while (kk < 623) {
            y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
            this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ ((y & 1) == 0 ? 0 : -1727483681);
            ++kk;
        }
        y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
        this.mt[623] = this.mt[396] ^ y >>> 1 ^ ((y & 1) == 0 ? 0 : -1727483681);
        this.mti = 0;
    }

    @Override
    public int nextInt() {
        if (this.mti == 624) {
            this.nextBlock();
        }
        int y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y;
    }

    protected void setSeed(int seed) {
        this.mt[0] = seed & 0xFFFFFFFF;
        int i = 1;
        while (i < 624) {
            this.mt[i] = 1812433253 * (this.mt[i - 1] ^ this.mt[i - 1] >> 30) + i;
            int n = i++;
            this.mt[n] = this.mt[n] & 0xFFFFFFFF;
        }
        this.mti = 624;
    }
}

