/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.optim.InverseHessianApproximation;
import mitiv.optim.LBFGSOperator;
import mitiv.optim.LineSearch;
import mitiv.optim.LineSearchTask;
import mitiv.optim.OptimStatus;
import mitiv.optim.OptimTask;
import mitiv.optim.ReverseCommunicationOptimizerWithLineSearch;

public class LBFGS
extends ReverseCommunicationOptimizerWithLineSearch {
    protected LBFGSOperator H = null;
    protected double delta = 0.01;
    protected double epsilon = 0.001;
    protected double grtol;
    protected double gatol;
    protected double ginit;
    protected double stpmin = 1.0E-20;
    protected double stpmax = 1.0E20;
    private boolean saveMemory = true;
    protected Vector x0 = null;
    protected double f0 = 0.0;
    protected Vector g0 = null;
    protected Vector p = null;
    protected double alpha;
    protected double dg0 = 0.0;
    protected double gnorm = 0.0;

    public LBFGS(VectorSpace vsp, int m, LineSearch ls) {
        this(new LBFGSOperator(vsp, m), ls);
    }

    public LBFGS(LinearOperator H0, int m, LineSearch ls) {
        this(new LBFGSOperator(H0, m), ls);
    }

    private LBFGS(LBFGSOperator H, LineSearch ls) {
        this.H = H;
        this.p = H.getOutputSpace().create();
        if (!this.saveMemory) {
            this.x0 = H.getOutputSpace().create();
            this.g0 = H.getInputSpace().create();
        }
        this.lnsrch = ls;
    }

    @Override
    public OptimTask start() {
        this.evaluations = 0;
        this.iterations = 0;
        this.restarts = 0;
        return this.begin();
    }

    @Override
    public OptimTask restart() {
        ++this.restarts;
        return this.begin();
    }

    private OptimTask begin() {
        this.H.reset();
        return this.success(OptimTask.COMPUTE_FG);
    }

    @Override
    public OptimTask iterate(Vector x, double f, Vector g) {
        switch (this.getTask()) {
            case COMPUTE_FG: {
                double gtest;
                ++this.evaluations;
                if (this.evaluations > 1) {
                    LineSearchTask lnsrchTask = this.lnsrch.iterate(this.alpha, f, -this.p.dot(g));
                    if (lnsrchTask == LineSearchTask.SEARCH) {
                        return this.nextStep(x);
                    }
                    if (lnsrchTask != LineSearchTask.CONVERGENCE) {
                        OptimStatus lnsrchStatus = this.lnsrch.getStatus();
                        if (lnsrchTask != LineSearchTask.WARNING || lnsrchStatus != OptimStatus.ROUNDING_ERRORS_PREVENT_PROGRESS) {
                            return this.failure(lnsrchStatus);
                        }
                    }
                    ++this.iterations;
                }
                this.gnorm = g.norm2();
                if (this.evaluations == 1) {
                    this.ginit = this.gnorm;
                }
                return this.success(this.gnorm <= (gtest = this.getGradientThreshold()) ? OptimTask.FINAL_X : OptimTask.NEW_X);
            }
            case NEW_X: 
            case FINAL_X: {
                if (this.iterations >= 1) {
                    this.H.update(x, this.x0, g, this.g0);
                }
                while (true) {
                    double r;
                    this.H.apply(g, this.p);
                    this.dg0 = -this.p.dot(g);
                    double d = r = this.delta > 0.0 ? this.delta * this.gnorm * this.p.norm2() : 0.0;
                    if (r > 0.0 ? this.dg0 <= -r : this.dg0 < 0.0) break;
                    if (this.H.mp < 1) {
                        return this.failure(OptimStatus.BAD_PRECONDITIONER);
                    }
                    this.H.reset();
                    ++this.restarts;
                }
                this.alpha = this.initialStep(x, this.gnorm);
                if (this.saveMemory) {
                    this.x0 = this.H.s(0);
                    this.g0 = this.H.y(0);
                    if (this.H.mp == this.H.m) {
                        --this.H.mp;
                    }
                }
                this.x0.copyFrom(x);
                this.g0.copyFrom(g);
                this.f0 = f;
                LineSearchTask lnsrchTask = this.lnsrch.start(this.f0, this.dg0, this.alpha, this.stpmin * this.alpha, this.stpmax * this.alpha);
                if (lnsrchTask != LineSearchTask.SEARCH) {
                    return this.failure(this.lnsrch.getStatus());
                }
                return this.nextStep(x);
            }
        }
        return this.getTask();
    }

    protected double initialStep(Vector x, double dnorm) {
        double xnorm;
        if (this.H.mp >= 1 || this.H.rule == InverseHessianApproximation.BY_USER) {
            return 1.0;
        }
        if (0.0 < this.epsilon && this.epsilon < 1.0 && (xnorm = x.norm2()) > 0.0) {
            return xnorm / dnorm * this.epsilon;
        }
        return 1.0 / dnorm;
    }

    private OptimTask nextStep(Vector x) {
        this.alpha = this.lnsrch.getStep();
        x.axpby(1.0, this.x0, -this.alpha, this.p);
        return this.success(OptimTask.COMPUTE_FG);
    }

    public void setAbsoluteTolerance(double gatol) {
        this.gatol = gatol;
    }

    public void setRelativeTolerance(double grtol) {
        this.grtol = grtol;
    }

    public double getAbsoluteTolerance() {
        return this.gatol;
    }

    public double getRelativeTolerance() {
        return this.grtol;
    }

    public double getGradientThreshold() {
        return LBFGS.max(0.0, this.gatol, this.grtol * this.ginit);
    }

    private static final double max(double a1, double a2, double a3) {
        if (a3 >= a2) {
            return a3 >= a1 ? a3 : a1;
        }
        return a2 >= a1 ? a2 : a1;
    }
}

