/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IncorrectSpaceException;
import mitiv.exception.NotImplementedException;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;

public class RankOneOperator
extends LinearOperator {
    protected Vector u;
    protected Vector v;

    public RankOneOperator(Vector u, Vector v) {
        super(v.getSpace(), u.getSpace());
        this.u = u;
        this.v = v;
    }

    public RankOneOperator(Vector u, Vector v, boolean clone) throws IncorrectSpaceException {
        super(v.getSpace(), u.getSpace());
        if (clone) {
            this.u = this.outputSpace.clone(u);
            this.v = this.inputSpace.clone(v);
        } else {
            this.u = u;
            this.v = v;
        }
    }

    @Override
    protected void _apply(Vector dst, Vector src, int job) {
        if (job == DIRECT) {
            this.outputSpace.scale(dst, this.v.dot(src), this.u);
        } else if (job == ADJOINT) {
            this.inputSpace.scale(dst, this.u.dot(src), this.v);
        } else {
            throw new NotImplementedException();
        }
    }

    @Override
    protected void _apply(Vector vec, int job) {
        if (job == DIRECT) {
            this.outputSpace.scale(vec, this.v.dot(vec), this.u);
        } else if (job == ADJOINT) {
            this.inputSpace.scale(vec, this.u.dot(vec), this.v);
        } else {
            throw new NotImplementedException();
        }
    }

    public Vector getLeftVector() {
        return this.u;
    }

    public void setLeftVector(Vector u) throws IncorrectSpaceException {
        if (u.getSpace() != this.outputSpace) {
            throw new IncorrectSpaceException();
        }
        this.u = u;
    }

    public Vector getRightVector() {
        return this.v;
    }

    public void setRightVector(Vector v) throws IncorrectSpaceException {
        if (v.getSpace() != this.inputSpace) {
            throw new IncorrectSpaceException();
        }
        this.v = v;
    }
}

