/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.optim.BoundProjector;

public class SimpleUpperBound
extends BoundProjector {
    private final double upperBound;
    private final boolean single;

    public SimpleUpperBound(ShapedVectorSpace vsp, double upperBound) {
        super(vsp);
        if (vsp.getType() == 5) {
            this.single = false;
        } else if (vsp.getType() == 4) {
            this.single = true;
        } else {
            throw new IllegalArgumentException("Only double/double type supported");
        }
        this.checkUpperBound(upperBound, this.single);
        this.upperBound = upperBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    @Override
    protected void _projectVariables(Vector src, Vector dst) {
        int n = src.getNumber();
        if (this.single) {
            float xmax = this.convertToFloat(this.getUpperBound());
            float[] x = ((FloatShapedVector)src).getData();
            float[] xp = ((FloatShapedVector)dst).getData();
            int j = 0;
            while (j < n) {
                xp[j] = SimpleUpperBound.min(x[j], xmax);
                ++j;
            }
        } else {
            double xmax = this.getUpperBound();
            double[] x = ((DoubleShapedVector)src).getData();
            double[] xp = ((DoubleShapedVector)dst).getData();
            int j = 0;
            while (j < n) {
                xp[j] = SimpleUpperBound.min(x[j], xmax);
                ++j;
            }
        }
    }

    @Override
    protected void _projectDirection(Vector vx, Vector vd, boolean ascent, Vector vdp, double[] bnd) {
        int n = vx.getNumber();
        if (this.single) {
            float zero = 0.0f;
            float xmax = this.convertToFloat(this.getUpperBound());
            float[] x = ((FloatShapedVector)vx).getData();
            float[] d = ((FloatShapedVector)vd).getData();
            float[] dp = ((FloatShapedVector)vdp).getData();
            if (bnd == null) {
                if (ascent) {
                    int j = 0;
                    while (j < n) {
                        dp[j] = d[j] > 0.0f || x[j] < xmax ? d[j] : 0.0f;
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < n) {
                        dp[j] = d[j] < 0.0f || x[j] < xmax ? d[j] : 0.0f;
                        ++j;
                    }
                }
            } else {
                float amin = Float.POSITIVE_INFINITY;
                float amax = 0.0f;
                if (ascent) {
                    int j = 0;
                    while (j < n) {
                        if (d[j] < 0.0f) {
                            if (x[j] < xmax) {
                                dp[j] = d[j];
                                if (xmax == Float.POSITIVE_INFINITY) {
                                    amax = Float.POSITIVE_INFINITY;
                                } else {
                                    float tmp = (x[j] - xmax) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0f;
                            }
                        } else if (d[j] > 0.0f) {
                            dp[j] = d[j];
                            amax = Float.POSITIVE_INFINITY;
                        } else {
                            dp[j] = 0.0f;
                        }
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < n) {
                        if (d[j] > 0.0f) {
                            if (x[j] < xmax) {
                                dp[j] = d[j];
                                if (xmax == Float.POSITIVE_INFINITY) {
                                    amax = Float.POSITIVE_INFINITY;
                                } else {
                                    float tmp = (xmax - x[j]) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0f;
                            }
                        } else if (d[j] < 0.0f) {
                            dp[j] = d[j];
                            amax = Float.POSITIVE_INFINITY;
                        } else {
                            dp[j] = 0.0f;
                        }
                        ++j;
                    }
                }
                bnd[0] = amin;
                bnd[1] = amax;
            }
        } else {
            double zero = 0.0;
            double xmax = this.getUpperBound();
            double[] x = ((DoubleShapedVector)vx).getData();
            double[] d = ((DoubleShapedVector)vd).getData();
            double[] dp = ((DoubleShapedVector)vdp).getData();
            if (bnd == null) {
                if (ascent) {
                    int j = 0;
                    while (j < n) {
                        dp[j] = d[j] > 0.0 || x[j] < xmax ? d[j] : 0.0;
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < n) {
                        dp[j] = d[j] < 0.0 || x[j] < xmax ? d[j] : 0.0;
                        ++j;
                    }
                }
            } else {
                double amin = Double.POSITIVE_INFINITY;
                double amax = 0.0;
                if (ascent) {
                    int j = 0;
                    while (j < n) {
                        if (d[j] < 0.0) {
                            if (x[j] < xmax) {
                                dp[j] = d[j];
                                if (xmax == Double.POSITIVE_INFINITY) {
                                    amax = Double.POSITIVE_INFINITY;
                                } else {
                                    double tmp = (x[j] - xmax) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0;
                            }
                        } else if (d[j] > 0.0) {
                            dp[j] = d[j];
                            amax = Double.POSITIVE_INFINITY;
                        } else {
                            dp[j] = 0.0;
                        }
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < n) {
                        if (d[j] > 0.0) {
                            if (x[j] < xmax) {
                                dp[j] = d[j];
                                if (xmax == Double.POSITIVE_INFINITY) {
                                    amax = Double.POSITIVE_INFINITY;
                                } else {
                                    double tmp = (xmax - x[j]) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0;
                            }
                        } else if (d[j] < 0.0) {
                            dp[j] = d[j];
                            amax = Double.POSITIVE_INFINITY;
                        } else {
                            dp[j] = 0.0;
                        }
                        ++j;
                    }
                }
                bnd[0] = amin;
                bnd[1] = amax;
            }
        }
    }
}

