/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.icy.gui.pair;

import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.lang.Var;

/**
 * Var for Pair objects. The String value of a VarPair is the two values of the
 * pair separated by a space.
 * 
 * @version May 3, 2014
 * 
 * @author Julien Jacquemot
 */
public class VarPair extends Var<Pair> {
	/** Default constructor. */
	public VarPair(String name, Pair defaultValue) throws NullPointerException {
		super(name, defaultValue);
	}

	@Override
	public VarEditor<Pair> createVarEditor() {
		return new PairEditor(this);
	}

	@Override
	public String getValueAsString() {
		return getValue().getFirst() + " " + getValue().getSecond();
	}

	@Override
	public Pair parse(String text) {
		text = text.trim();
		String[] values = text.split(" ");
		if (values.length < 2) {
			throw new IllegalArgumentException(
					"A pair object may only have 2 components");
		}

		Pair value = getValue().clone();
		value.setFirst(Double.parseDouble(values[0]));
		value.setSecond(Double.parseDouble(values[1]));

		return value;
	}
}
