/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;
import cern.colt.matrix.tfloat.impl.SelectedDenseFloatMatrix1D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultFirst;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_1D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_1D;
import edu.emory.mathcs.jtransforms.dst.FloatDST_1D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseFloatMatrix1D
extends FloatMatrix1D {
    private static final long serialVersionUID = 1L;
    private FloatFFT_1D fft;
    private FloatDCT_1D dct;
    private FloatDST_1D dst;
    private FloatDHT_1D dht;
    protected float[] elements;

    public DenseFloatMatrix1D(float[] values) {
        this(values.length);
        this.assign(values);
    }

    public DenseFloatMatrix1D(int size) {
        this.setUp(size);
        this.elements = new float[size];
    }

    public DenseFloatMatrix1D(int size, float[] elements, int zero, int stride, boolean isView) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    @Override
    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f) {
        if (this.size == 0) {
            return Float.NaN;
        }
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = this.size - j * k;
                final int lastIdx = j == nthreads - 1 ? 0 : firstIdx - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        int idx = DenseFloatMatrix1D.this.zero + (firstIdx - 1) * DenseFloatMatrix1D.this.stride;
                        float a = f.apply(DenseFloatMatrix1D.this.elements[idx]);
                        int i = firstIdx - 1;
                        while (--i >= lastIdx) {
                            a = aggr.apply(a, f.apply(DenseFloatMatrix1D.this.elements[idx -= DenseFloatMatrix1D.this.stride]));
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int idx = this.zero + (this.size - 1) * this.stride;
            a = f.apply(this.elements[idx]);
            int i = this.size - 1;
            while (--i >= 0) {
                a = aggr.apply(a, f.apply(this.elements[idx -= this.stride]));
            }
        }
        return a;
    }

    @Override
    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f, IntArrayList indexList) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        int size = indexList.size();
        final int[] indexElements = indexList.elements();
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        int idx = DenseFloatMatrix1D.this.zero + indexElements[firstIdx] * DenseFloatMatrix1D.this.stride;
                        float a = f.apply(DenseFloatMatrix1D.this.elements[idx]);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            idx = DenseFloatMatrix1D.this.zero + indexElements[i] * DenseFloatMatrix1D.this.stride;
                            float elem = DenseFloatMatrix1D.this.elements[idx];
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int idx = this.zero + indexElements[0] * this.stride;
            a = f.apply(this.elements[idx]);
            int i = 1;
            while (i < size) {
                idx = this.zero + indexElements[i] * this.stride;
                float elem = this.elements[idx];
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    @Override
    public float aggregate(FloatMatrix1D other, final FloatFloatFunction aggr, final FloatFloatFunction f) {
        if (!(other instanceof DenseFloatMatrix1D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkSize(other);
        if (this.size == 0) {
            return Float.NaN;
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride();
        final float[] elementsOther = (float[])other.elements();
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        int idx = DenseFloatMatrix1D.this.zero + firstIdx * DenseFloatMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        float a = f.apply(DenseFloatMatrix1D.this.elements[idx], elementsOther[idxOther]);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            a = aggr.apply(a, f.apply(DenseFloatMatrix1D.this.elements[idx += DenseFloatMatrix1D.this.stride], elementsOther[idxOther += strideOther]));
                            ++i;
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[this.zero], elementsOther[zeroOther]);
            int idx = this.zero;
            int idxOther = zeroOther;
            int i = 1;
            while (i < this.size) {
                a = aggr.apply(a, f.apply(this.elements[idx += this.stride], elementsOther[idxOther += strideOther]));
                ++i;
            }
        }
        return a;
    }

    @Override
    public FloatMatrix1D assign(final FloatFunction function) {
        int nthreads;
        float multiplicator;
        if (function instanceof FloatMult) {
            multiplicator = ((FloatMult)function).multiplicator;
            if (multiplicator == 1.0f) {
                return this;
            }
        } else {
            multiplicator = 0.0f;
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFloatMatrix1D.this.zero + firstIdx * DenseFloatMatrix1D.this.stride;
                        if (function instanceof FloatMult) {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                int n = idx;
                                DenseFloatMatrix1D.this.elements[n] = DenseFloatMatrix1D.this.elements[n] * multiplicator;
                                idx += DenseFloatMatrix1D.this.stride;
                                ++k;
                            }
                        } else {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                DenseFloatMatrix1D.this.elements[idx] = function.apply(DenseFloatMatrix1D.this.elements[idx]);
                                idx += DenseFloatMatrix1D.this.stride;
                                ++k;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero - this.stride;
            if (function instanceof FloatMult) {
                int k = this.size;
                while (--k >= 0) {
                    this.elements[idx += this.stride] = this.elements[idx] * multiplicator;
                }
            } else {
                int k = this.size;
                while (--k >= 0) {
                    this.elements[idx += this.stride] = function.apply(this.elements[idx]);
                }
            }
        }
        return this;
    }

    @Override
    public FloatMatrix1D assign(final FloatProcedure cond, final FloatFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFloatMatrix1D.this.zero + firstIdx * DenseFloatMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            if (cond.apply(DenseFloatMatrix1D.this.elements[idx])) {
                                DenseFloatMatrix1D.this.elements[idx] = function.apply(DenseFloatMatrix1D.this.elements[idx]);
                            }
                            idx += DenseFloatMatrix1D.this.stride;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                if (cond.apply(this.elements[idx])) {
                    this.elements[idx] = function.apply(this.elements[idx]);
                }
                idx += this.stride;
                ++i;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix1D assign(final FloatProcedure cond, final float value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFloatMatrix1D.this.zero + firstIdx * DenseFloatMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            if (cond.apply(DenseFloatMatrix1D.this.elements[idx])) {
                                DenseFloatMatrix1D.this.elements[idx] = value;
                            }
                            idx += DenseFloatMatrix1D.this.stride;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                if (cond.apply(this.elements[idx])) {
                    this.elements[idx] = value;
                }
                idx += this.stride;
                ++i;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix1D assign(final float value) {
        final float[] elems = this.elements;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFloatMatrix1D.this.zero + firstIdx * DenseFloatMatrix1D.this.stride;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            elems[idx] = value;
                            idx += DenseFloatMatrix1D.this.stride;
                            ++k;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                elems[idx] = value;
                idx += this.stride;
                ++i;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix1D assign(final float[] values) {
        if (values.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + "size()=" + this.size());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFloatMatrix1D.this.zero + firstIdx * DenseFloatMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            DenseFloatMatrix1D.this.elements[idx] = values[i];
                            idx += DenseFloatMatrix1D.this.stride;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                this.elements[idx] = values[i];
                idx += this.stride;
                ++i;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix1D assign(FloatMatrix1D source) {
        if (!(source instanceof DenseFloatMatrix1D)) {
            super.assign(source);
            return this;
        }
        DenseFloatMatrix1D other = (DenseFloatMatrix1D)source;
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            FloatMatrix1D c = other.copy();
            if (!(c instanceof DenseFloatMatrix1D)) {
                super.assign(source);
                return this;
            }
            other = (DenseFloatMatrix1D)c;
        }
        final float[] elementsOther = other.elements;
        if (this.elements == null || elementsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFloatMatrix1D.this.zero + firstIdx * DenseFloatMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            DenseFloatMatrix1D.this.elements[idx] = elementsOther[idxOther];
                            idx += DenseFloatMatrix1D.this.stride;
                            idxOther += strideOther;
                            ++k;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            int k = 0;
            while (k < this.size) {
                this.elements[idx] = elementsOther[idxOther];
                idx += this.stride;
                idxOther += strideOther;
                ++k;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix1D assign(FloatMatrix1D y, final FloatFloatFunction function) {
        if (!(y instanceof DenseFloatMatrix1D)) {
            super.assign(y, function);
            return this;
        }
        this.checkSize(y);
        final int zeroOther = (int)y.index(0);
        final int strideOther = y.stride();
        final float[] elementsOther = (float[])y.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFloatMatrix1D.this.zero + firstIdx * DenseFloatMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        if (function == FloatFunctions.mult) {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                int n = idx;
                                DenseFloatMatrix1D.this.elements[n] = DenseFloatMatrix1D.this.elements[n] * elementsOther[idxOther];
                                idx += DenseFloatMatrix1D.this.stride;
                                idxOther += strideOther;
                                ++k;
                            }
                        } else if (function == FloatFunctions.div) {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                int n = idx;
                                DenseFloatMatrix1D.this.elements[n] = DenseFloatMatrix1D.this.elements[n] / elementsOther[idxOther];
                                idx += DenseFloatMatrix1D.this.stride;
                                idxOther += strideOther;
                                ++k;
                            }
                        } else if (function instanceof FloatPlusMultFirst) {
                            float multiplicator = ((FloatPlusMultFirst)function).multiplicator;
                            if (multiplicator == 0.0f) {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    DenseFloatMatrix1D.this.elements[idx] = elementsOther[idxOther];
                                    idx += DenseFloatMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            } else if (multiplicator == 1.0f) {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    int n = idx;
                                    DenseFloatMatrix1D.this.elements[n] = DenseFloatMatrix1D.this.elements[n] + elementsOther[idxOther];
                                    idx += DenseFloatMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            } else if (multiplicator == -1.0f) {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    DenseFloatMatrix1D.this.elements[idx] = elementsOther[idxOther] - DenseFloatMatrix1D.this.elements[idx];
                                    idx += DenseFloatMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            } else {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    DenseFloatMatrix1D.this.elements[idx] = multiplicator * DenseFloatMatrix1D.this.elements[idx] + elementsOther[idxOther];
                                    idx += DenseFloatMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            }
                        } else if (function instanceof FloatPlusMultSecond) {
                            float multiplicator = ((FloatPlusMultSecond)function).multiplicator;
                            if (multiplicator == 0.0f) {
                                return;
                            }
                            if (multiplicator == 1.0f) {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    int n = idx;
                                    DenseFloatMatrix1D.this.elements[n] = DenseFloatMatrix1D.this.elements[n] + elementsOther[idxOther];
                                    idx += DenseFloatMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            } else if (multiplicator == -1.0f) {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    int n = idx;
                                    DenseFloatMatrix1D.this.elements[n] = DenseFloatMatrix1D.this.elements[n] - elementsOther[idxOther];
                                    idx += DenseFloatMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            } else {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    int n = idx;
                                    DenseFloatMatrix1D.this.elements[n] = DenseFloatMatrix1D.this.elements[n] + multiplicator * elementsOther[idxOther];
                                    idx += DenseFloatMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            }
                        } else {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                DenseFloatMatrix1D.this.elements[idx] = function.apply(DenseFloatMatrix1D.this.elements[idx], elementsOther[idxOther]);
                                idx += DenseFloatMatrix1D.this.stride;
                                idxOther += strideOther;
                                ++k;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            if (function == FloatFunctions.mult) {
                int k = 0;
                while (k < this.size) {
                    int n = idx;
                    this.elements[n] = this.elements[n] * elementsOther[idxOther];
                    idx += this.stride;
                    idxOther += strideOther;
                    ++k;
                }
            } else if (function == FloatFunctions.div) {
                int k = 0;
                while (k < this.size) {
                    int n = idx;
                    this.elements[n] = this.elements[n] / elementsOther[idxOther];
                    idx += this.stride;
                    idxOther += strideOther;
                    ++k;
                }
            } else if (function instanceof FloatPlusMultSecond) {
                float multiplicator = ((FloatPlusMultSecond)function).multiplicator;
                if (multiplicator == 0.0f) {
                    return this;
                }
                if (multiplicator == 1.0f) {
                    int k = 0;
                    while (k < this.size) {
                        int n = idx;
                        this.elements[n] = this.elements[n] + elementsOther[idxOther];
                        idx += this.stride;
                        idxOther += strideOther;
                        ++k;
                    }
                } else if (multiplicator == -1.0f) {
                    int k = 0;
                    while (k < this.size) {
                        int n = idx;
                        this.elements[n] = this.elements[n] - elementsOther[idxOther];
                        idx += this.stride;
                        idxOther += strideOther;
                        ++k;
                    }
                } else {
                    int k = 0;
                    while (k < this.size) {
                        int n = idx;
                        this.elements[n] = this.elements[n] + multiplicator * elementsOther[idxOther];
                        idx += this.stride;
                        idxOther += strideOther;
                        ++k;
                    }
                }
            } else {
                int k = 0;
                while (k < this.size) {
                    this.elements[idx] = function.apply(this.elements[idx], elementsOther[idxOther]);
                    idx += this.stride;
                    idxOther += strideOther;
                    ++k;
                }
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int idx = DenseFloatMatrix1D.this.zero + firstIdx * DenseFloatMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            if (DenseFloatMatrix1D.this.elements[idx] != 0.0f) {
                                ++cardinality;
                            }
                            idx += DenseFloatMatrix1D.this.stride;
                            ++i;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                if (this.elements[idx] != 0.0f) {
                    ++cardinality;
                }
                idx += this.stride;
                ++i;
            }
        }
        return cardinality;
    }

    public void dct(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct == null) {
            this.dct = new FloatDCT_1D(this.size);
        }
        if (this.isNoView) {
            this.dct.forward(this.elements, scale);
        } else {
            FloatMatrix1D copy = this.copy();
            this.dct.forward((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dht() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht == null) {
            this.dht = new FloatDHT_1D(this.size);
        }
        if (this.isNoView) {
            this.dht.forward(this.elements);
        } else {
            FloatMatrix1D copy = this.copy();
            this.dht.forward((float[])copy.elements());
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dst(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst == null) {
            this.dst = new FloatDST_1D(this.size);
        }
        if (this.isNoView) {
            this.dst.forward(this.elements, scale);
        } else {
            FloatMatrix1D copy = this.copy();
            this.dst.forward((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public float[] elements() {
        return this.elements;
    }

    public void fft() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft == null) {
            this.fft = new FloatFFT_1D(this.size);
        }
        if (this.isNoView) {
            this.fft.realForward(this.elements);
        } else {
            FloatMatrix1D copy = this.copy();
            this.fft.realForward((float[])copy.elements());
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public DenseFComplexMatrix1D getFft() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        float[] elems = this.isNoView ? this.elements : (float[])this.copy().elements();
        DenseFComplexMatrix1D c = new DenseFComplexMatrix1D(this.size);
        float[] elementsC = c.elements();
        System.arraycopy(elems, 0, elementsC, 0, this.size);
        if (this.fft == null) {
            this.fft = new FloatFFT_1D(this.size);
        }
        this.fft.realForwardFull(elementsC);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return c;
    }

    public DenseFComplexMatrix1D getIfft(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        float[] elems = this.isNoView ? this.elements : (float[])this.copy().elements();
        DenseFComplexMatrix1D c = new DenseFComplexMatrix1D(this.size);
        float[] elementsC = c.elements();
        System.arraycopy(elems, 0, elementsC, 0, this.size);
        if (this.fft == null) {
            this.fft = new FloatFFT_1D(this.size);
        }
        this.fft.realInverseFull(elementsC, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return c;
    }

    @Override
    public void getNonZeros(IntArrayList indexList, FloatArrayList valueList) {
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        int rem = this.size % 2;
        int idx = this.zero;
        if (rem == 1) {
            float value = this.elements[idx];
            if (value != 0.0f) {
                if (fillIndexList) {
                    indexList.add(0);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            idx += this.stride;
        }
        int i = rem;
        while (i < this.size) {
            float value = this.elements[idx];
            if (value != 0.0f) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            if ((value = this.elements[idx += this.stride]) != 0.0f) {
                if (fillIndexList) {
                    indexList.add(i + 1);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            idx += this.stride;
            i += 2;
        }
    }

    @Override
    public void getPositiveValues(IntArrayList indexList, FloatArrayList valueList) {
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        int rem = this.size % 2;
        int idx = this.zero;
        if (rem == 1) {
            float value = this.elements[idx];
            if (value > 0.0f) {
                if (fillIndexList) {
                    indexList.add(0);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            idx += this.stride;
        }
        int i = rem;
        while (i < this.size) {
            float value = this.elements[idx];
            if (value > 0.0f) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            if ((value = this.elements[idx += this.stride]) > 0.0f) {
                if (fillIndexList) {
                    indexList.add(i + 1);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            idx += this.stride;
            i += 2;
        }
    }

    @Override
    public void getNegativeValues(IntArrayList indexList, FloatArrayList valueList) {
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        int rem = this.size % 2;
        int idx = this.zero;
        if (rem == 1) {
            float value = this.elements[idx];
            if (value < 0.0f) {
                if (fillIndexList) {
                    indexList.add(0);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            idx += this.stride;
        }
        int i = rem;
        while (i < this.size) {
            float value = this.elements[idx];
            if (value < 0.0f) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            if ((value = this.elements[idx += this.stride]) < 0.0f) {
                if (fillIndexList) {
                    indexList.add(i + 1);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            idx += this.stride;
            i += 2;
        }
    }

    @Override
    public float[] getMaxLocation() {
        int location = 0;
        float maxValue = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int idx = DenseFloatMatrix1D.this.zero + firstIdx * DenseFloatMatrix1D.this.stride;
                        float maxValue = DenseFloatMatrix1D.this.elements[idx];
                        int location = (idx - DenseFloatMatrix1D.this.zero) / DenseFloatMatrix1D.this.stride;
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            if (maxValue < DenseFloatMatrix1D.this.elements[idx += DenseFloatMatrix1D.this.stride]) {
                                maxValue = DenseFloatMatrix1D.this.elements[idx];
                                location = (idx - DenseFloatMatrix1D.this.zero) / DenseFloatMatrix1D.this.stride;
                            }
                            ++i;
                        }
                        return new float[]{maxValue, location};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (float[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                location = (int)results[0][1];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        location = (int)results[j][1];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[this.zero];
            location = 0;
            int idx = this.zero;
            int i = 1;
            while (i < this.size) {
                if (maxValue < this.elements[idx += this.stride]) {
                    maxValue = this.elements[idx];
                    location = (idx - this.zero) / this.stride;
                }
                ++i;
            }
        }
        return new float[]{maxValue, location};
    }

    @Override
    public float[] getMinLocation() {
        int location = 0;
        float minValue = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int idx = DenseFloatMatrix1D.this.zero + firstIdx * DenseFloatMatrix1D.this.stride;
                        float minValue = DenseFloatMatrix1D.this.elements[idx];
                        int location = (idx - DenseFloatMatrix1D.this.zero) / DenseFloatMatrix1D.this.stride;
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            if (minValue > DenseFloatMatrix1D.this.elements[idx += DenseFloatMatrix1D.this.stride]) {
                                minValue = DenseFloatMatrix1D.this.elements[idx];
                                location = (idx - DenseFloatMatrix1D.this.zero) / DenseFloatMatrix1D.this.stride;
                            }
                            ++i;
                        }
                        return new float[]{minValue, location};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (float[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                location = (int)results[0][1];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        location = (int)results[j][1];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[this.zero];
            location = 0;
            int idx = this.zero;
            int i = 1;
            while (i < this.size) {
                if (minValue > this.elements[idx += this.stride]) {
                    minValue = this.elements[idx];
                    location = (idx - this.zero) / this.stride;
                }
                ++i;
            }
        }
        return new float[]{minValue, location};
    }

    @Override
    public float getQuick(int index) {
        return this.elements[this.zero + index * this.stride];
    }

    public void idct(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct == null) {
            this.dct = new FloatDCT_1D(this.size);
        }
        if (this.isNoView) {
            this.dct.inverse(this.elements, scale);
        } else {
            FloatMatrix1D copy = this.copy();
            this.dct.inverse((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idht(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht == null) {
            this.dht = new FloatDHT_1D(this.size);
        }
        if (this.isNoView) {
            this.dht.inverse(this.elements, scale);
        } else {
            FloatMatrix1D copy = this.copy();
            this.dht.inverse((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idst(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst == null) {
            this.dst = new FloatDST_1D(this.size);
        }
        if (this.isNoView) {
            this.dst.inverse(this.elements, scale);
        } else {
            FloatMatrix1D copy = this.copy();
            this.dst.inverse((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void ifft(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft == null) {
            this.fft = new FloatFFT_1D(this.size);
        }
        if (this.isNoView) {
            this.fft.realInverse(this.elements, scale);
        } else {
            FloatMatrix1D copy = this.copy();
            this.fft.realInverse((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public FloatMatrix1D like(int size) {
        return new DenseFloatMatrix1D(size);
    }

    @Override
    public FloatMatrix2D like2D(int rows, int columns) {
        return new DenseFloatMatrix2D(rows, columns);
    }

    @Override
    public FloatMatrix2D reshape(final int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        DenseFloatMatrix2D M = new DenseFloatMatrix2D(rows, columns);
        final float[] elementsOther = (float[])((FloatMatrix2D)M).elements();
        final int zeroOther = (int)((AbstractMatrix2D)M).index(0, 0);
        final int rowStrideOther = M.rowStride();
        final int columnStrideOther = M.columnStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int idxOther = zeroOther + c * columnStrideOther;
                            int idx = DenseFloatMatrix1D.this.zero + c * rows * DenseFloatMatrix1D.this.stride;
                            int r = 0;
                            while (r < rows) {
                                elementsOther[idxOther] = DenseFloatMatrix1D.this.elements[idx];
                                idxOther += rowStrideOther;
                                idx += DenseFloatMatrix1D.this.stride;
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int c = 0;
            while (c < columns) {
                int idxOther = zeroOther + c * columnStrideOther;
                int r = 0;
                while (r < rows) {
                    elementsOther[idxOther] = this.elements[idx];
                    idxOther += rowStrideOther;
                    idx += this.stride;
                    ++r;
                }
                ++c;
            }
        }
        return M;
    }

    @Override
    public FloatMatrix3D reshape(int slices, final int rows, final int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        DenseFloatMatrix3D M = new DenseFloatMatrix3D(slices, rows, columns);
        final float[] elementsOther = (float[])((FloatMatrix3D)M).elements();
        final int zeroOther = (int)((AbstractMatrix3D)M).index(0, 0, 0);
        final int sliceStrideOther = M.sliceStride();
        final int rowStrideOther = M.rowStride();
        final int columnStrideOther = M.columnStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int c = 0;
                            while (c < columns) {
                                int idxOther = zeroOther + s * sliceStrideOther + c * columnStrideOther;
                                int idx = DenseFloatMatrix1D.this.zero + (s * rows * columns + c * rows) * DenseFloatMatrix1D.this.stride;
                                int r = 0;
                                while (r < rows) {
                                    elementsOther[idxOther] = DenseFloatMatrix1D.this.elements[idx];
                                    idxOther += rowStrideOther;
                                    idx += DenseFloatMatrix1D.this.stride;
                                    ++r;
                                }
                                ++c;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int s = 0;
            while (s < slices) {
                int c = 0;
                while (c < columns) {
                    int idxOther = zeroOther + s * sliceStrideOther + c * columnStrideOther;
                    int r = 0;
                    while (r < rows) {
                        elementsOther[idxOther] = this.elements[idx];
                        idxOther += rowStrideOther;
                        idx += this.stride;
                        ++r;
                    }
                    ++c;
                }
                ++s;
            }
        }
        return M;
    }

    @Override
    public void setQuick(int index, float value) {
        this.elements[this.zero + index * this.stride] = value;
    }

    @Override
    public void swap(FloatMatrix1D other) {
        DenseFloatMatrix1D y;
        if (!(other instanceof DenseFloatMatrix1D)) {
            super.swap(other);
        }
        if ((y = (DenseFloatMatrix1D)other) == this) {
            return;
        }
        this.checkSize(y);
        final float[] elementsOther = y.elements;
        if (this.elements == null || elementsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFloatMatrix1D.this.zero + firstIdx * DenseFloatMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            float tmp = DenseFloatMatrix1D.this.elements[idx];
                            DenseFloatMatrix1D.this.elements[idx] = elementsOther[idxOther];
                            elementsOther[idxOther] = tmp;
                            idx += DenseFloatMatrix1D.this.stride;
                            idxOther += strideOther;
                            ++k;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            int k = 0;
            while (k < this.size) {
                float tmp = this.elements[idx];
                this.elements[idx] = elementsOther[idxOther];
                elementsOther[idxOther] = tmp;
                idx += this.stride;
                idxOther += strideOther;
                ++k;
            }
        }
    }

    @Override
    public void toArray(float[] values) {
        if (values.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, values, 0, this.elements.length);
        } else {
            super.toArray(values);
        }
    }

    @Override
    public float zDotProduct(FloatMatrix1D y, int from, int length) {
        if (!(y instanceof DenseFloatMatrix1D)) {
            return super.zDotProduct(y, from, length);
        }
        DenseFloatMatrix1D yy = (DenseFloatMatrix1D)y;
        int tail = from + length;
        if (from < 0 || length < 0) {
            return 0.0f;
        }
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size() < (long)tail) {
            tail = (int)y.size();
        }
        final float[] elementsOther = yy.elements;
        int zeroThis = (int)this.index(from);
        int zeroOther = (int)yy.index(from);
        int strideOther = yy.stride;
        if (this.elements == null || elementsOther == null) {
            throw new InternalError();
        }
        float sum = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && length >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            final int zeroThisF = zeroThis;
            final int zeroOtherF = zeroOther;
            final int strideOtherF = strideOther;
            nthreads = Math.min(nthreads, length);
            Future[] futures = new Future[nthreads];
            Float[] results = new Float[nthreads];
            int k = length / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        int idx = zeroThisF + firstIdx * DenseFloatMatrix1D.this.stride;
                        int idxOther = zeroOtherF + firstIdx * strideOtherF;
                        idx -= DenseFloatMatrix1D.this.stride;
                        idxOther -= strideOtherF;
                        float sum = 0.0f;
                        int min = lastIdx - firstIdx;
                        int k = min / 4;
                        while (--k >= 0) {
                            int n = idx + DenseFloatMatrix1D.this.stride;
                            idx = n;
                            int n2 = idxOther + strideOtherF;
                            idxOther = n2;
                            int n3 = idx + DenseFloatMatrix1D.this.stride;
                            idx = n3;
                            int n4 = idxOther + strideOtherF;
                            idxOther = n4;
                            idx = idx + DenseFloatMatrix1D.this.stride;
                            idxOther = idxOther + strideOtherF;
                            sum += DenseFloatMatrix1D.this.elements[n] * elementsOther[n2] + DenseFloatMatrix1D.this.elements[n3] * elementsOther[n4] + DenseFloatMatrix1D.this.elements[idx] * elementsOther[idxOther] + DenseFloatMatrix1D.this.elements[idx += DenseFloatMatrix1D.this.stride] * elementsOther[idxOther += strideOtherF];
                        }
                        k = min % 4;
                        while (--k >= 0) {
                            sum += DenseFloatMatrix1D.this.elements[idx += DenseFloatMatrix1D.this.stride] * elementsOther[idxOther += strideOtherF];
                        }
                        return Float.valueOf(sum);
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Float)futures[j].get();
                    ++j;
                }
                sum = results[0].floatValue();
                j = 1;
                while (j < nthreads) {
                    sum += results[j].floatValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            zeroThis -= this.stride;
            zeroOther -= strideOther;
            int min = tail - from;
            int k = min / 4;
            while (--k >= 0) {
                int n = zeroThis + this.stride;
                zeroThis = n;
                int n2 = zeroOther + strideOther;
                zeroOther = n2;
                int n3 = zeroThis + this.stride;
                zeroThis = n3;
                int n4 = zeroOther + strideOther;
                zeroOther = n4;
                zeroThis = zeroThis + this.stride;
                zeroOther = zeroOther + strideOther;
                sum += this.elements[n] * elementsOther[n2] + this.elements[n3] * elementsOther[n4] + this.elements[zeroThis] * elementsOther[zeroOther] + this.elements[zeroThis += this.stride] * elementsOther[zeroOther += strideOther];
            }
            k = min % 4;
            while (--k >= 0) {
                sum += this.elements[zeroThis += this.stride] * elementsOther[zeroOther += strideOther];
            }
        }
        return sum;
    }

    @Override
    public float zSum() {
        float sum = 0.0f;
        final float[] elems = this.elements;
        if (elems == null) {
            throw new InternalError();
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            Float[] results = new Float[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float sum = 0.0f;
                        int idx = DenseFloatMatrix1D.this.zero + firstIdx * DenseFloatMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            sum += elems[idx];
                            idx += DenseFloatMatrix1D.this.stride;
                            ++i;
                        }
                        return Float.valueOf(sum);
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Float)futures[j].get();
                    ++j;
                }
                sum = results[0].floatValue();
                j = 1;
                while (j < nthreads) {
                    sum += results[j].floatValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = this.zero;
            int k = 0;
            while (k < this.size) {
                sum += elems[idx];
                idx += this.stride;
                ++k;
            }
        }
        return sum;
    }

    @Override
    protected int cardinality(int maxCardinality) {
        int cardinality = 0;
        int index = this.zero;
        float[] elems = this.elements;
        int i = this.size;
        while (--i >= 0 && cardinality < maxCardinality) {
            if (elems[index] != 0.0f) {
                ++cardinality;
            }
            index += this.stride;
        }
        return cardinality;
    }

    @Override
    protected boolean haveSharedCellsRaw(FloatMatrix1D other) {
        if (other instanceof SelectedDenseFloatMatrix1D) {
            SelectedDenseFloatMatrix1D otherMatrix = (SelectedDenseFloatMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseFloatMatrix1D) {
            DenseFloatMatrix1D otherMatrix = (DenseFloatMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int rank) {
        return this.zero + rank * this.stride;
    }

    @Override
    protected FloatMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseFloatMatrix1D(this.elements, offsets);
    }
}

