/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;

public class WrapperDoubleMatrix1D
extends DoubleMatrix1D {
    private static final long serialVersionUID = 1L;
    protected DoubleMatrix1D content;

    public WrapperDoubleMatrix1D(DoubleMatrix1D newContent) {
        if (newContent != null) {
            this.setUp((int)newContent.size());
        }
        this.content = newContent;
    }

    @Override
    protected DoubleMatrix1D getContent() {
        return this.content;
    }

    @Override
    public synchronized double getQuick(int index) {
        return this.content.getQuick(index);
    }

    @Override
    public Object elements() {
        return this.content.elements();
    }

    @Override
    public DoubleMatrix1D like(int size) {
        return this.content.like(size);
    }

    @Override
    public DoubleMatrix2D like2D(int rows, int columns) {
        return this.content.like2D(rows, columns);
    }

    @Override
    public DoubleMatrix2D reshape(int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public DoubleMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public synchronized void setQuick(int index, double value) {
        this.content.setQuick(index, value);
    }

    @Override
    public DoubleMatrix1D viewFlip() {
        WrapperDoubleMatrix1D view = new WrapperDoubleMatrix1D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized double getQuick(int index) {
                return this.content.getQuick(this.size - 1 - index);
            }

            @Override
            public synchronized void setQuick(int index, double value) {
                this.content.setQuick(this.size - 1 - index, value);
            }

            @Override
            public synchronized double get(int index) {
                return this.content.get(this.size - 1 - index);
            }

            @Override
            public synchronized void set(int index, double value) {
                this.content.set(this.size - 1 - index, value);
            }
        };
        return view;
    }

    @Override
    public DoubleMatrix1D viewPart(final int index, int width) {
        this.checkRange(index, width);
        WrapperDoubleMatrix1D view = new WrapperDoubleMatrix1D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized double getQuick(int i) {
                return this.content.getQuick(index + i);
            }

            @Override
            public synchronized void setQuick(int i, double value) {
                this.content.setQuick(index + i, value);
            }

            @Override
            public synchronized double get(int i) {
                return this.content.get(index + i);
            }

            @Override
            public synchronized void set(int i, double value) {
                this.content.set(index + i, value);
            }
        };
        view.size = width;
        return view;
    }

    @Override
    public DoubleMatrix1D viewSelection(int[] indexes) {
        if (indexes == null) {
            indexes = new int[this.size];
            int i = this.size;
            while (--i >= 0) {
                indexes[i] = i;
            }
        }
        this.checkIndexes(indexes);
        final int[] idx = indexes;
        WrapperDoubleMatrix1D view = new WrapperDoubleMatrix1D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized double getQuick(int i) {
                return this.content.getQuick(idx[i]);
            }

            @Override
            public synchronized void setQuick(int i, double value) {
                this.content.setQuick(idx[i], value);
            }

            @Override
            public synchronized double get(int i) {
                return this.content.get(idx[i]);
            }

            @Override
            public synchronized void set(int i, double value) {
                this.content.set(idx[i], value);
            }
        };
        view.size = indexes.length;
        return view;
    }

    @Override
    protected DoubleMatrix1D viewSelectionLike(int[] offsets) {
        throw new InternalError();
    }

    @Override
    public DoubleMatrix1D viewStrides(final int _stride) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperDoubleMatrix1D view = new WrapperDoubleMatrix1D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized double getQuick(int index) {
                return this.content.getQuick(index * _stride);
            }

            @Override
            public synchronized void setQuick(int index, double value) {
                this.content.setQuick(index * _stride, value);
            }

            @Override
            public synchronized double get(int index) {
                return this.content.get(index * _stride);
            }

            @Override
            public synchronized void set(int index, double value) {
                this.content.set(index * _stride, value);
            }
        };
        if (this.size != 0) {
            view.size = (this.size - 1) / _stride + 1;
        }
        return view;
    }
}

