/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv.impl;

import mitiv.array.FloatArray;
import mitiv.array.ShapedArray;
import mitiv.deconv.Convolution;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public abstract class ConvolutionFloat
extends Convolution {
    private float[] tmp = null;
    private float[] mtf = null;

    protected ConvolutionFloat(ShapedVectorSpace space) {
        super(space);
        if (space.getType() != 4) {
            throw new IllegalArgumentException("Vector space must be for float data type");
        }
    }

    protected ConvolutionFloat(ShapedVectorSpace inp, ShapedVectorSpace out) {
        super(inp, out);
        if (inp.getType() != 4) {
            throw new IllegalArgumentException("Input vector space must be for float data type");
        }
        if (out.getType() != 4) {
            throw new IllegalArgumentException("Output vector space must be for float data type");
        }
    }

    public float[] getWorkspace() {
        if (this.tmp == null) {
            this.tmp = new float[2 * this.number];
        }
        return this.tmp;
    }

    @Override
    public void push(ShapedVector inp) {
        if (!inp.belongsTo(this.inputSpace)) {
            throw new IncorrectSpaceException("Vector does not belong to input space");
        }
        this.push(((FloatShapedVector)inp).getData());
    }

    public void push(float[] x) {
        float zero = 0.0f;
        float[] z = this.getWorkspace();
        if (x == null || x.length != this.number) {
            throw new IllegalArgumentException("Bad input size");
        }
        int k = 0;
        while (k < this.number) {
            int real = k + k;
            int imag = real + 1;
            z[real] = x[k];
            z[imag] = 0.0f;
            ++k;
        }
    }

    @Override
    public void pull(ShapedVector out) {
        if (!out.belongsTo(this.outputSpace)) {
            throw new IncorrectSpaceException("Vector does not belong to output space");
        }
        this.pull(((FloatShapedVector)out).getData());
    }

    public abstract void pull(float[] var1);

    public abstract void forwardFFT(float[] var1);

    @Override
    public void forwardFFT() {
        this.forwardFFT(this.getWorkspace());
    }

    public abstract void backwardFFT(float[] var1);

    @Override
    public void backwardFFT() {
        this.forwardFFT(this.getWorkspace());
    }

    @Override
    public void convolve(boolean conj) {
        if (this.mtf == null) {
            throw new IllegalArgumentException("You must set the PSF or the MTF first");
        }
        float[] h = this.mtf;
        float[] z = this.getWorkspace();
        this.forwardFFT();
        if (conj) {
            int k = 0;
            while (k < this.number) {
                int real = k + k;
                int imag = real + 1;
                float h_re = h[real];
                float h_im = h[imag];
                float z_re = z[real];
                float z_im = z[imag];
                z[real] = h_re * z_re + h_im * z_im;
                z[imag] = h_re * z_im - h_im * z_re;
                ++k;
            }
        } else {
            int k = 0;
            while (k < this.number) {
                int real = k + k;
                int imag = real + 1;
                float h_re = h[real];
                float h_im = h[imag];
                float z_re = z[real];
                float z_im = z[imag];
                z[real] = h_re * z_re - h_im * z_im;
                z[imag] = h_re * z_im + h_im * z_re;
                ++k;
            }
        }
        this.backwardFFT(z);
    }

    @Override
    public void setPSF(ShapedVector psf) {
        if (!psf.belongsTo(this.inputSpace)) {
            throw new IncorrectSpaceException("PSF does not belong to the correct space");
        }
        this.computeMTF(((FloatShapedVector)psf).getData());
    }

    @Override
    public void setPSF(ShapedArray psf, int[] cen) {
        psf = this.adjustPSF(psf.toFloat(), cen);
        this.computeMTF(((FloatArray)psf).flatten());
    }

    private final void computeMTF(float[] psf) {
        float zero = 0.0f;
        if (this.mtf == null) {
            this.mtf = new float[2 * this.number];
        }
        int k = 0;
        while (k < this.number) {
            int real = k + k;
            int imag = real + 1;
            this.mtf[real] = psf[k];
            this.mtf[imag] = 0.0f;
            ++k;
        }
        this.forwardFFT(this.mtf);
    }
}

