/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.array.ArrayUtils;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.deconv.impl.ConvolutionDouble1D;
import mitiv.deconv.impl.ConvolutionDouble2D;
import mitiv.deconv.impl.ConvolutionDouble3D;
import mitiv.deconv.impl.ConvolutionFloat1D;
import mitiv.deconv.impl.ConvolutionFloat2D;
import mitiv.deconv.impl.ConvolutionFloat3D;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NotImplementedException;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.ShapedLinearOperator;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.utils.Timer;

public abstract class Convolution
extends ShapedLinearOperator {
    protected final int number;
    protected Timer timerForFFT = new Timer();
    protected Timer timer = new Timer();

    protected Convolution(ShapedVectorSpace space) {
        this(space, space);
    }

    protected Convolution(ShapedVectorSpace inp, ShapedVectorSpace out) {
        super(inp, out);
        this.number = inp.getNumber();
    }

    public final int getRank() {
        return this.getInputSpace().getRank();
    }

    public final int getType() {
        return this.getInputSpace().getType();
    }

    public final int getNumber() {
        return this.number;
    }

    public static Convolution build(ShapedVectorSpace space) {
        int type = space.getType();
        int rank = space.getRank();
        switch (type) {
            case 4: {
                switch (rank) {
                    case 1: {
                        return new ConvolutionFloat1D(space);
                    }
                    case 2: {
                        return new ConvolutionFloat2D(space);
                    }
                    case 3: {
                        return new ConvolutionFloat3D(space);
                    }
                }
                break;
            }
            case 5: {
                switch (rank) {
                    case 1: {
                        return new ConvolutionDouble1D(space);
                    }
                    case 2: {
                        return new ConvolutionDouble2D(space);
                    }
                    case 3: {
                        return new ConvolutionDouble3D(space);
                    }
                }
                break;
            }
            default: {
                throw new IllegalTypeException("Only float and double types are implemented.");
            }
        }
        throw new IllegalArgumentException("Only 1D, 2D and 3D convolution are implemented.");
    }

    public static Convolution build(ShapedVectorSpace inp, ShapedVectorSpace out) {
        int rank = Math.min(inp.getRank(), out.getRank());
        int[] off = new int[rank];
        int k = 0;
        while (k < rank) {
            off[k] = inp.getDimension(k) / 2 - out.getDimension(k) / 2;
            ++k;
        }
        return Convolution.build(inp, out, off);
    }

    public static Convolution build(ShapedVectorSpace inp, ShapedVectorSpace out, int[] off) {
        int type = inp.getType();
        if (out.getType() != type) {
            throw new IllegalTypeException("Input and output spaces must have same element type.");
        }
        int rank = inp.getRank();
        if (out.getShape().rank() != rank) {
            throw new IllegalTypeException("Input and output spaces must have same rank.");
        }
        switch (type) {
            case 4: {
                switch (rank) {
                    case 1: {
                        return new ConvolutionFloat1D(inp, out, off);
                    }
                    case 2: {
                        return new ConvolutionFloat2D(inp, out, off);
                    }
                    case 3: {
                        return new ConvolutionFloat3D(inp, out, off);
                    }
                }
                break;
            }
            case 5: {
                switch (rank) {
                    case 1: {
                        return new ConvolutionDouble1D(inp, out, off);
                    }
                    case 2: {
                        return new ConvolutionDouble2D(inp, out, off);
                    }
                    case 3: {
                        return new ConvolutionDouble3D(inp, out, off);
                    }
                }
                break;
            }
            default: {
                throw new IllegalTypeException("Only float and double types are implemented.");
            }
        }
        throw new IllegalArgumentException("Only 1D, 2D and 3D convolution are implemented.");
    }

    public abstract void forwardFFT();

    public abstract void backwardFFT();

    public abstract void push(ShapedVector var1);

    public abstract void pull(ShapedVector var1);

    public abstract void convolve(boolean var1);

    public abstract void setPSF(ShapedVector var1);

    public static int[] center(Shape shape) {
        int rank = shape.rank();
        int[] off = new int[rank];
        int k = 0;
        while (k < rank) {
            off[k] = shape.dimension(k) / 2;
            ++k;
        }
        return off;
    }

    public void setPSF(ShapedArray arr) {
        this.setPSF(arr, Convolution.center(arr.getShape()));
    }

    public abstract void setPSF(ShapedArray var1, int[] var2);

    protected ShapedArray adjustPSF(ShapedArray psf, int[] off) {
        Shape psfShape = psf.getShape();
        Shape inpShape = this.getInputSpace().getShape();
        int rank = inpShape.rank();
        if (psfShape.rank() != rank) {
            throw new IllegalArgumentException("PSF rank not conformable.");
        }
        if (off.length != rank) {
            throw new IllegalArgumentException("Number of coordinates not conformable.");
        }
        int[] shift = new int[rank];
        int k = 0;
        while (k < rank) {
            int dstDim;
            int srcDim = psfShape.dimension(k);
            if (srcDim > (dstDim = inpShape.dimension(k))) {
                throw new IllegalArgumentException("PSF dimension(s) too large.");
            }
            int margin = dstDim / 2 - srcDim / 2;
            shift[k] = -(margin + off[k]);
            ++k;
        }
        return ArrayUtils.roll(ArrayUtils.pad(psf, inpShape), shift);
    }

    @Override
    protected void _apply(Vector dst, Vector src, int job) {
        if (job != DIRECT && job != ADJOINT) {
            throw new NotImplementedException("For now we do not implement inverse convolution operations (talk to a specialist if you ignore the dangers of doing that!)");
        }
        this.push((ShapedVector)src);
        this.convolve(job == ADJOINT);
        this.pull((ShapedVector)dst);
    }

    public void resetTimers() {
        this.timerForFFT.stop();
        this.timerForFFT.reset();
        this.timer.stop();
        this.timer.reset();
    }

    public double getElapsedTime() {
        return this.timer.getElapsedTime();
    }

    public double getElapsedTimeInFFT() {
        return this.timerForFFT.getElapsedTime();
    }
}

