/*
 * Decompiled with CFR 0.152.
 */
package mitiv.tests;

import mitiv.exception.IllegalLinearOperationException;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.ArrayOps;
import mitiv.linalg.LinearConjugateGradient;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;

public class LinearConjGradTest {
    static double[][] arrA = new double[][]{{3.0, 2.0}, {2.0, 3.0}};
    static double[] arrX = new double[]{7.0, -13.0};

    public static void main(String[] args) throws IncorrectSpaceException {
        DoubleShapedVectorSpace vsp = new DoubleShapedVectorSpace(arrX.length);
        DoubleShapedVector x0 = vsp.wrap(arrX);
        DoubleShapedVector x = vsp.create(0.0);
        DoubleShapedVector b = vsp.create();
        LinearOperator A = new LinearOperator(vsp){

            @Override
            protected void privApply(Vector src, Vector dst, int job) {
                if (job != DIRECT && job != ADJOINT) {
                    throw new IllegalLinearOperationException();
                }
                double[] x = ((DoubleShapedVector)src).getData();
                double[] y = ((DoubleShapedVector)dst).getData();
                int i = 0;
                while (i < y.length) {
                    y[i] = ArrayOps.dot(arrA[i], x);
                    ++i;
                }
            }
        };
        A.apply(x0, b);
        int maxiter = 100;
        double atol = 0.0;
        double rtol = 1.0E-6;
        int out = LinearConjugateGradient.solve(A, b, x, atol, rtol, maxiter, true);
        if (out != 1) {
            System.out.println("NOT ENDED");
        }
        System.out.println("result: x = " + x + ";");
    }
}

