/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import thredds.catalog2.builder.AccessBuilder;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.xml.names.DatasetElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.AccessElementParser;
import thredds.catalog2.xml.parser.stax.DatasetNodeElementParserHelper;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;

class DatasetElementParser
extends AbstractElementParser {
    private final CatalogBuilder parentCatalogBuilder;
    private final DatasetNodeBuilder parentDatasetNodeBuilder;
    private final DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper;
    private final AccessElementParser.Factory accessElementParserFactory;
    private DatasetNodeElementParserHelper datasetNodeElementParserHelper;
    private DatasetBuilder selfBuilder;

    private DatasetElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, CatalogBuilder parentCatalogBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper) {
        super(elementName, reader, builderFactory);
        this.parentCatalogBuilder = parentCatalogBuilder;
        this.parentDatasetNodeBuilder = null;
        this.parentDatasetNodeElementParserHelper = parentDatasetNodeElementParserHelper;
        this.accessElementParserFactory = new AccessElementParser.Factory();
    }

    private DatasetElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, DatasetNodeBuilder parentDatasetNodeBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper) {
        super(elementName, reader, builderFactory);
        this.parentCatalogBuilder = null;
        this.parentDatasetNodeBuilder = parentDatasetNodeBuilder;
        this.parentDatasetNodeElementParserHelper = parentDatasetNodeElementParserHelper;
        this.accessElementParserFactory = new AccessElementParser.Factory();
    }

    void setDefaultServiceName(String defaultServiceName) {
        this.datasetNodeElementParserHelper.setDefaultServiceNameSpecifiedInSelf(defaultServiceName);
    }

    String getDefaultServiceName() {
        return this.datasetNodeElementParserHelper.getDefaultServiceNameSpecifiedInSelf() != null ? this.datasetNodeElementParserHelper.getDefaultServiceNameSpecifiedInSelf() : this.datasetNodeElementParserHelper.getDefaultServiceNameInheritedFromAncestors();
    }

    @Override
    DatasetBuilder getSelfBuilder() {
        return this.selfBuilder;
    }

    @Override
    void parseStartElement() throws ThreddsXmlParserException {
        Attribute urlPathAtt;
        StartElement startElement = this.getNextEventIfStartElementIsMine();
        Attribute nameAtt = startElement.getAttributeByName(DatasetElementNames.DatasetElement_Name);
        String name = nameAtt.getValue();
        if (this.parentCatalogBuilder != null) {
            this.selfBuilder = this.parentCatalogBuilder.addDataset(name);
        } else if (this.parentDatasetNodeBuilder != null) {
            this.selfBuilder = this.parentDatasetNodeBuilder.addDataset(name);
        } else if (this.builderFactory != null) {
            this.selfBuilder = this.builderFactory.newDatasetBuilder(name);
        } else {
            throw new ThreddsXmlParserException("");
        }
        this.datasetNodeElementParserHelper = new DatasetNodeElementParserHelper(this.parentDatasetNodeElementParserHelper, this.selfBuilder, this.builderFactory);
        this.datasetNodeElementParserHelper.parseStartElementIdAttribute(startElement);
        this.datasetNodeElementParserHelper.parseStartElementIdAuthorityAttribute(startElement);
        Attribute serviceNameAtt = startElement.getAttributeByName(DatasetElementNames.DatasetElement_ServiceName);
        if (serviceNameAtt != null) {
            this.setDefaultServiceName(serviceNameAtt.getValue());
        }
        if ((urlPathAtt = startElement.getAttributeByName(DatasetElementNames.DatasetElement_UrlPath)) != null) {
            AccessBuilder accessBuilder = this.selfBuilder.addAccessBuilder();
            accessBuilder.setUrlPath(urlPathAtt.getValue());
        }
    }

    @Override
    void handleChildStartElement() throws ThreddsXmlParserException {
        StartElement startElement = this.peekAtNextEventIfStartElement();
        if (this.datasetNodeElementParserHelper.handleBasicChildStartElement(startElement, this.reader, this.selfBuilder)) {
            return;
        }
        if (this.datasetNodeElementParserHelper.handleCollectionChildStartElement(startElement, this.reader, this.selfBuilder)) {
            return;
        }
        if (this.accessElementParserFactory.isEventMyStartElement(startElement)) {
            AccessElementParser parser = this.accessElementParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder);
            parser.parse();
            return;
        }
        StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(this.reader);
    }

    @Override
    void postProcessingAfterEndElement() throws ThreddsXmlParserException {
        this.datasetNodeElementParserHelper.postProcessingAfterEndElement();
        if (!this.selfBuilder.getAccessBuilders().isEmpty()) {
            ServiceBuilder defaultServiceBuilder = null;
            if (this.getDefaultServiceName() != null) {
                defaultServiceBuilder = this.selfBuilder.getParentCatalogBuilder().findServiceBuilderByNameGlobally(this.getDefaultServiceName());
            }
            for (AccessBuilder curAB : this.selfBuilder.getAccessBuilders()) {
                if (curAB.getServiceBuilder() != null) continue;
                if (defaultServiceBuilder != null) {
                    curAB.setServiceBuilder(defaultServiceBuilder);
                    continue;
                }
                this.selfBuilder.removeAccessBuilder(curAB);
            }
        }
        this.datasetNodeElementParserHelper.addFinalThreddsMetadataToDatasetNodeBuilder(this.selfBuilder);
        this.datasetNodeElementParserHelper.addFinalMetadataToDatasetNodeBuilder(this.selfBuilder);
    }

    static class Factory {
        private QName elementName = DatasetElementNames.DatasetElement;

        Factory() {
        }

        boolean isEventMyStartElement(XMLEvent event) {
            return StaxThreddsXmlParserUtils.isEventStartOrEndElementWithMatchingName(event, this.elementName);
        }

        DatasetElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, CatalogBuilder parentCatalogBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper) {
            return new DatasetElementParser(this.elementName, reader, builderFactory, parentCatalogBuilder, parentDatasetNodeElementParserHelper);
        }

        DatasetElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, DatasetNodeBuilder parentDatasetNodeBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper) {
            return new DatasetElementParser(this.elementName, reader, builderFactory, parentDatasetNodeBuilder, parentDatasetNodeElementParserHelper);
        }
    }
}

