/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Int1D;
import mitiv.array.Int8D;
import mitiv.array.Int9D;
import mitiv.array.impl.FlatInt1D;
import mitiv.array.impl.FlatInt8D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedInt9D;
import mitiv.array.impl.StriddenInt8D;
import mitiv.array.impl.StriddenInt9D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.IntGenerator;

public class FlatInt9D
extends Int9D {
    static final int order = 1;
    final int[] data;
    final int dim1dim2;
    final int dim1dim2dim3;
    final int dim1dim2dim3dim4;
    final int dim1dim2dim3dim4dim5;
    final int dim1dim2dim3dim4dim5dim6;
    final int dim1dim2dim3dim4dim5dim6dim7;
    final int dim1dim2dim3dim4dim5dim6dim7dim8;

    public FlatInt9D(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        super(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
        this.data = new int[this.number];
        this.dim1dim2 = dim1 * dim2;
        this.dim1dim2dim3 = this.dim1dim2 * dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * dim5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * dim6;
        this.dim1dim2dim3dim4dim5dim6dim7 = this.dim1dim2dim3dim4dim5dim6 * dim7;
        this.dim1dim2dim3dim4dim5dim6dim7dim8 = this.dim1dim2dim3dim4dim5dim6dim7 * dim8;
    }

    public FlatInt9D(int[] dims) {
        super(dims);
        this.data = new int[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * this.dim6;
        this.dim1dim2dim3dim4dim5dim6dim7 = this.dim1dim2dim3dim4dim5dim6 * this.dim7;
        this.dim1dim2dim3dim4dim5dim6dim7dim8 = this.dim1dim2dim3dim4dim5dim6dim7 * this.dim8;
    }

    public FlatInt9D(Shape shape) {
        super(shape);
        this.data = new int[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * this.dim6;
        this.dim1dim2dim3dim4dim5dim6dim7 = this.dim1dim2dim3dim4dim5dim6 * this.dim7;
        this.dim1dim2dim3dim4dim5dim6dim7dim8 = this.dim1dim2dim3dim4dim5dim6dim7 * this.dim8;
    }

    public FlatInt9D(int[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        super(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = dim1 * dim2;
        this.dim1dim2dim3 = this.dim1dim2 * dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * dim5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * dim6;
        this.dim1dim2dim3dim4dim5dim6dim7 = this.dim1dim2dim3dim4dim5dim6 * dim7;
        this.dim1dim2dim3dim4dim5dim6dim7dim8 = this.dim1dim2dim3dim4dim5dim6dim7 * dim8;
    }

    public FlatInt9D(int[] arr, int[] dims) {
        super(dims);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * this.dim6;
        this.dim1dim2dim3dim4dim5dim6dim7 = this.dim1dim2dim3dim4dim5dim6 * this.dim7;
        this.dim1dim2dim3dim4dim5dim6dim7dim8 = this.dim1dim2dim3dim4dim5dim6dim7 * this.dim8;
    }

    public FlatInt9D(int[] arr, Shape shape) {
        super(shape);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * this.dim6;
        this.dim1dim2dim3dim4dim5dim6dim7 = this.dim1dim2dim3dim4dim5dim6 * this.dim7;
        this.dim1dim2dim3dim4dim5dim6dim7dim8 = this.dim1dim2dim3dim4dim5dim6dim7 * this.dim8;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null.");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small.");
        }
    }

    private void checkSize(int[] arr) {
        if (arr == null || arr.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small.");
        }
    }

    final int index(int i1, int i2, int i3, int i4, int i5, int i6, int i7, int i8, int i9) {
        return this.dim1dim2dim3dim4dim5dim6dim7dim8 * i9 + this.dim1dim2dim3dim4dim5dim6dim7 * i8 + this.dim1dim2dim3dim4dim5dim6 * i7 + this.dim1dim2dim3dim4dim5 * i6 + this.dim1dim2dim3dim4 * i5 + this.dim1dim2dim3 * i4 + this.dim1dim2 * i3 + this.dim1 * i2 + i1;
    }

    @Override
    public final int get(int i1, int i2, int i3, int i4, int i5, int i6, int i7, int i8, int i9) {
        return this.data[this.dim1dim2dim3dim4dim5dim6dim7dim8 * i9 + this.dim1dim2dim3dim4dim5dim6dim7 * i8 + this.dim1dim2dim3dim4dim5dim6 * i7 + this.dim1dim2dim3dim4dim5 * i6 + this.dim1dim2dim3dim4 * i5 + this.dim1dim2dim3 * i4 + this.dim1dim2 * i3 + this.dim1 * i2 + i1];
    }

    @Override
    public final void set(int i1, int i2, int i3, int i4, int i5, int i6, int i7, int i8, int i9, int value) {
        this.data[this.dim1dim2dim3dim4dim5dim6dim7dim8 * i9 + this.dim1dim2dim3dim4dim5dim6dim7 * i8 + this.dim1dim2dim3dim4dim5dim6 * i7 + this.dim1dim2dim3dim4dim5 * i6 + this.dim1dim2dim3dim4 * i5 + this.dim1dim2dim3 * i4 + this.dim1dim2 * i3 + this.dim1 * i2 + i1] = value;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(int value) {
        int j = 0;
        while (j < this.number) {
            this.data[j] = value;
            ++j;
        }
    }

    @Override
    public void fill(IntGenerator generator) {
        int j = 0;
        while (j < this.number) {
            this.data[j] = generator.nextInt();
            ++j;
        }
    }

    @Override
    public void increment(int value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] + value;
        }
    }

    @Override
    public void decrement(int value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] - value;
        }
    }

    @Override
    public void scale(int value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] * value;
        }
    }

    @Override
    public void map(IntFunction function) {
        int j = 0;
        while (j < this.number) {
            this.data[j] = function.apply(this.data[j]);
            ++j;
        }
    }

    @Override
    public void scan(IntScanner scanner) {
        scanner.initialize(this.data[0]);
        int j = 1;
        while (j < this.number) {
            scanner.update(this.data[j]);
            ++j;
        }
    }

    @Override
    public int[] flatten(boolean forceCopy) {
        if (forceCopy) {
            int[] result = new int[this.number];
            System.arraycopy(this.data, 0, result, 0, this.number);
            return result;
        }
        return this.data;
    }

    @Override
    public Int8D slice(int idx) {
        if ((idx = Helper.fixIndex(idx, this.dim9)) == 0) {
            return new FlatInt8D(this.data, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8);
        }
        return new StriddenInt8D(this.data, this.dim1dim2dim3dim4dim5dim6dim7dim8 * idx, 1, this.dim1, this.dim1dim2, this.dim1dim2dim3, this.dim1dim2dim3dim4, this.dim1dim2dim3dim4dim5, this.dim1dim2dim3dim4dim5dim6, this.dim1dim2dim3dim4dim5dim6dim7, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8);
    }

    @Override
    public Int8D slice(int idx, int dim) {
        int sliceDim8;
        int sliceDim7;
        int sliceDim6;
        int sliceDim5;
        int sliceDim4;
        int sliceDim3;
        int sliceDim2;
        int sliceDim1;
        int sliceStride8;
        int sliceStride7;
        int sliceStride6;
        int sliceStride5;
        int sliceStride4;
        int sliceStride3;
        int sliceStride2;
        int sliceStride1;
        int sliceOffset;
        if ((dim = Helper.fixSliceIndex(dim, 9)) == 0) {
            sliceOffset = Helper.fixIndex(idx, this.dim1);
            sliceStride1 = this.dim1;
            sliceStride2 = this.dim1dim2;
            sliceStride3 = this.dim1dim2dim3;
            sliceStride4 = this.dim1dim2dim3dim4;
            sliceStride5 = this.dim1dim2dim3dim4dim5;
            sliceStride6 = this.dim1dim2dim3dim4dim5dim6;
            sliceStride7 = this.dim1dim2dim3dim4dim5dim6dim7;
            sliceStride8 = this.dim1dim2dim3dim4dim5dim6dim7dim8;
            sliceDim1 = this.dim2;
            sliceDim2 = this.dim3;
            sliceDim3 = this.dim4;
            sliceDim4 = this.dim5;
            sliceDim5 = this.dim6;
            sliceDim6 = this.dim7;
            sliceDim7 = this.dim8;
            sliceDim8 = this.dim9;
        } else if (dim == 1) {
            sliceOffset = this.dim1 * Helper.fixIndex(idx, this.dim2);
            sliceStride1 = 1;
            sliceStride2 = this.dim1dim2;
            sliceStride3 = this.dim1dim2dim3;
            sliceStride4 = this.dim1dim2dim3dim4;
            sliceStride5 = this.dim1dim2dim3dim4dim5;
            sliceStride6 = this.dim1dim2dim3dim4dim5dim6;
            sliceStride7 = this.dim1dim2dim3dim4dim5dim6dim7;
            sliceStride8 = this.dim1dim2dim3dim4dim5dim6dim7dim8;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim3;
            sliceDim3 = this.dim4;
            sliceDim4 = this.dim5;
            sliceDim5 = this.dim6;
            sliceDim6 = this.dim7;
            sliceDim7 = this.dim8;
            sliceDim8 = this.dim9;
        } else if (dim == 2) {
            sliceOffset = this.dim1dim2 * Helper.fixIndex(idx, this.dim3);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2dim3;
            sliceStride4 = this.dim1dim2dim3dim4;
            sliceStride5 = this.dim1dim2dim3dim4dim5;
            sliceStride6 = this.dim1dim2dim3dim4dim5dim6;
            sliceStride7 = this.dim1dim2dim3dim4dim5dim6dim7;
            sliceStride8 = this.dim1dim2dim3dim4dim5dim6dim7dim8;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim4;
            sliceDim4 = this.dim5;
            sliceDim5 = this.dim6;
            sliceDim6 = this.dim7;
            sliceDim7 = this.dim8;
            sliceDim8 = this.dim9;
        } else if (dim == 3) {
            sliceOffset = this.dim1dim2dim3 * Helper.fixIndex(idx, this.dim4);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2;
            sliceStride4 = this.dim1dim2dim3dim4;
            sliceStride5 = this.dim1dim2dim3dim4dim5;
            sliceStride6 = this.dim1dim2dim3dim4dim5dim6;
            sliceStride7 = this.dim1dim2dim3dim4dim5dim6dim7;
            sliceStride8 = this.dim1dim2dim3dim4dim5dim6dim7dim8;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
            sliceDim4 = this.dim5;
            sliceDim5 = this.dim6;
            sliceDim6 = this.dim7;
            sliceDim7 = this.dim8;
            sliceDim8 = this.dim9;
        } else if (dim == 4) {
            sliceOffset = this.dim1dim2dim3dim4 * Helper.fixIndex(idx, this.dim5);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2;
            sliceStride4 = this.dim1dim2dim3;
            sliceStride5 = this.dim1dim2dim3dim4dim5;
            sliceStride6 = this.dim1dim2dim3dim4dim5dim6;
            sliceStride7 = this.dim1dim2dim3dim4dim5dim6dim7;
            sliceStride8 = this.dim1dim2dim3dim4dim5dim6dim7dim8;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
            sliceDim4 = this.dim4;
            sliceDim5 = this.dim6;
            sliceDim6 = this.dim7;
            sliceDim7 = this.dim8;
            sliceDim8 = this.dim9;
        } else if (dim == 5) {
            sliceOffset = this.dim1dim2dim3dim4dim5 * Helper.fixIndex(idx, this.dim6);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2;
            sliceStride4 = this.dim1dim2dim3;
            sliceStride5 = this.dim1dim2dim3dim4;
            sliceStride6 = this.dim1dim2dim3dim4dim5dim6;
            sliceStride7 = this.dim1dim2dim3dim4dim5dim6dim7;
            sliceStride8 = this.dim1dim2dim3dim4dim5dim6dim7dim8;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
            sliceDim4 = this.dim4;
            sliceDim5 = this.dim5;
            sliceDim6 = this.dim7;
            sliceDim7 = this.dim8;
            sliceDim8 = this.dim9;
        } else if (dim == 6) {
            sliceOffset = this.dim1dim2dim3dim4dim5dim6 * Helper.fixIndex(idx, this.dim7);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2;
            sliceStride4 = this.dim1dim2dim3;
            sliceStride5 = this.dim1dim2dim3dim4;
            sliceStride6 = this.dim1dim2dim3dim4dim5;
            sliceStride7 = this.dim1dim2dim3dim4dim5dim6dim7;
            sliceStride8 = this.dim1dim2dim3dim4dim5dim6dim7dim8;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
            sliceDim4 = this.dim4;
            sliceDim5 = this.dim5;
            sliceDim6 = this.dim6;
            sliceDim7 = this.dim8;
            sliceDim8 = this.dim9;
        } else if (dim == 7) {
            sliceOffset = this.dim1dim2dim3dim4dim5dim6dim7 * Helper.fixIndex(idx, this.dim8);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2;
            sliceStride4 = this.dim1dim2dim3;
            sliceStride5 = this.dim1dim2dim3dim4;
            sliceStride6 = this.dim1dim2dim3dim4dim5;
            sliceStride7 = this.dim1dim2dim3dim4dim5dim6;
            sliceStride8 = this.dim1dim2dim3dim4dim5dim6dim7dim8;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
            sliceDim4 = this.dim4;
            sliceDim5 = this.dim5;
            sliceDim6 = this.dim6;
            sliceDim7 = this.dim7;
            sliceDim8 = this.dim9;
        } else {
            sliceOffset = this.dim1dim2dim3dim4dim5dim6dim7dim8 * Helper.fixIndex(idx, this.dim9);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2;
            sliceStride4 = this.dim1dim2dim3;
            sliceStride5 = this.dim1dim2dim3dim4;
            sliceStride6 = this.dim1dim2dim3dim4dim5;
            sliceStride7 = this.dim1dim2dim3dim4dim5dim6;
            sliceStride8 = this.dim1dim2dim3dim4dim5dim6dim7;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
            sliceDim4 = this.dim4;
            sliceDim5 = this.dim5;
            sliceDim6 = this.dim6;
            sliceDim7 = this.dim7;
            sliceDim8 = this.dim8;
        }
        return new StriddenInt8D(this.data, sliceOffset, sliceStride1, sliceStride2, sliceStride3, sliceStride4, sliceStride5, sliceStride6, sliceStride7, sliceStride8, sliceDim1, sliceDim2, sliceDim3, sliceDim4, sliceDim5, sliceDim6, sliceDim7, sliceDim8);
    }

    @Override
    public Int9D view(Range rng1, Range rng2, Range rng3, Range rng4, Range rng5, Range rng6, Range rng7, Range rng8, Range rng9) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, 0, 1);
        CompiledRange cr2 = new CompiledRange(rng2, this.dim2, 0, this.dim1);
        CompiledRange cr3 = new CompiledRange(rng3, this.dim3, 0, this.dim1dim2);
        CompiledRange cr4 = new CompiledRange(rng4, this.dim4, 0, this.dim1dim2dim3);
        CompiledRange cr5 = new CompiledRange(rng5, this.dim5, 0, this.dim1dim2dim3dim4);
        CompiledRange cr6 = new CompiledRange(rng6, this.dim6, 0, this.dim1dim2dim3dim4dim5);
        CompiledRange cr7 = new CompiledRange(rng7, this.dim7, 0, this.dim1dim2dim3dim4dim5dim6);
        CompiledRange cr8 = new CompiledRange(rng8, this.dim8, 0, this.dim1dim2dim3dim4dim5dim6dim7);
        CompiledRange cr9 = new CompiledRange(rng9, this.dim9, 0, this.dim1dim2dim3dim4dim5dim6dim7dim8);
        if (cr1.doesNothing() && cr2.doesNothing() && cr3.doesNothing() && cr4.doesNothing() && cr5.doesNothing() && cr6.doesNothing() && cr7.doesNothing() && cr8.doesNothing() && cr9.doesNothing()) {
            return this;
        }
        return new StriddenInt9D(this.data, cr1.getOffset() + cr2.getOffset() + cr3.getOffset() + cr4.getOffset() + cr5.getOffset() + cr6.getOffset() + cr7.getOffset() + cr8.getOffset() + cr9.getOffset(), cr1.getStride(), cr2.getStride(), cr3.getStride(), cr4.getStride(), cr5.getStride(), cr6.getStride(), cr7.getStride(), cr8.getStride(), cr9.getStride(), cr1.getNumber(), cr2.getNumber(), cr3.getNumber(), cr4.getNumber(), cr5.getNumber(), cr6.getNumber(), cr7.getNumber(), cr8.getNumber(), cr9.getNumber());
    }

    @Override
    public Int9D view(int[] sel1, int[] sel2, int[] sel3, int[] sel4, int[] sel5, int[] sel6, int[] sel7, int[] sel8, int[] sel9) {
        int[] idx1 = Helper.select(0, 1, this.dim1, sel1);
        int[] idx2 = Helper.select(0, this.dim1, this.dim2, sel2);
        int[] idx3 = Helper.select(0, this.dim1dim2, this.dim3, sel3);
        int[] idx4 = Helper.select(0, this.dim1dim2dim3, this.dim4, sel4);
        int[] idx5 = Helper.select(0, this.dim1dim2dim3dim4, this.dim5, sel5);
        int[] idx6 = Helper.select(0, this.dim1dim2dim3dim4dim5, this.dim6, sel6);
        int[] idx7 = Helper.select(0, this.dim1dim2dim3dim4dim5dim6, this.dim7, sel7);
        int[] idx8 = Helper.select(0, this.dim1dim2dim3dim4dim5dim6dim7, this.dim8, sel8);
        int[] idx9 = Helper.select(0, this.dim1dim2dim3dim4dim5dim6dim7dim8, this.dim9, sel9);
        return new SelectedInt9D(this.data, idx1, idx2, idx3, idx4, idx5, idx6, idx7, idx8, idx9);
    }

    @Override
    public Int1D as1D() {
        return new FlatInt1D(this.data, this.number);
    }
}

