/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AffineTransform
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/ROI/2015-01";
    private static final Logger LOGGER = LoggerFactory.getLogger(AffineTransform.class);
    private Double a11;
    private Double a10;
    private Double a12;
    private Double a02;
    private Double a00;
    private Double a01;

    public AffineTransform() {
    }

    public AffineTransform(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public AffineTransform(AffineTransform orig) {
        this.a11 = orig.a11;
        this.a10 = orig.a10;
        this.a12 = orig.a12;
        this.a02 = orig.a02;
        this.a00 = orig.a00;
        this.a01 = orig.a01;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"AffineTransform".equals(tagName)) {
            LOGGER.debug("Expecting node name of AffineTransform got {}", (Object)tagName);
        }
        if (element.hasAttribute("A11")) {
            this.setA11(Double.valueOf(element.getAttribute("A11")));
        }
        if (element.hasAttribute("A10")) {
            this.setA10(Double.valueOf(element.getAttribute("A10")));
        }
        if (element.hasAttribute("A12")) {
            this.setA12(Double.valueOf(element.getAttribute("A12")));
        }
        if (element.hasAttribute("A02")) {
            this.setA02(Double.valueOf(element.getAttribute("A02")));
        }
        if (element.hasAttribute("A00")) {
            this.setA00(Double.valueOf(element.getAttribute("A00")));
        }
        if (element.hasAttribute("A01")) {
            this.setA01(Double.valueOf(element.getAttribute("A01")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public Double getA11() {
        return this.a11;
    }

    public void setA11(Double a11) {
        this.a11 = a11;
    }

    public Double getA10() {
        return this.a10;
    }

    public void setA10(Double a10) {
        this.a10 = a10;
    }

    public Double getA12() {
        return this.a12;
    }

    public void setA12(Double a12) {
        this.a12 = a12;
    }

    public Double getA02() {
        return this.a02;
    }

    public void setA02(Double a02) {
        this.a02 = a02;
    }

    public Double getA00() {
        return this.a00;
    }

    public void setA00(Double a00) {
        this.a00 = a00;
    }

    public Double getA01() {
        return this.a01;
    }

    public void setA01(Double a01) {
        this.a01 = a01;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element AffineTransform_element) {
        if (AffineTransform_element == null) {
            AffineTransform_element = document.createElementNS(NAMESPACE, "AffineTransform");
        }
        if (this.a11 != null) {
            AffineTransform_element.setAttribute("A11", this.a11.toString());
        }
        if (this.a10 != null) {
            AffineTransform_element.setAttribute("A10", this.a10.toString());
        }
        if (this.a12 != null) {
            AffineTransform_element.setAttribute("A12", this.a12.toString());
        }
        if (this.a02 != null) {
            AffineTransform_element.setAttribute("A02", this.a02.toString());
        }
        if (this.a00 != null) {
            AffineTransform_element.setAttribute("A00", this.a00.toString());
        }
        if (this.a01 != null) {
            AffineTransform_element.setAttribute("A01", this.a01.toString());
        }
        return super.asXMLElement(document, AffineTransform_element);
    }
}

