/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;
import loci.poi.util.StringUtil;

public class FormatRecord
extends Record {
    public static final short sid = 1054;
    private short field_1_index_code;
    private short field_3_unicode_len;
    private boolean field_3_unicode_flag;
    private String field_4_formatstring;

    public FormatRecord() {
    }

    public FormatRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 1054) {
            throw new RecordFormatException("NOT A FORMAT RECORD");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.field_1_index_code = in.readShort();
        this.field_3_unicode_len = in.readShort();
        this.field_3_unicode_flag = (in.readByte() & 1) != 0;
        this.field_4_formatstring = this.field_3_unicode_flag ? in.readUnicodeLEString(this.field_3_unicode_len) : in.readCompressedUnicode(this.field_3_unicode_len);
    }

    public void setIndexCode(short index) {
        this.field_1_index_code = index;
    }

    public void setFormatStringLength(byte len) {
        this.field_3_unicode_len = len;
    }

    public void setUnicodeFlag(boolean unicode) {
        this.field_3_unicode_flag = unicode;
    }

    public void setFormatString(String fs) {
        this.field_4_formatstring = fs;
        this.setUnicodeFlag(StringUtil.hasMultibyte(fs));
    }

    public short getIndexCode() {
        return this.field_1_index_code;
    }

    public boolean getUnicodeFlag() {
        return this.field_3_unicode_flag;
    }

    public String getFormatString() {
        return this.field_4_formatstring;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FORMAT]\n");
        buffer.append("    .indexcode       = ").append(Integer.toHexString(this.getIndexCode())).append("\n");
        buffer.append("    .unicode length  = ").append(Integer.toHexString(this.field_3_unicode_len)).append("\n");
        buffer.append("    .isUnicode       = ").append(this.field_3_unicode_flag).append("\n");
        buffer.append("    .formatstring    = ").append(this.getFormatString()).append("\n");
        buffer.append("[/FORMAT]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)1054);
        LittleEndian.putShort(data, 2 + offset, (short)(5 + (this.field_3_unicode_flag ? 2 * this.field_3_unicode_len : this.field_3_unicode_len)));
        LittleEndian.putShort(data, 4 + offset, this.getIndexCode());
        LittleEndian.putShort(data, 6 + offset, this.field_3_unicode_len);
        data[8 + offset] = (byte)(this.field_3_unicode_flag ? 1 : 0);
        if (this.field_3_unicode_flag) {
            StringUtil.putUnicodeLE(this.getFormatString(), data, 9 + offset);
        } else {
            StringUtil.putCompressedUnicode(this.getFormatString(), data, 9 + offset);
        }
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 9 + (this.field_3_unicode_flag ? 2 * this.field_3_unicode_len : this.field_3_unicode_len);
    }

    @Override
    public short getSid() {
        return 1054;
    }
}

