/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public class LinearConjugateGradient {
    public static final int IN_PROGRESS = 0;
    public static final int CONVERGED = 1;
    public static final int TOO_MANY_ITERATIONS = 2;
    public static final int A_IS_NOT_POSITIVE_DEFINITE = 3;
    public static final int P_IS_NOT_POSITIVE_DEFINITE = 4;
    public static final int BAD_ATOL = 5;
    public static final int BAD_RTOL = 6;
    public static final int BUG = 7;
    public static final double DEFAULT_ATOL = 0.0;
    public static final double DEFAULT_RTOL = 1.0E-5;
    private double atol = 0.0;
    private double rtol = 1.0E-5;
    private LinearOperator A;
    private LinearOperator P;
    private Vector b;
    private Vector p;
    private Vector q;
    private Vector r;
    private Vector z;

    public LinearConjugateGradient(LinearOperator A, Vector b) {
        this(A, b, null);
    }

    public LinearConjugateGradient(LinearOperator A, Vector b, LinearOperator P) {
        if (!b.belongsTo(A.getOutputSpace())) {
            throw new IncorrectSpaceException();
        }
        if (A.getInputSpace() != A.getOutputSpace()) {
            throw new IllegalArgumentException("LHS matrix must be an endomorphism.");
        }
        if (P != null && (P.getInputSpace() != A.getOutputSpace() || P.getOutputSpace() != A.getInputSpace())) {
            throw new IncorrectSpaceException();
        }
        this.A = A;
        this.b = b;
        this.P = P;
    }

    public double getAtol() {
        return this.atol;
    }

    public void setAtol(double atol) {
        this.atol = Math.max(0.0, atol);
    }

    public double getRtol() {
        return this.rtol;
    }

    public void setRtol(double rtol) {
        this.rtol = Math.max(0.0, rtol);
    }

    public int solve(Vector x, int maxiter, boolean reset) {
        if (!x.belongsTo(this.A.getInputSpace())) {
            throw new IncorrectSpaceException();
        }
        VectorSpace vsp = this.b.getSpace();
        if (this.p == null) {
            this.p = vsp.create();
        }
        if (this.q == null) {
            this.q = vsp.create();
        }
        if (this.r == null) {
            this.r = vsp.create();
        }
        if (this.z == null) {
            Vector vector = this.z = this.P == null ? this.r : vsp.create();
        }
        if (reset) {
            x.zero();
            this.r.copyFrom(this.b);
        } else {
            this.A.apply(this.r, x);
            this.r.combine(1.0, this.b, -1.0, this.r);
        }
        if (this.P != null) {
            this.P.apply(this.z, this.r);
        }
        double rho = this.z.dot(this.r);
        double rho_prev = 0.0;
        double epsilon = Math.max(0.0, Math.max(this.atol, this.rtol * rho));
        int iter = 0;
        while (true) {
            if (rho <= epsilon) {
                if (rho < 0.0) {
                    if (this.P != null) {
                        return 4;
                    }
                    return 7;
                }
                return 1;
            }
            if (maxiter >= 0 && iter >= maxiter) {
                return 2;
            }
            if (iter == 0) {
                this.p.copyFrom(this.p);
            } else {
                double beta = rho / rho_prev;
                this.p.combine(1.0, this.z, beta, this.p);
            }
            this.A.apply(this.q, this.p);
            double gamma = this.p.dot(this.q);
            if (gamma <= 0.0) {
                return 3;
            }
            double alpha = rho / gamma;
            x.combine(1.0, x, alpha, this.p);
            this.r.combine(1.0, this.r, -alpha, this.q);
            if (this.P != null) {
                this.P.apply(this.z, this.r);
            }
            rho_prev = rho;
            rho = this.z.dot(this.r);
            ++iter;
        }
    }

    public static int solve(LinearOperator A, Vector b, Vector x, double atol, double rtol, int maxiter, boolean reset) {
        return LinearConjugateGradient.solve(A, b, x, null, atol, rtol, maxiter, reset);
    }

    public static int solve(LinearOperator A, Vector b, Vector x, LinearOperator P, double atol, double rtol, int maxiter, boolean reset) {
        if (atol < 0.0) {
            return 5;
        }
        if (rtol < 0.0) {
            return 6;
        }
        LinearConjugateGradient cg = new LinearConjugateGradient(A, b, P);
        return cg.solve(x, maxiter, reset);
    }
}

