/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.utils;

import java.util.Arrays;

public class KDTreeC {
    private final int dimensions;
    private final int bucket_size;
    private NodeKD root;
    private double[] scale;

    public KDTreeC(int n) {
        this.dimensions = n;
        this.bucket_size = 64;
        this.root = new NodeKD(this);
        double[] dArray = new double[]{1.0, 1.0, 1.0};
    }

    public KDTreeC(int n, int n2) {
        this.dimensions = n;
        this.bucket_size = n2;
        this.root = new NodeKD(this);
    }

    public void setScale(double[] dArray) {
        double[] dArray2 = new double[]{dArray[0] * dArray[0], dArray[1] * dArray[1], dArray[2] * dArray[2]};
        this.setScaleSq(dArray2);
    }

    public void setScale3(double d, double d2, double d3) {
        double[] dArray = new double[]{d * d, d2 * d2, d3 * d3};
        this.setScaleSq(dArray);
    }

    private void setScaleSq(double[] dArray) {
        this.scale = dArray;
    }

    public void add(double[] dArray, Object object) {
        this.root.add(new Item(dArray, object));
    }

    public Item[] getRange(double[] dArray, double[] dArray2) {
        return this.root.range(dArray2, dArray);
    }

    public Item[] getNearestNeighbor(double[] dArray, int n) {
        ShiftArray shiftArray = new ShiftArray(n);
        this.root.nearestn(shiftArray, dArray);
        return shiftArray.getArray();
    }

    public double distance(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += (dArray2[i] - dArray[i]) * (dArray2[i] - dArray[i]) * this.scale[i];
        }
        return Math.sqrt(d);
    }

    public double distanceSq(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += (dArray2[i] - dArray[i]) * (dArray2[i] - dArray[i]) * this.scale[i];
        }
        return d;
    }

    private class ShiftArray {
        private Item[] items;
        private final int max;
        private int current;

        private ShiftArray(int n) {
            this.max = n;
            this.current = 0;
            this.items = new Item[this.max];
        }

        private void add(Item item) {
            int n;
            for (n = this.current; n > 0 && this.items[n - 1].distanceSq > item.distanceSq; --n) {
            }
            if (n >= this.max) {
                return;
            }
            if (this.current < this.max) {
                ++this.current;
            }
            System.arraycopy(this.items, n, this.items, n + 1, this.current - (n + 1));
            this.items[n] = item;
        }

        private double getLongest() {
            if (this.current < this.max) {
                return Double.POSITIVE_INFINITY;
            }
            return this.items[this.max - 1].distanceSq;
        }

        private Item[] getArray() {
            return (Item[])this.items.clone();
        }
    }

    private class NodeKD {
        private KDTreeC owner;
        private NodeKD left;
        private NodeKD right;
        private double[] upper;
        private double[] lower;
        private Item[] bucket;
        private int current;
        private int dim;
        private double slice;

        private NodeKD(KDTreeC kDTreeC2) {
            this.owner = kDTreeC2;
            this.lower = null;
            this.upper = null;
            this.right = null;
            this.left = null;
            this.bucket = new Item[kDTreeC2.bucket_size];
            this.current = 0;
            this.dim = 0;
        }

        private NodeKD(NodeKD nodeKD) {
            this.owner = nodeKD.owner;
            this.dim = nodeKD.dim + 1;
            this.bucket = new Item[this.owner.bucket_size];
            if (this.dim + 1 > this.owner.dimensions) {
                this.dim = 0;
            }
            this.right = null;
            this.left = null;
            this.lower = null;
            this.upper = null;
            this.current = 0;
        }

        private void add(Item item) {
            if (this.bucket == null) {
                if (item.pnt[this.dim] > this.slice) {
                    this.right.add(item);
                } else {
                    this.left.add(item);
                }
            } else {
                if (this.current + 1 > this.owner.bucket_size) {
                    this.split(item);
                    return;
                }
                this.bucket[this.current++] = item;
            }
            this.expand(item.pnt);
        }

        private void nearestn(ShiftArray shiftArray, double[] dArray) {
            block4: {
                block2: {
                    block3: {
                        if (this.bucket != null) break block2;
                        if (!(dArray[this.dim] > this.slice)) break block3;
                        this.right.nearestn(shiftArray, dArray);
                        if (this.left.current != 0 && this.owner.distanceSq(this.left.nearestRect(dArray), dArray) < shiftArray.getLongest()) {
                            this.left.nearestn(shiftArray, dArray);
                        }
                        break block4;
                    }
                    this.left.nearestn(shiftArray, dArray);
                    if (this.right.current == 0 || !(this.owner.distanceSq(this.right.nearestRect(dArray), dArray) < shiftArray.getLongest())) break block4;
                    this.right.nearestn(shiftArray, dArray);
                    break block4;
                }
                for (int i = 0; i < this.current; ++i) {
                    this.bucket[i].distanceSq = this.owner.distanceSq(this.bucket[i].pnt, dArray);
                    shiftArray.add(this.bucket[i]);
                }
            }
        }

        private Item[] range(double[] dArray, double[] dArray2) {
            if (this.bucket == null) {
                Item[] itemArray;
                Item[] itemArray2 = new Item[]{};
                if (this.intersects(dArray, dArray2, this.left.upper, this.left.lower)) {
                    itemArray = this.left.range(dArray, dArray2);
                    if (0 == itemArray2.length) {
                        itemArray2 = itemArray;
                    }
                }
                if (this.intersects(dArray, dArray2, this.right.upper, this.right.lower)) {
                    itemArray = this.right.range(dArray, dArray2);
                    if (0 == itemArray2.length) {
                        itemArray2 = itemArray;
                    } else if (0 < itemArray.length) {
                        Item[] itemArray3 = new Item[itemArray2.length + itemArray.length];
                        System.arraycopy(itemArray2, 0, itemArray3, 0, itemArray2.length);
                        System.arraycopy(itemArray, 0, itemArray3, itemArray2.length, itemArray.length);
                        itemArray2 = itemArray3;
                    }
                }
                return itemArray2;
            }
            Item[] itemArray = new Item[this.current];
            int n = 0;
            for (int i = 0; i < this.current; ++i) {
                if (!this.contains(dArray, dArray2, this.bucket[i].pnt)) continue;
                itemArray[n++] = this.bucket[i];
            }
            Item[] itemArray4 = new Item[n];
            System.arraycopy(itemArray, 0, itemArray4, 0, n);
            return itemArray4;
        }

        public boolean contains(double[] dArray, double[] dArray2, double[] dArray3) {
            if (this.current == 0) {
                return false;
            }
            for (int i = 0; i < dArray3.length; ++i) {
                if (!(dArray3[i] > dArray[i]) && !(dArray3[i] < dArray2[i])) continue;
                return false;
            }
            return true;
        }

        public boolean intersects(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray3[i] < dArray2[i]) && !(dArray4[i] > dArray[i])) continue;
                return false;
            }
            return true;
        }

        private void split(Item item) {
            this.slice = (this.upper[this.dim] + this.lower[this.dim]) / 2.0;
            this.left = new NodeKD(this);
            this.right = new NodeKD(this);
            for (int i = 0; i < this.current; ++i) {
                if (this.bucket[i].pnt[this.dim] > this.slice) {
                    this.right.add(this.bucket[i]);
                    continue;
                }
                this.left.add(this.bucket[i]);
            }
            this.bucket = null;
            this.add(item);
        }

        private double[] nearestRect(double[] dArray) {
            double[] dArray2 = (double[])dArray.clone();
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray2[i] > this.upper[i]) {
                    dArray2[i] = this.upper[i];
                }
                if (!(dArray2[i] < this.lower[i])) continue;
                dArray2[i] = this.lower[i];
            }
            return dArray2;
        }

        private void expand(double[] dArray) {
            if (this.upper == null) {
                this.upper = Arrays.copyOf(dArray, this.owner.dimensions);
                this.lower = Arrays.copyOf(dArray, this.owner.dimensions);
                return;
            }
            for (int i = 0; i < dArray.length; ++i) {
                if (this.upper[i] < dArray[i]) {
                    this.upper[i] = dArray[i];
                }
                if (!(this.lower[i] > dArray[i])) continue;
                this.lower[i] = dArray[i];
            }
        }
    }

    public class Item {
        public double[] pnt;
        public Object obj;
        public double distanceSq;

        private Item(double[] dArray, Object object) {
            this.pnt = dArray;
            this.obj = object;
        }
    }
}

