/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base.indexing;

import mitiv.exception.IllegalRangeException;

public class Range {
    private int first;
    private int last;
    private int step;
    public static final int FIRST = 0;
    public static final int LAST = -1;
    public static final Range ALL = new Range(0, -1, 1);
    public static final Range REVERSE = new Range(-1, 0, -1);
    public static final Range ODD = new Range(0, -1, 1);
    public static final Range EVEN = new Range(1, -1, 1);

    public Range() {
        this.first = 0;
        this.last = -1;
        this.step = 1;
    }

    public Range(int[] r) {
        switch (r == null ? 0 : r.length) {
            case 0: {
                this.first = 0;
                this.last = -1;
                this.step = 1;
                break;
            }
            case 2: {
                this.first = r[0];
                this.last = r[1];
                this.step = 1;
                break;
            }
            case 3: {
                this.first = r[0];
                this.last = r[1];
                this.setStep(r[2]);
                break;
            }
            default: {
                throw new IllegalRangeException();
            }
        }
    }

    public Range(int first, int last) {
        this.first = first;
        this.last = last;
        this.step = 1;
    }

    public Range(int first, int last, int step) {
        this.first = first;
        this.last = last;
        this.setStep(step);
    }

    public final int getFirst() {
        return this.first;
    }

    public final int getFirst(int length) {
        return Range.fixIndex(this.first, length);
    }

    public final void setFirst(int first) {
        this.first = first;
    }

    public final int getLast() {
        return this.last;
    }

    public final int getLast(int length) {
        return Range.fixIndex(this.last, length);
    }

    public final void setLast(int last) {
        this.last = last;
    }

    public final int getStep() {
        return this.step;
    }

    public final void setStep(int step) {
        if (step == 0) {
            throw new IllegalRangeException("Illegal 0 step.");
        }
        this.step = step;
    }

    public static final int fixIndex(int index, int length) {
        return index >= 0 ? index : length + index;
    }

    public static final boolean doesNothing(Range rng, int length) {
        return rng == null || rng.doesNothing(length);
    }

    public final boolean doesNothing(int length) {
        return this.step == 1 && Range.fixIndex(this.first, length) == 0 && Range.fixIndex(this.last, length) == length;
    }

    public static final int[] asIndexList(Range rng, int length) {
        int number;
        int step;
        int first;
        if (rng == null) {
            first = 0;
            step = 1;
            number = length;
        } else {
            first = Range.fixIndex(rng.first, length);
            int last = Range.fixIndex(rng.last, length);
            step = rng.step;
            number = 0;
            if (step > 0) {
                if (first <= last) {
                    number = (last - first) / step + 1;
                }
            } else if (step < 0 && first >= last) {
                number = (first - last) / -step + 1;
            }
        }
        int[] idx = new int[number];
        int j = 0;
        while (j < number) {
            idx[j] = first + j * step;
            ++j;
        }
        return idx;
    }

    public final int[] asIndexList(int length) {
        int first = Range.fixIndex(this.first, length);
        int last = Range.fixIndex(this.last, length);
        int number = 0;
        if (this.step > 0) {
            if (first <= last) {
                number = (last - first) / this.step + 1;
            }
        } else if (this.step < 0 && first >= last) {
            number = (first - last) / -this.step + 1;
        }
        int[] idx = new int[number];
        int j = 0;
        while (j < number) {
            idx[j] = first + j * this.step;
            ++j;
        }
        return idx;
    }
}

