/*
 * Decompiled with CFR 0.152.
 */
package mitiv.microscopy;

import mitiv.utils.MathUtils;

public class Zernike {
    public static int[] zernumeroNoll(int J) {
        int[] nm = new int[2];
        double k = 0.0;
        int n = 0;
        double n1 = (Math.sqrt(1 + 8 * J) - 1.0) / 2.0;
        if (n1 == (double)(n = (int)Math.floor(n1))) {
            --n;
        }
        k = (n + 1) * (n + 2) / 2;
        nm[1] = (int)((double)n - 2.0 * Math.floor((k - (double)J) / 2.0));
        nm[0] = n;
        return nm;
    }

    public static double[] coeffRadialZCumSumLog(int n, int m) {
        int p = (n - m) / 2;
        int q = (n + m) / 2;
        double[] R_mn = new double[p + 1];
        double[] lfact = new double[n + 1];
        int i = 1;
        while (i < n + 1) {
            lfact[i] = Math.log(i);
            ++i;
        }
        lfact = MathUtils.cumSum(lfact);
        int s = 0;
        while (s <= (n - m) / 2) {
            R_mn[s] = Math.exp(lfact[n - s] - lfact[s] - lfact[p - s] - lfact[q - s]);
            if (!MathUtils.even(s)) {
                R_mn[s] = -R_mn[s];
            }
            ++s;
        }
        return R_mn;
    }

    public static double[] radialZDegree(int n, int m) {
        double[] degR_mn = new double[(n - m) / 2 + 1];
        int s = 0;
        while (s <= (n - m) / 2) {
            degR_mn[s] = n - 2 * s;
            ++s;
        }
        return degR_mn;
    }

    public static double[] zernikeArray(int nbZernike, int width, int height, double radius, boolean normalize, boolean radial) {
        int[] nm;
        int n;
        double[] Z = new double[nbZernike * width * height];
        int WH = width * height;
        double[] r = MathUtils.fftDist1D(width, height);
        double[] theta = MathUtils.fftAngle1D(width, height);
        if (radial) {
            n = nbZernike + 1;
        } else {
            nm = Zernike.zernumeroNoll(nbZernike + 1);
            n = nm[0];
            int n2 = nm[1];
        }
        double[] rPowers = new double[(n + 1) * width * height];
        int l = 0;
        while (l < WH) {
            if (r[l] < radius) {
                rPowers[l] = 1.0;
                Z[l] = 1.0;
                rPowers[l + WH] = r[l] / radius;
            }
            ++l;
        }
        if (normalize) {
            double NormZ = 1.0 / Math.sqrt(MathUtils.sum(MathUtils.abs2(Z, 0, width + WH - 1, 0)));
            int l2 = 0;
            while (l2 < WH) {
                Z[l2] = Z[l2] * NormZ;
                ++l2;
            }
        }
        if (radial) {
            int k = 2;
            while (k < nbZernike + 1) {
                int l3 = 0;
                while (l3 < WH) {
                    rPowers[l3 + k * WH] = rPowers[l3 + (k - 1) * WH] * rPowers[l3 + WH];
                    ++l3;
                }
                ++k;
            }
            int nz = 1;
            while (nz < nbZernike) {
                double[] R_mn = Zernike.coeffRadialZCumSumLog(nz, 0);
                double zr = 0.0;
                int l4 = 0;
                while (l4 < WH) {
                    zr = 0.0;
                    double N = Math.sqrt(nz + 1);
                    int s = nz / 2;
                    while (s >= 0) {
                        zr += R_mn[s] * rPowers[l4 + (nz - 2 * s) * WH];
                        --s;
                    }
                    Z[l4 + nz * WH] = N * zr;
                    ++l4;
                }
                if (normalize) {
                    double NormZ = 1.0 / Math.sqrt(MathUtils.sum(MathUtils.abs2(Z, nz * WH, nz * WH + WH - 1, 0)));
                    int l5 = 0;
                    while (l5 < WH) {
                        int n3 = l5 + nz * WH;
                        Z[n3] = Z[n3] * NormZ;
                        ++l5;
                    }
                }
                ++nz;
            }
        } else {
            int k = 2;
            while (k < n + 1) {
                int l6 = 0;
                while (l6 < WH) {
                    rPowers[l6 + k * WH] = rPowers[l6 + (k - 1) * WH] * rPowers[l6 + WH];
                    ++l6;
                }
                ++k;
            }
            int nz = 1;
            while (nz < nbZernike) {
                int l7;
                int s;
                nm = Zernike.zernumeroNoll(nz + 1);
                n = nm[0];
                int m = nm[1];
                double[] R_mn = Zernike.coeffRadialZCumSumLog(n, m);
                double zr = 0.0;
                if (m == 0) {
                    int l8 = 0;
                    while (l8 < WH) {
                        zr = 0.0;
                        double N = Math.sqrt(n + 1);
                        s = (n - m) / 2;
                        while (s >= 0) {
                            zr += R_mn[s] * rPowers[l8 + (n - 2 * s) * WH];
                            --s;
                        }
                        Z[l8 + nz * WH] = N * zr;
                        ++l8;
                    }
                    if (normalize) {
                        double NormZ = 1.0 / Math.sqrt(MathUtils.sum(MathUtils.abs2(Z, nz * WH, nz * WH + WH - 1, 0)));
                        l7 = 0;
                        while (l7 < WH) {
                            int n4 = l7 + nz * WH;
                            Z[n4] = Z[n4] * NormZ;
                            ++l7;
                        }
                    }
                } else if (MathUtils.even(nz + 1)) {
                    int l9 = 0;
                    while (l9 < WH) {
                        double N = Math.sqrt(2 * (n + 1));
                        zr = 0.0;
                        s = (n - m) / 2;
                        while (s >= 0) {
                            zr += R_mn[s] * rPowers[l9 + (n - 2 * s) * WH];
                            --s;
                        }
                        Z[l9 + nz * WH] = N * zr * Math.cos((double)m * theta[l9]);
                        ++l9;
                    }
                    if (normalize) {
                        double NormZ = 1.0 / Math.sqrt(MathUtils.sum(MathUtils.abs2(Z, nz * WH, nz * WH + WH - 1, 0)));
                        l7 = 0;
                        while (l7 < WH) {
                            Z[l7 + nz * WH] = Z[l7 + nz * WH] * NormZ;
                            ++l7;
                        }
                    }
                } else {
                    int l10 = 0;
                    while (l10 < WH) {
                        double N = Math.sqrt(2 * (n + 1));
                        zr = 0.0;
                        s = (n - m) / 2;
                        while (s >= 0) {
                            zr += R_mn[s] * rPowers[l10 + (n - 2 * s) * WH];
                            --s;
                        }
                        Z[l10 + nz * WH] = N * zr * Math.sin((double)m * theta[l10]);
                        ++l10;
                    }
                    if (normalize) {
                        double NormZ = 1.0 / Math.sqrt(MathUtils.sum(MathUtils.abs2(Z, nz * WH, nz * WH + WH - 1, 0)));
                        l7 = 0;
                        while (l7 < WH) {
                            Z[l7 + nz * WH] = Z[l7 + nz * WH] * NormZ;
                            ++l7;
                        }
                    }
                }
                ++nz;
            }
        }
        return Z;
    }
}

