/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.WrapperIntMatrix3D;

public class DenseLargeIntMatrix3D
extends WrapperIntMatrix3D {
    private static final long serialVersionUID = 1L;
    private int[][][] elements;

    public DenseLargeIntMatrix3D(int slices, int rows, int columns) {
        block2: {
            super(null);
            try {
                this.setUp(slices, rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new int[slices][rows][columns];
    }

    @Override
    public int getQuick(int slice, int row, int column) {
        return this.elements[slice][row][column];
    }

    @Override
    public void setQuick(int slice, int row, int column, int value) {
        this.elements[slice][row][column] = value;
    }

    public int[][][] elements() {
        return this.elements;
    }

    @Override
    protected IntMatrix3D getContent() {
        return this;
    }

    @Override
    public IntMatrix3D like(int slices, int rows, int columns) {
        return new DenseLargeIntMatrix3D(slices, rows, columns);
    }
}

