/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.InputDevice;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.SensorRead;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class Sensor {
    public static final int PREDICT_NONE = 1;
    public static final int PREDICT_NEXT_FRAME_TIME = 2;
    public static final int NO_PREDICTOR = 16;
    public static final int HEAD_PREDICTOR = 32;
    public static final int HAND_PREDICTOR = 64;
    public static final int DEFAULT_SENSOR_READ_COUNT = 30;
    static final int SENSOR_READ_COUNT_BUFFER = 15;
    static int num_reads_so_far = 0;
    boolean demand_driven = false;
    int sensorReadCount;
    private int predictionPolicy = 16;
    private int predictorType = 1;
    InputDevice device;
    SensorRead[] readings;
    int currentIndex;
    int lastIndex;
    Point3d hotspot;
    int MaxSensorReadIndex;
    int sensorButtonCount;
    Matrix3d orig_rot = new Matrix3d();
    Matrix3d orig_rot_transpose = new Matrix3d();
    Matrix3d temp_rot = new Matrix3d();
    Matrix3d local_svd = new Matrix3d();

    public Sensor(InputDevice inputDevice) {
        this(inputDevice, 30, 0, new Point3d(0.0, 0.0, 0.0));
    }

    public Sensor(InputDevice inputDevice, int n) {
        this(inputDevice, n, 0, new Point3d(0.0, 0.0, 0.0));
    }

    public Sensor(InputDevice inputDevice, int n, int n2) {
        this(inputDevice, n, n2, new Point3d(0.0, 0.0, 0.0));
    }

    public Sensor(InputDevice inputDevice, Point3d point3d) {
        this(inputDevice, 30, 0, point3d);
    }

    public Sensor(InputDevice inputDevice, int n, Point3d point3d) {
        this(inputDevice, n, 0, point3d);
    }

    public Sensor(InputDevice inputDevice, int n, int n2, Point3d point3d) {
        this.device = inputDevice;
        this.sensorReadCount = n;
        this.MaxSensorReadIndex = n + 15 - 1;
        this.sensorButtonCount = n2;
        this.readings = new SensorRead[this.MaxSensorReadIndex + 1];
        for (int i = 0; i < this.MaxSensorReadIndex + 1; ++i) {
            this.readings[i] = new SensorRead(n2);
        }
        this.currentIndex = 0;
        this.hotspot = new Point3d(point3d);
    }

    int previousIndex(int n) {
        int n2 = this.currentIndex - n;
        return n2 >= 0 ? n2 : this.MaxSensorReadIndex + n2 + 1;
    }

    public void setPredictor(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException(J3dI18N.getString("Sensor0"));
        }
        this.predictorType = n;
    }

    public int getPredictor() {
        return this.predictorType;
    }

    public void setPredictionPolicy(int n) {
        if (n != 16 && n != 32 && n != 64) {
            throw new IllegalArgumentException(J3dI18N.getString("Sensor1"));
        }
        this.predictionPolicy = n;
    }

    public int getPredictionPolicy() {
        return this.predictionPolicy;
    }

    public void setHotspot(Point3d point3d) {
        this.hotspot.set((Tuple3d)point3d);
    }

    public void getHotspot(Point3d point3d) {
        point3d.set((Tuple3d)this.hotspot);
    }

    public void setDevice(InputDevice inputDevice) {
        this.device = inputDevice;
    }

    public InputDevice getDevice() {
        return this.device;
    }

    public void getRead(Transform3D transform3D) {
        if (this.demand_driven) {
            this.device.pollAndProcessInput();
        }
        transform3D.set(this.readings[this.currentIndex].read);
    }

    public void getRead(Transform3D transform3D, long l) {
        this.getRead(transform3D);
    }

    public void lastRead(Transform3D transform3D) {
        transform3D.set(this.readings[this.currentIndex].read);
    }

    public void lastRead(Transform3D transform3D, int n) {
        if (n >= this.sensorReadCount) {
            throw new IllegalArgumentException(J3dI18N.getString("Sensor3"));
        }
        transform3D.set(this.readings[this.previousIndex((int)n)].read);
    }

    public long lastTime() {
        return this.readings[this.currentIndex].time;
    }

    public long lastTime(int n) {
        if (n >= this.sensorReadCount) {
            throw new IllegalArgumentException(J3dI18N.getString("Sensor4"));
        }
        return this.readings[this.previousIndex((int)n)].time;
    }

    public void lastButtons(int[] nArray) {
        System.arraycopy(this.readings[this.currentIndex].buttonValues, 0, nArray, 0, this.sensorButtonCount);
    }

    public void lastButtons(int n, int[] nArray) {
        if (n >= this.sensorReadCount) {
            throw new IllegalArgumentException(J3dI18N.getString("Sensor5"));
        }
        System.arraycopy(this.readings[this.previousIndex((int)n)].buttonValues, 0, nArray, 0, this.sensorButtonCount);
    }

    public int getSensorReadCount() {
        return this.sensorReadCount;
    }

    public void setSensorReadCount(int n) {
        this.sensorReadCount = n;
        this.MaxSensorReadIndex = this.sensorReadCount + 15 - 1;
        this.readings = new SensorRead[this.MaxSensorReadIndex + 1];
        for (int i = 0; i < this.MaxSensorReadIndex + 1; ++i) {
            this.readings[i] = new SensorRead(this.sensorButtonCount);
        }
        this.currentIndex = 0;
    }

    public int getSensorButtonCount() {
        return this.sensorButtonCount;
    }

    public SensorRead getCurrentSensorRead() {
        SensorRead sensorRead = new SensorRead(this.sensorButtonCount);
        sensorRead.set(this.readings[this.currentIndex]);
        return sensorRead;
    }

    public void setNextSensorRead(long l, Transform3D transform3D, int[] nArray) {
        int n = this.currentIndex + 1;
        if (n > this.MaxSensorReadIndex) {
            n = 0;
        }
        this.readings[n].setTime(l);
        this.readings[n].set(transform3D);
        if (this.sensorButtonCount > 0) {
            this.readings[n].setButtons(nArray);
        }
        this.currentIndex = n;
    }

    public void setNextSensorRead(SensorRead sensorRead) {
        int n = this.currentIndex + 1;
        if (n > this.MaxSensorReadIndex) {
            n = 0;
        }
        this.readings[n].set(sensorRead);
        this.currentIndex = n;
    }
}

