/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.DataIteratorAdapter;
import ucar.nc2.dt.StationImpl;
import ucar.nc2.dt.StationObsDatatype;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.point.StationObsDatasetImpl;
import ucar.nc2.dt.point.StationObsDatatypeImpl;
import ucar.nc2.dt.point.UnidataObsDatasetHelper;
import ucar.nc2.dt.point.UnidataStationObsDataset;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.Station;

public class UnidataStationObsMultidimDataset
extends StationObsDatasetImpl
implements TypedDatasetFactoryIF {
    private static Logger log = LoggerFactory.getLogger(UnidataStationObsMultidimDataset.class);
    private Dimension stationDim;
    private Dimension obsDim;
    private Variable latVar;
    private Variable lonVar;
    private Variable altVar;
    private Variable timeVar;
    private Variable timeNominalVar;
    private Variable stationIdVar;
    private Variable stationDescVar;
    private Variable numStationsVar;
    private StructureMembers structureMembers;

    public static boolean isValidFile(NetcdfFile ds) {
        if (!ds.findAttValueIgnoreCase(null, "cdm_data_type", "").equalsIgnoreCase(FeatureType.STATION.toString()) && !ds.findAttValueIgnoreCase(null, "cdm_datatype", "").equalsIgnoreCase(FeatureType.STATION.toString())) {
            return false;
        }
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        boolean convOk = false;
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.equalsIgnoreCase("Unidata Observation Dataset v1.0")) continue;
            convOk = true;
        }
        if (!convOk) {
            return false;
        }
        if (null == UnidataObsDatasetHelper.findDimension(ds, "station")) {
            return false;
        }
        Variable stationIndexVar = UnidataObsDatasetHelper.findVariable(ds, "parent_index");
        return stationIndexVar == null;
    }

    @Override
    public boolean isMine(NetcdfDataset ds) {
        return UnidataStationObsMultidimDataset.isValidFile(ds);
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new UnidataStationObsMultidimDataset(ncd);
    }

    public UnidataStationObsMultidimDataset() {
    }

    public UnidataStationObsMultidimDataset(NetcdfDataset ds) throws IOException {
        super(ds);
        this.stationDim = UnidataObsDatasetHelper.findDimension(ds, "station");
        this.obsDim = UnidataObsDatasetHelper.findDimension(ds, "observation");
        if (this.obsDim == null) {
            this.obsDim = ds.getUnlimitedDimension();
        }
        if (this.obsDim == null) {
            throw new IllegalStateException("must specify the observation dimension or use unlimited dimension");
        }
        this.latVar = UnidataObsDatasetHelper.getCoordinate(ds, AxisType.Lat);
        this.lonVar = UnidataObsDatasetHelper.getCoordinate(ds, AxisType.Lon);
        this.altVar = UnidataObsDatasetHelper.getCoordinate(ds, AxisType.Height);
        this.timeVar = UnidataObsDatasetHelper.getCoordinate(ds, AxisType.Time);
        this.timeNominalVar = UnidataObsDatasetHelper.findVariable(ds, "time_nominal");
        if (this.latVar == null) {
            throw new IllegalStateException("Missing latitude variable");
        }
        if (this.lonVar == null) {
            throw new IllegalStateException("Missing longitude coordinate variable");
        }
        if (this.timeVar == null) {
            throw new IllegalStateException("Missing time coordinate variable");
        }
        if (!this.latVar.getDimension(0).equals(this.stationDim)) {
            throw new IllegalStateException("latitude variable must use the station dimension");
        }
        if (!this.lonVar.getDimension(0).equals(this.stationDim)) {
            throw new IllegalStateException("longitude variable must use the station dimension");
        }
        if (!this.timeVar.getDimension(0).equals(this.stationDim)) {
            throw new IllegalStateException("time variable must use the station dimension");
        }
        if (this.altVar != null && !this.altVar.getDimension(0).equals(this.stationDim)) {
            throw new IllegalStateException("altitude variable must use the station dimension");
        }
        if (this.timeNominalVar != null && !this.timeNominalVar.getDimension(0).equals(this.stationDim)) {
            throw new IllegalStateException("timeNominal variable must use the station dimension");
        }
        this.stationIdVar = UnidataObsDatasetHelper.findVariable(ds, "station_id");
        this.stationDescVar = UnidataObsDatasetHelper.findVariable(ds, "station_description");
        this.numStationsVar = UnidataObsDatasetHelper.findVariable(ds, "number_stations");
        if (this.stationIdVar == null) {
            throw new IllegalStateException("Missing station id variable");
        }
        if (!this.stationIdVar.getDimension(0).equals(this.stationDim)) {
            throw new IllegalStateException("stationId variable must use the station dimension");
        }
        if (this.stationDescVar != null && !this.stationDescVar.getDimension(0).equals(this.stationDim)) {
            throw new IllegalStateException("stationDesc variable must use the station dimension");
        }
        this.structureMembers = new StructureMembers("UnidataStationObsMultidimDataset_obsStructure");
        for (Variable v : this.ncfile.getVariables()) {
            if (v.getRank() < 2 || !v.getDimension(0).equals(this.stationDim) || !v.getDimension(1).equals(this.obsDim)) continue;
            this.dataVariables.add(v);
            int[] shape = v.getShape();
            shape[0] = 1;
            shape[1] = 1;
            this.structureMembers.addMember(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType(), shape);
        }
        this.readStations();
        this.startDate = UnidataObsDatasetHelper.getStartDate(ds);
        this.endDate = UnidataObsDatasetHelper.getEndDate(ds);
        this.boundingBox = UnidataObsDatasetHelper.getBoundingBox(ds);
        if (null == this.boundingBox) {
            this.setBoundingBox();
        }
        this.setTimeUnits();
        this.title = ds.findAttValueIgnoreCase(null, "title", "");
        this.desc = ds.findAttValueIgnoreCase(null, "description", "");
    }

    private void readStations() throws IOException {
        Array stationIdArray = this.stationIdVar.read();
        ArrayChar stationDescArray = null;
        if (this.stationDescVar != null) {
            stationDescArray = (ArrayChar)this.stationDescVar.read();
        }
        Array latArray = this.readStationVariable(this.latVar);
        Array lonArray = this.readStationVariable(this.lonVar);
        Array elevArray = this.altVar != null ? this.readStationVariable(this.altVar) : null;
        int n = 0;
        n = this.numStationsVar != null ? this.numStationsVar.readScalarInt() : this.stationDim.getLength();
        Index ima = stationIdArray.getIndex();
        for (int i = 0; i < n; ++i) {
            String stationDesc;
            String stationName;
            ima.set(i);
            if (stationIdArray instanceof ArrayChar) {
                stationName = ((ArrayChar)stationIdArray).getString(i).trim();
                String string = stationDesc = this.stationDescVar != null ? stationDescArray.getString(i) : null;
                if (stationDesc != null) {
                    stationDesc = stationDesc.trim();
                }
            } else {
                stationName = stationIdArray.getObject(ima).toString();
                stationDesc = this.stationDescVar != null ? (String)stationDescArray.getObject(ima) : null;
            }
            MStationImpl bean = new MStationImpl(stationName, stationDesc, latArray.getFloat(ima), lonArray.getFloat(ima), this.altVar != null ? (double)elevArray.getFloat(ima) : Double.NaN, i, this.obsDim.getLength());
            this.stations.add(bean);
        }
    }

    private Array readStationVariable(Variable svar) throws IOException {
        if (svar.getRank() == 1) {
            return svar.read();
        }
        if (svar.getRank() == 2) {
            int[] shape = svar.getShape();
            shape[1] = 1;
            try {
                return svar.read(new int[2], shape).reduce(1);
            }
            catch (InvalidRangeException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        throw new IllegalStateException("Station variables must have rank 1 or 2");
    }

    @Override
    protected void setTimeUnits() {
        String timeUnitString = this.ncfile.findAttValueIgnoreCase(this.timeVar, "units", "seconds since 1970-01-01");
        try {
            this.timeUnit = new DateUnit(timeUnitString);
        }
        catch (Exception e) {
            this.parseInfo.append("Error on units = ").append(timeUnitString).append(" == ").append(e.getMessage()).append("\n");
            try {
                this.timeUnit = new DateUnit("seconds since 1970-01-01");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void setStartDate() {
    }

    @Override
    protected void setEndDate() {
    }

    @Override
    protected void setBoundingBox() {
        this.boundingBox = this.stationHelper.getBoundingBox();
    }

    @Override
    public List getData(CancelTask cancel) throws IOException {
        ArrayList<StationObsDatatype> allData = new ArrayList<StationObsDatatype>();
        for (Station s : this.getStations()) {
            MStationImpl ms = (MStationImpl)s;
            allData.addAll(ms.readObservations());
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return allData;
    }

    @Override
    public int getDataCount() {
        return this.stationDim.getLength() * this.obsDim.getLength();
    }

    @Override
    public List getData(Station s, CancelTask cancel) throws IOException {
        return ((MStationImpl)s).getObservations();
    }

    public static void main(String[] args) throws IOException {
        String filename = "C:/data/199707010000.LAKEOUT_DOMAIN2";
        NetcdfDataset ncds = new NetcdfDataset();
        UnidataStationObsDataset ods = new UnidataStationObsDataset(NetcdfDataset.openDataset(filename));
        StringBuffer sbuff = new StringBuffer(50000);
        ods.checkLinks(sbuff);
        System.out.println("\n\n" + sbuff.toString());
        ncds.shutdown();
    }

    private Array readData(Variable v, int stationIndex, int obsIndex) throws IOException {
        int[] shape = v.getShape();
        int[] origin = new int[v.getRank()];
        origin[0] = stationIndex;
        origin[1] = obsIndex;
        shape[0] = 1;
        shape[1] = 1;
        Array data = null;
        try {
            data = v.read(origin, shape);
        }
        catch (InvalidRangeException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return data;
    }

    @Override
    public DataIterator getDataIterator(Station s) {
        return ((MStationImpl)s).iterator();
    }

    @Override
    public DataIterator getDataIterator(Station s, Date start, Date end) {
        return ((MStationImpl)s).iterator(start, end);
    }

    @Override
    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return new DataIteratorAdapter(this.getData().iterator());
    }

    private class MStationObsImpl
    extends StationObsDatatypeImpl {
        int stationIndex;
        int obsIndex;
        List<VariableSimpleIF> dataVariables;
        StructureMembers sm;

        MStationObsImpl(Station s, int stationIndex, int obsIndex, List<VariableSimpleIF> dataVariables, StructureMembers sm) throws IOException {
            super(s, 0.0, 0.0);
            this.stationIndex = stationIndex;
            this.obsIndex = obsIndex;
            this.dataVariables = dataVariables;
            this.sm = sm;
            Array timeData = UnidataStationObsMultidimDataset.this.readData(UnidataStationObsMultidimDataset.this.timeVar, stationIndex, obsIndex);
            this.obsTime = timeData.getDouble(timeData.getIndex());
        }

        @Override
        public Date getNominalTimeAsDate() {
            return UnidataStationObsMultidimDataset.this.timeUnit.makeDate(this.getNominalTime());
        }

        @Override
        public Date getObservationTimeAsDate() {
            return UnidataStationObsMultidimDataset.this.timeUnit.makeDate(this.getObservationTime());
        }

        @Override
        public StructureData getData() throws IOException {
            StructureDataW sdata = new StructureDataW(this.sm);
            for (VariableSimpleIF vs : this.dataVariables) {
                Array data = UnidataStationObsMultidimDataset.this.readData((Variable)vs, this.stationIndex, this.obsIndex);
                sdata.setMemberData(vs.getShortName(), data);
            }
            return sdata;
        }
    }

    private class MStationImpl
    extends StationImpl {
        int station_index;

        private MStationImpl(String name, String desc, double lat, double lon, double elev, int station_index, int count) {
            super(name, desc, lat, lon, elev, count);
            this.station_index = station_index;
        }

        @Override
        protected List<StationObsDatatype> readObservations() throws IOException {
            ArrayList<StationObsDatatype> obs = new ArrayList<StationObsDatatype>();
            StationIterator siter = new StationIterator();
            while (siter.hasNext()) {
                obs.add((StationObsDatatype)siter.nextData());
            }
            Collections.sort(obs);
            return obs;
        }

        DataIterator iterator() {
            return new StationIterator();
        }

        DataIterator iterator(Date start, Date end) {
            return new StationIterator(start, end);
        }

        private class StationIterator
        implements DataIterator {
            int obsIndex = 0;
            double startTime;
            double endTime;
            boolean hasDateRange;

            StationIterator() {
            }

            StationIterator(Date start, Date end) {
                this.startTime = UnidataStationObsMultidimDataset.this.timeUnit.makeValue(start);
                this.endTime = UnidataStationObsMultidimDataset.this.timeUnit.makeValue(end);
                this.hasDateRange = true;
            }

            @Override
            public boolean hasNext() {
                return this.obsIndex < MStationImpl.this.count - 1;
            }

            @Override
            public Object nextData() throws IOException {
                double timeValue;
                if (!this.hasNext()) {
                    return null;
                }
                MStationObsImpl sobs = new MStationObsImpl(MStationImpl.this, MStationImpl.this.station_index, this.obsIndex, UnidataStationObsMultidimDataset.this.dataVariables, UnidataStationObsMultidimDataset.this.structureMembers);
                ++this.obsIndex;
                if (this.hasDateRange && ((timeValue = sobs.getObservationTime()) < this.startTime || timeValue > this.endTime)) {
                    return this.nextData();
                }
                return sobs;
            }

            @Override
            public Object next() {
                try {
                    return this.nextData();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

