/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.util.ArrayList;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.KDTreeC;

public class Object3DLabel
extends Object3D {
    ArrayList<Voxel3D> voxels = null;

    public Object3DLabel(ImageInt imageInt, int n) {
        this.value = n;
        this.labelImage = imageInt;
        this.init();
        this.resXY = 1.0;
        this.resZ = 1.0;
        this.units = "pix";
    }

    public Object3DLabel(ImagePlus imagePlus, int n) {
        this.value = n;
        ImageInt imageInt = null;
        if (imagePlus.getBitDepth() > 16) {
            IJ.log((String)"Image type not supported");
        } else {
            imageInt = (ImageInt)ImageHandler.wrap(imagePlus);
        }
        this.labelImage = imageInt;
        this.init();
        Calibration calibration = imagePlus.getCalibration();
        if (calibration != null) {
            if (calibration.scaled()) {
                this.resXY = calibration.getX(1.0);
                this.resZ = calibration.getZ(1.0);
                this.units = calibration.getUnits();
            } else {
                this.resXY = 1.0;
                this.resZ = 1.0;
                this.units = "pix";
            }
        }
    }

    private boolean insideImage(double d, double d2, double d3) {
        return d >= 0.0 && d < (double)this.labelImage.sizeX && d2 >= 0.0 && d2 < (double)this.labelImage.sizeY && d3 >= 0.0 && d3 < (double)this.labelImage.sizeZ;
    }

    public ArrayList listVoxels(ImageHandler imageHandler, double d) {
        ArrayList<Voxel3D> arrayList = new ArrayList<Voxel3D>();
        int n = this.getXmin();
        int n2 = this.getYmin();
        int n3 = this.getZmin();
        int n4 = this.getXmax();
        int n5 = this.getYmax();
        int n6 = this.getZmax();
        for (int i = n3; i <= n6; ++i) {
            for (int j = n2; j <= n5; ++j) {
                for (int k = n; k <= n4; ++k) {
                    float f;
                    if (this.labelImage.getPixel(k, j, i) != (float)this.value || !((double)(f = imageHandler != null ? imageHandler.getPixel(k, j, i) : (float)this.value) > d)) continue;
                    Voxel3D voxel3D = new Voxel3D(k, j, i, f);
                    arrayList.add(voxel3D);
                }
            }
        }
        return arrayList;
    }

    @Override
    protected void computeBounding() {
        this.xmin = this.labelImage.sizeX;
        this.xmax = 0;
        this.ymin = this.labelImage.sizeY;
        this.ymax = 0;
        this.zmin = this.labelImage.sizeZ;
        this.zmax = 0;
        for (int i = 0; i < this.labelImage.sizeZ; ++i) {
            for (int j = 0; j < this.labelImage.sizeY; ++j) {
                for (int k = 0; k < this.labelImage.sizeX; ++k) {
                    if (this.labelImage.getPixel(k, j, i) != (float)this.value) continue;
                    if (k < this.xmin) {
                        this.xmin = k;
                    }
                    if (k > this.xmax) {
                        this.xmax = k;
                    }
                    if (j < this.ymin) {
                        this.ymin = j;
                    }
                    if (j > this.ymax) {
                        this.ymax = j;
                    }
                    if (i < this.zmin) {
                        this.zmin = i;
                    }
                    if (i <= this.zmax) continue;
                    this.zmax = i;
                }
            }
        }
    }

    @Override
    public void computeContours() {
        this.contours = new ArrayList();
        this.kdtreeContours = new KDTreeC(3);
        this.kdtreeContours.setScale3(this.resXY, this.resXY, this.resZ);
        int n = this.labelImage.sizeX;
        int n2 = this.labelImage.sizeY;
        int n3 = this.labelImage.sizeZ;
        double d = this.resXY * this.resZ;
        double d2 = this.resXY * this.resXY;
        this.areaNbVoxels = 0.0;
        this.areaContactUnit = 0.0;
        this.areaContactVoxels = 0.0;
        for (int i = this.zmin; i <= this.zmax; ++i) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                for (int k = this.xmin; k <= this.xmax; ++k) {
                    boolean bl = false;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    int n10 = this.labelImage.getPixelInt(k, j, i);
                    if (n10 != this.value) continue;
                    if (k + 1 < n) {
                        n9 = this.labelImage.getPixelInt(k + 1, j, i);
                    }
                    if (k > 0) {
                        n8 = this.labelImage.getPixelInt(k - 1, j, i);
                    }
                    if (j + 1 < n2) {
                        n7 = this.labelImage.getPixelInt(k, j + 1, i);
                    }
                    if (j > 0) {
                        n6 = this.labelImage.getPixelInt(k, j - 1, i);
                    }
                    if (i + 1 < n3) {
                        n5 = this.labelImage.getPixelInt(k, j, i + 1);
                    }
                    if (i > 0) {
                        n4 = this.labelImage.getPixelInt(k, j, i - 1);
                    }
                    if (n9 != this.value) {
                        bl = true;
                        this.areaContactUnit += d;
                        this.areaContactVoxels += 1.0;
                    }
                    if (n8 != this.value) {
                        bl = true;
                        this.areaContactUnit += d;
                        this.areaContactVoxels += 1.0;
                    }
                    if (n7 != this.value) {
                        bl = true;
                        this.areaContactUnit += d;
                        this.areaContactVoxels += 1.0;
                    }
                    if (n6 != this.value) {
                        bl = true;
                        this.areaContactUnit += d;
                        this.areaContactVoxels += 1.0;
                    }
                    if (n5 != this.value) {
                        bl = true;
                        this.areaContactUnit += d2;
                        this.areaContactVoxels += 1.0;
                    }
                    if (n4 != this.value) {
                        bl = true;
                        this.areaContactUnit += d2;
                        this.areaContactVoxels += 1.0;
                    }
                    if (!bl) continue;
                    this.areaNbVoxels += 1.0;
                    Voxel3D voxel3D = new Voxel3D(k, j, i, this.value);
                    this.contours.add(voxel3D);
                    this.kdtreeContours.add(voxel3D.getArray(), voxel3D);
                }
            }
        }
    }

    @Override
    public Voxel3D getPixelMax(ImageHandler imageHandler) {
        Voxel3D voxel3D = null;
        float f = -3.4028235E38f;
        for (int i = this.zmin; i <= this.zmax; ++i) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                for (int k = this.xmin; k <= this.xmax; ++k) {
                    float f2;
                    if (this.labelImage.getPixel(k, j, i) != (float)this.value || !((f2 = imageHandler.getPixel(k, j, i)) > f)) continue;
                    f = f2;
                    voxel3D = new Voxel3D(k, j, i, f2);
                }
            }
        }
        return voxel3D;
    }

    private boolean isContour(int n, int n2, int n3) {
        if (this.labelImage.getPixel(n, n2, n3) != (float)this.value) {
            return false;
        }
        ArrayUtil arrayUtil = this.labelImage.getNeighborhood3x3x3(n, n2, n3);
        return !arrayUtil.hasOnlyValue(this.value);
    }

    @Override
    protected void computeCenter() {
        this.bx = 0.0;
        this.by = 0.0;
        this.bz = 0.0;
        int n = 0;
        for (int i = this.zmin; i <= this.zmax; ++i) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                for (int k = this.xmin; k <= this.xmax; ++k) {
                    if (this.labelImage.getPixel(k, j, i) != (float)this.value) continue;
                    this.bx += (double)k;
                    this.by += (double)j;
                    this.bz += (double)i;
                    ++n;
                }
            }
        }
        this.bx /= (double)n;
        this.by /= (double)n;
        this.bz /= (double)n;
        this.volume = n;
    }

    @Override
    protected void computeMassCenter(ImageHandler imageHandler) {
        if (imageHandler != null) {
            int n;
            this.cx = 0.0;
            this.cy = 0.0;
            this.cz = 0.0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = Double.MAX_VALUE;
            double d4 = -1.7976931348623157E308;
            for (n = this.zmin; n <= this.zmax; ++n) {
                for (int i = this.ymin; i <= this.ymax; ++i) {
                    for (int j = this.xmin; j <= this.xmax; ++j) {
                        if (this.labelImage.getPixel(j, i, n) != (float)this.value) continue;
                        double d5 = imageHandler.getPixel(j, i, n);
                        this.cx += (double)j * d5;
                        this.cy += (double)i * d5;
                        this.cz += (double)n * d5;
                        d += d5;
                        d2 += d5 * d5;
                        if (d5 > d4) {
                            d4 = d5;
                        }
                        if (!(d5 < d3)) continue;
                        d3 = d5;
                    }
                }
            }
            this.cx /= d;
            this.cy /= d;
            this.cz /= d;
            this.integratedDensity = d;
            this.pixmin = d3;
            this.pixmax = d4;
            n = this.getVolumePixels();
            this.sigma = Math.sqrt((d2 - d * d / (double)n) / (double)(n - 1));
        }
    }

    @Override
    public void computeMoments2(boolean bl) {
        this.s200 = 0.0;
        this.s110 = 0.0;
        this.s101 = 0.0;
        this.s020 = 0.0;
        this.s011 = 0.0;
        this.s002 = 0.0;
        for (int i = this.zmin; i <= this.zmax; ++i) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                for (int k = this.xmin; k <= this.xmax; ++k) {
                    if (this.labelImage.getPixel(k, j, i) != (float)this.value) continue;
                    this.s200 += ((double)k - this.bx) * ((double)k - this.bx);
                    this.s020 += ((double)j - this.by) * ((double)j - this.by);
                    this.s002 += ((double)i - this.bz) * ((double)i - this.bz);
                    this.s110 += ((double)k - this.bx) * ((double)j - this.by);
                    this.s101 += ((double)k - this.bx) * ((double)i - this.bz);
                    this.s011 += ((double)j - this.by) * ((double)i - this.bz);
                }
            }
        }
        this.s200 *= this.resXY * this.resXY;
        this.s020 *= this.resXY * this.resXY;
        this.s002 *= this.resZ * this.resZ;
        this.s110 *= this.resXY * this.resXY;
        this.s101 *= this.resXY * this.resZ;
        this.s011 *= this.resXY * this.resZ;
        if (bl) {
            this.s200 /= (double)this.volume;
            this.s020 /= (double)this.volume;
            this.s002 /= (double)this.volume;
            this.s110 /= (double)this.volume;
            this.s101 /= (double)this.volume;
            this.s011 /= (double)this.volume;
        }
        this.eigen = null;
    }

    @Override
    public void computeMoments3() {
        this.s003 = 0.0;
        this.s030 = 0.0;
        this.s300 = 0.0;
        this.s111 = 0.0;
        this.s012 = 0.0;
        this.s102 = 0.0;
        this.s021 = 0.0;
        this.s120 = 0.0;
        this.s201 = 0.0;
        this.s210 = 0.0;
        for (int i = this.zmin; i <= this.zmax; ++i) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                for (int k = this.xmin; k <= this.xmax; ++k) {
                    if (this.labelImage.getPixel(k, j, i) != (float)this.value) continue;
                    double d = (double)k - this.bx;
                    double d2 = (double)j - this.by;
                    double d3 = (double)i - this.bz;
                    this.s300 += d * d * d;
                    this.s030 += d2 * d2 * d2;
                    this.s003 += d3 * d3 * d3;
                    this.s210 += d * d * d2;
                    this.s201 += d * d * d3;
                    this.s120 += d2 * d2 * d;
                    this.s021 += d2 * d2 * d3;
                    this.s102 += d3 * d3 * d;
                    this.s012 += d3 * d3 * d2;
                    this.s111 += d * d2 * d3;
                }
            }
        }
        this.s300 *= this.resXY * this.resXY * this.resXY;
        this.s030 *= this.resXY * this.resXY * this.resXY;
        this.s003 *= this.resZ * this.resZ * this.resZ;
        this.s210 *= this.resXY * this.resXY * this.resXY;
        this.s201 *= this.resXY * this.resXY * this.resZ;
        this.s120 *= this.resXY * this.resXY * this.resXY;
        this.s021 *= this.resXY * this.resXY * this.resZ;
        this.s102 *= this.resZ * this.resZ * this.resXY;
        this.s012 *= this.resZ * this.resZ * this.resXY;
        this.s111 *= this.resXY * this.resXY * this.resZ;
        this.s300 /= (double)this.volume;
        this.s030 /= (double)this.volume;
        this.s003 /= (double)this.volume;
        this.s210 /= (double)this.volume;
        this.s201 /= (double)this.volume;
        this.s120 /= (double)this.volume;
        this.s021 /= (double)this.volume;
        this.s102 /= (double)this.volume;
        this.s012 /= (double)this.volume;
        this.s111 /= (double)this.volume;
    }

    @Override
    public void computeMoments4() {
        this.s211 = 0.0;
        this.s112 = 0.0;
        this.s121 = 0.0;
        this.s022 = 0.0;
        this.s202 = 0.0;
        this.s220 = 0.0;
        this.s040 = 0.0;
        this.s040 = 0.0;
        this.s400 = 0.0;
        this.s031 = 0.0;
        this.s013 = 0.0;
        this.s310 = 0.0;
        this.s130 = 0.0;
        this.s301 = 0.0;
        this.s103 = 0.0;
        for (int i = this.zmin; i <= this.zmax; ++i) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                for (int k = this.xmin; k <= this.xmax; ++k) {
                    if (this.labelImage.getPixel(k, j, i) != (float)this.value) continue;
                    double d = (double)k - this.bx;
                    double d2 = (double)j - this.by;
                    double d3 = (double)i - this.bz;
                    this.s400 += d * d * d * d;
                    this.s040 += d2 * d2 * d2 * d2;
                    this.s004 += d3 * d3 * d3 * d3;
                    this.s220 += d * d * d2 * d2;
                    this.s202 += d * d * d3 * d3;
                    this.s022 += d2 * d2 * d3 * d3;
                    this.s121 += d * d2 * d2 * d3;
                    this.s112 += d * d2 * d3 * d3;
                    this.s211 += d * d * d2 * d3;
                    this.s103 += d * d3 * d3 * d3;
                    this.s301 += d * d * d * d3;
                    this.s130 += d * d2 * d2 * d2;
                    this.s310 += d * d * d * d2;
                    this.s013 += d2 * d3 * d3 * d3;
                    this.s031 += d2 * d2 * d2 * d3;
                }
            }
        }
        this.s400 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s040 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s004 *= this.resZ * this.resZ * this.resZ * this.resZ;
        this.s220 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s202 *= this.resXY * this.resXY * this.resZ * this.resZ;
        this.s022 *= this.resXY * this.resXY * this.resZ * this.resZ;
        this.s121 *= this.resXY * this.resXY * this.resXY * this.resZ;
        this.s112 *= this.resXY * this.resXY * this.resZ * this.resZ;
        this.s211 *= this.resXY * this.resXY * this.resXY * this.resZ;
        this.s103 *= this.resXY * this.resZ * this.resZ * this.resZ;
        this.s301 *= this.resXY * this.resXY * this.resXY * this.resZ;
        this.s130 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s310 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s013 *= this.resXY * this.resZ * this.resZ * this.resZ;
        this.s031 *= this.resXY * this.resXY * this.resXY * this.resZ;
    }

    public void computeMomentsInertia() {
        this.s200 = 0.0;
        this.s110 = 0.0;
        this.s101 = 0.0;
        this.s020 = 0.0;
        this.s011 = 0.0;
        this.s002 = 0.0;
        for (int i = this.zmin; i <= this.zmax; ++i) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                for (int k = this.xmin; k <= this.xmax; ++k) {
                    if (this.labelImage.getPixel(k, j, i) != (float)this.value) continue;
                    this.s200 += this.resXY * this.resXY * ((double)j - this.by) * ((double)j - this.by) + this.resZ * this.resZ * ((double)i - this.bz) * ((double)i - this.bz);
                    this.s020 += this.resXY * this.resXY * ((double)k - this.bx) * ((double)k - this.bx) + this.resZ * this.resZ * ((double)i - this.bz) * ((double)i - this.bz);
                    this.s002 += this.resXY * this.resXY * ((double)k - this.bx) * ((double)k - this.bx) + this.resXY * this.resXY * ((double)j - this.by) * ((double)j - this.by);
                    this.s110 += this.resXY * this.resXY * ((double)k - this.bx) * ((double)j - this.by);
                    this.s101 += this.resXY * this.resZ * ((double)k - this.bx) * ((double)i - this.bz);
                    this.s011 += this.resXY * this.resZ * ((double)j - this.by) * ((double)i - this.bz);
                }
            }
        }
    }

    @Override
    public void draw(ByteProcessor byteProcessor, int n, int n2) {
        for (int i = this.xmin; i <= this.xmax; ++i) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                if (this.labelImage.getPixel(i, j, n) != (float)this.value) continue;
                byteProcessor.putPixel(i, j, n2);
            }
        }
    }

    @Override
    public void draw(ImageHandler imageHandler, int n) {
        for (int i = this.zmin; i <= this.zmax; ++i) {
            for (int j = this.xmin; j <= this.xmax; ++j) {
                for (int k = this.ymin; k <= this.ymax; ++k) {
                    if (this.labelImage.getPixel(j, k, i) != (float)this.value) continue;
                    imageHandler.setPixel(j, k, i, n);
                }
            }
        }
    }

    @Override
    public void draw(ImageStack imageStack, int n, int n2, int n3) {
        Color color = new Color(n, n2, n3);
        for (int i = this.zmin; i <= this.zmax; ++i) {
            ImageProcessor imageProcessor = imageStack.getProcessor(i + 1);
            imageProcessor.setColor(color);
            for (int j = this.xmin; j <= this.xmax; ++j) {
                for (int k = this.ymin; k <= this.ymax; ++k) {
                    if (this.labelImage.getPixel(j, k, i) != (float)this.value) continue;
                    imageProcessor.drawPixel(j, k);
                }
            }
        }
    }

    @Override
    public void draw(ImageStack imageStack, int n) {
        for (int i = this.zmin; i <= this.zmax; ++i) {
            ImageProcessor imageProcessor = imageStack.getProcessor(i + 1);
            for (int j = this.xmin; j <= this.xmax; ++j) {
                for (int k = this.ymin; k <= this.ymax; ++k) {
                    if (this.labelImage.getPixel(j, k, i) != (float)this.value) continue;
                    imageProcessor.putPixel(j, k, n);
                }
            }
        }
    }

    public void drawIntersection(ImageStack imageStack, Object3DLabel object3DLabel, int n, int n2, int n3) {
        ImageInt imageInt = object3DLabel.getLabelImage();
        int n4 = object3DLabel.getValue();
        Color color = new Color(n, n2, n3);
        for (int i = this.zmin; i <= this.zmax; ++i) {
            ImageProcessor imageProcessor = imageStack.getProcessor(i + 1);
            imageProcessor.setColor(color);
            for (int j = this.xmin; j <= this.xmax; ++j) {
                for (int k = this.ymin; k <= this.ymax; ++k) {
                    if (this.labelImage.getPixel(j, k, i) != (float)this.value || imageInt.getPixel(j, k, i) != (float)n4) continue;
                    imageProcessor.drawPixel(j, k);
                }
            }
        }
    }

    public void drawIntersection(ImageStack imageStack, Object3DLabel object3DLabel, int n) {
        ImageInt imageInt = object3DLabel.getLabelImage();
        int n2 = object3DLabel.getValue();
        for (int i = this.zmin; i <= this.zmax; ++i) {
            ImageProcessor imageProcessor = imageStack.getProcessor(i + 1);
            for (int j = this.xmin; j <= this.xmax; ++j) {
                for (int k = this.ymin; k <= this.ymax; ++k) {
                    if (this.labelImage.getPixel(j, k, i) != (float)this.value || imageInt.getPixel(j, k, i) != (float)n2) continue;
                    imageProcessor.putPixel(j, k, n);
                }
            }
        }
    }

    @Override
    public Roi createRoi(int n) {
        int n2 = this.labelImage.sizeX;
        int n3 = this.labelImage.sizeY;
        ByteProcessor byteProcessor = new ByteProcessor(n2, n3);
        this.draw(byteProcessor, n, 255);
        ImagePlus imagePlus = new ImagePlus("mask " + n, (ImageProcessor)byteProcessor);
        ThresholdToSelection thresholdToSelection = new ThresholdToSelection();
        thresholdToSelection.setup("", imagePlus);
        thresholdToSelection.run((ImageProcessor)byteProcessor);
        imagePlus.updateAndDraw();
        return imagePlus.getRoi();
    }

    @Override
    public ArrayList<Voxel3D> getVoxels() {
        if (this.voxels == null) {
            this.voxels = this.listVoxels(null);
        }
        return this.voxels;
    }

    protected Object3DVoxels buildObject3DVoxels() {
        Object3DVoxels object3DVoxels = new Object3DVoxels(this.getVoxels());
        object3DVoxels.setCalibration(this.getCalibration());
        return object3DVoxels;
    }

    @Override
    public void writeVoxels(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void translate(double d, double d2, double d3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getColoc(Object3D object3D) {
        if (this.disjointBox(object3D)) {
            return 0;
        }
        int n = 0;
        int n2 = object3D.getValue();
        ImageInt imageInt = ((Object3DLabel)object3D).getLabelImage();
        int n3 = this.getXmin();
        int n4 = this.getYmin();
        int n5 = this.getZmin();
        int n6 = this.getXmax();
        int n7 = this.getYmax();
        int n8 = this.getZmax();
        if (object3D != null) {
            n3 = Math.max(n3, object3D.getXmin());
            n4 = Math.max(n4, object3D.getYmin());
            n5 = Math.max(n5, object3D.getZmin());
            n6 = Math.min(n6, object3D.getXmax());
            n7 = Math.min(n7, object3D.getYmax());
            n8 = Math.min(n8, object3D.getZmax());
        }
        for (int i = n5; i <= n8; ++i) {
            for (int j = n4; j <= n7; ++j) {
                for (int k = n3; k <= n6; ++k) {
                    if (this.labelImage.getPixel(k, j, i) != (float)this.value || imageInt.getPixel(k, j, i) != (float)n2) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    @Override
    public boolean hasOneVoxelColoc(Object3D object3D) {
        if (this.disjointBox(object3D)) {
            return false;
        }
        if (this.getLabelImage() == null || object3D.getLabelImage() == null) {
            return false;
        }
        int n = object3D.getValue();
        ImageInt imageInt = object3D.getLabelImage();
        int n2 = this.getXmin();
        int n3 = this.getYmin();
        int n4 = this.getZmin();
        int n5 = this.getXmax();
        int n6 = this.getYmax();
        int n7 = this.getZmax();
        n2 = Math.max(n2, object3D.getXmin());
        n3 = Math.max(n3, object3D.getYmin());
        n4 = Math.max(n4, object3D.getZmin());
        n5 = Math.min(n5, object3D.getXmax());
        n6 = Math.min(n6, object3D.getYmax());
        n7 = Math.min(n7, object3D.getZmax());
        int n8 = this.labelImage.offsetX;
        int n9 = this.labelImage.offsetY;
        int n10 = this.labelImage.offsetZ;
        int n11 = imageInt.offsetX;
        int n12 = imageInt.offsetY;
        int n13 = imageInt.offsetZ;
        for (int i = n4; i <= n7; ++i) {
            for (int j = n3; j <= n6; ++j) {
                for (int k = n2; k <= n5; ++k) {
                    if (this.labelImage.getPixel(k - n8, j - n9, i - n10) != (float)this.value || imageInt.getPixel(k - n11, j - n12, i - n13) != (float)n) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public ArrayUtil listValues(ImageHandler imageHandler) {
        ArrayUtil arrayUtil = new ArrayUtil(this.getVolumePixels());
        int n = this.getXmin();
        int n2 = this.getYmin();
        int n3 = this.getZmin();
        int n4 = this.getXmax();
        int n5 = this.getYmax();
        int n6 = this.getZmax();
        int n7 = 0;
        for (int i = n3; i <= n6; ++i) {
            for (int j = n2; j <= n5; ++j) {
                for (int k = n; k <= n4; ++k) {
                    if (this.labelImage.getPixel(k, j, i) != (float)this.value) continue;
                    arrayUtil.putValue(n7, imageHandler.getPixel(k, j, i));
                    ++n7;
                }
            }
        }
        return arrayUtil;
    }
}

