/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array9D;
import mitiv.array.Byte9D;
import mitiv.array.Double9D;
import mitiv.array.Float1D;
import mitiv.array.Float8D;
import mitiv.array.FloatArray;
import mitiv.array.Int9D;
import mitiv.array.Long9D;
import mitiv.array.ShapedArray;
import mitiv.array.Short9D;
import mitiv.array.impl.FlatFloat9D;
import mitiv.array.impl.StriddenFloat9D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.FloatGenerator;

public abstract class Float9D
extends Array9D
implements FloatArray {
    protected Float9D(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        super(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
    }

    protected Float9D(int[] dims) {
        super(dims);
    }

    protected Float9D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 4;
    }

    public abstract float get(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, float var10);

    @Override
    public void fill(float value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, value);
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, value);
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
    }

    @Override
    public void increment(float value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9) + value);
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9) + value);
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
    }

    @Override
    public void decrement(float value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9) - value);
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9) - value);
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
    }

    @Override
    public void scale(float value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9) * value);
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9) * value);
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
    }

    @Override
    public void map(FloatFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, function.apply(this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9)));
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, function.apply(this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9)));
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
    }

    @Override
    public void fill(FloatGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, generator.nextFloat());
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, generator.nextFloat());
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
    }

    @Override
    public void scan(FloatScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                if (initialized) {
                                                    scanner.update(this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9));
                                                } else {
                                                    scanner.initialize(this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9));
                                                    initialized = true;
                                                }
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                if (initialized) {
                                                    scanner.update(this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9));
                                                } else {
                                                    scanner.initialize(this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9));
                                                    initialized = true;
                                                }
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
    }

    @Override
    public float[] flatten(boolean forceCopy) {
        float[] out = new float[this.number];
        int i = -1;
        int i9 = 0;
        while (i9 < this.dim9) {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            out[++i] = this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
            ++i9;
        }
        return out;
    }

    @Override
    public float[] flatten() {
        return this.flatten(false);
    }

    @Override
    public float min() {
        float minValue = this.get(0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                if (skip) {
                                                    skip = false;
                                                } else {
                                                    float value = this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                                    if (value < minValue) {
                                                        minValue = value;
                                                    }
                                                }
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                if (skip) {
                                                    skip = false;
                                                } else {
                                                    float value = this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                                    if (value < minValue) {
                                                        minValue = value;
                                                    }
                                                }
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
        return minValue;
    }

    @Override
    public float max() {
        float maxValue = this.get(0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                if (skip) {
                                                    skip = false;
                                                } else {
                                                    float value = this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                                    if (value > maxValue) {
                                                        maxValue = value;
                                                    }
                                                }
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                if (skip) {
                                                    skip = false;
                                                } else {
                                                    float value = this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                                    if (value > maxValue) {
                                                        maxValue = value;
                                                    }
                                                }
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
        return maxValue;
    }

    @Override
    public float[] getMinAndMax() {
        float[] result = new float[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(float[] mm) {
        float minValue;
        float maxValue = minValue = this.get(0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                if (skip) {
                                                    skip = false;
                                                } else {
                                                    float value = this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                                    if (value < minValue) {
                                                        minValue = value;
                                                    }
                                                    if (value > maxValue) {
                                                        maxValue = value;
                                                    }
                                                }
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                if (skip) {
                                                    skip = false;
                                                } else {
                                                    float value = this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                                    if (value < minValue) {
                                                        minValue = value;
                                                    }
                                                    if (value > maxValue) {
                                                        maxValue = value;
                                                    }
                                                }
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public float sum() {
        float totalValue = 0.0f;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                totalValue += this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                totalValue += this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte9D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i9 = 0;
        while (i9 < this.dim9) {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            out[++i] = (byte)this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
            ++i9;
        }
        return Byte9D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8, this.dim9);
    }

    @Override
    public Short9D toShort() {
        short[] out = new short[this.number];
        int i = -1;
        int i9 = 0;
        while (i9 < this.dim9) {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            out[++i] = (short)this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
            ++i9;
        }
        return Short9D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8, this.dim9);
    }

    @Override
    public Int9D toInt() {
        int[] out = new int[this.number];
        int i = -1;
        int i9 = 0;
        while (i9 < this.dim9) {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            out[++i] = (int)this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
            ++i9;
        }
        return Int9D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8, this.dim9);
    }

    @Override
    public Long9D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i9 = 0;
        while (i9 < this.dim9) {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            out[++i] = (long)this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
            ++i9;
        }
        return Long9D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8, this.dim9);
    }

    @Override
    public Float9D toFloat() {
        return this;
    }

    @Override
    public Double9D toDouble() {
        double[] out = new double[this.number];
        int i = -1;
        int i9 = 0;
        while (i9 < this.dim9) {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            out[++i] = this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
            ++i9;
        }
        return Double9D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8, this.dim9);
    }

    @Override
    public Float9D copy() {
        return new FlatFloat9D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Float9D src = arr.getType() == 4 ? (Float9D)arr : (Float9D)arr.toFloat();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, src.get(i1, i2, i3, i4, i5, i6, i7, i8, i9));
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, src.get(i1, i2, i3, i4, i5, i6, i7, i8, i9));
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, (float)src.get(++i));
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, (float)src.get(++i));
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Float9D create() {
        return new FlatFloat9D(this.getShape());
    }

    public static Float9D create(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        return new FlatFloat9D(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
    }

    public static Float9D create(int[] dims) {
        return new FlatFloat9D(dims);
    }

    public static Float9D create(Shape shape) {
        return new FlatFloat9D(shape);
    }

    public static Float9D wrap(float[] data, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        return new FlatFloat9D(data, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
    }

    public static Float9D wrap(float[] data, int[] dims) {
        return new FlatFloat9D(data, dims);
    }

    public static Float9D wrap(float[] data, Shape shape) {
        return new FlatFloat9D(data, shape);
    }

    public static Float9D wrap(float[] data, int offset, int stride1, int stride2, int stride3, int stride4, int stride5, int stride6, int stride7, int stride8, int stride9, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        return new StriddenFloat9D(data, offset, stride1, stride2, stride3, stride4, stride5, stride6, stride7, stride8, stride9, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
    }

    @Override
    public abstract Float8D slice(int var1);

    @Override
    public abstract Float8D slice(int var1, int var2);

    @Override
    public abstract Float9D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7, Range var8, Range var9);

    @Override
    public abstract Float9D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, int[] var9);

    @Override
    public abstract Float1D as1D();
}

