/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.WrapperFComplexMatrix2D;

public class SparseCCMFComplexMatrix2D
extends WrapperFComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseFComplexMatrix1D[] elements;

    public SparseCCMFComplexMatrix2D(int rows, int columns) {
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        this.elements = new SparseFComplexMatrix1D[columns];
        int i = 0;
        while (i < columns) {
            this.elements[i] = new SparseFComplexMatrix1D(rows);
            ++i;
        }
    }

    public SparseFComplexMatrix1D[] elements() {
        return this.elements;
    }

    @Override
    public float[] getQuick(int row, int column) {
        return this.elements[column].getQuick(row);
    }

    @Override
    public void setQuick(int row, int column, float[] value) {
        this.elements[column].setQuick(row, value);
    }

    @Override
    public void setQuick(int row, int column, float re, float im) {
        this.elements[column].setQuick(row, re, im);
    }

    @Override
    public void trimToSize() {
        int c = 0;
        while (c < this.columns) {
            this.elements[c].trimToSize();
            ++c;
        }
    }

    @Override
    public SparseFComplexMatrix1D viewColumn(int column) {
        return this.elements[column];
    }

    @Override
    protected FComplexMatrix2D getContent() {
        return this;
    }

    @Override
    public FComplexMatrix2D like(int rows, int columns) {
        return new SparseCCMFComplexMatrix2D(rows, columns);
    }
}

