/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.SelectedSparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

public class SparseDComplexMatrix1D
extends DComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, double[]> elements;

    public SparseDComplexMatrix1D(double[] values) {
        this(values.length);
        this.assign(values);
    }

    public SparseDComplexMatrix1D(int size) {
        this.setUp(size);
        this.elements = new ConcurrentHashMap(size / 1000);
    }

    protected SparseDComplexMatrix1D(int size, ConcurrentHashMap<Long, double[]> elements, int offset, int stride) {
        this.setUp(size, offset, stride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public DComplexMatrix1D assign(double[] value) {
        if (this.isNoView && value[0] == 0.0 && value[1] == 0.0) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public synchronized double[] getQuick(int index) {
        double[] elem = this.elements.get((long)this.zero + (long)index * (long)this.stride);
        if (elem != null) {
            return new double[]{elem[0], elem[1]};
        }
        return new double[2];
    }

    @Override
    public ConcurrentHashMap<Long, double[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix1D other) {
        if (other instanceof SelectedSparseDComplexMatrix1D) {
            SelectedSparseDComplexMatrix1D otherMatrix = (SelectedSparseDComplexMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseDComplexMatrix1D) {
            SparseDComplexMatrix1D otherMatrix = (SparseDComplexMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int rank) {
        return (long)this.zero + (long)rank * (long)this.stride;
    }

    @Override
    public DComplexMatrix1D like(int size) {
        return new SparseDComplexMatrix1D(size);
    }

    @Override
    public DComplexMatrix2D like2D(int rows, int columns) {
        return new SparseDComplexMatrix2D(rows, columns);
    }

    @Override
    public DComplexMatrix2D reshape(final int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        final SparseDComplexMatrix2D M = new SparseDComplexMatrix2D(rows, columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int idx = c * rows;
                            int r = 0;
                            while (r < rows) {
                                double[] elem;
                                if ((elem = SparseDComplexMatrix1D.this.getQuick(idx++))[0] != 0.0 || elem[1] != 0.0) {
                                    M.setQuick(r, c, elem);
                                }
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int c = 0;
            while (c < columns) {
                int r = 0;
                while (r < rows) {
                    double[] elem;
                    if ((elem = this.getQuick(idx++))[0] != 0.0 || elem[1] != 0.0) {
                        ((DComplexMatrix2D)M).setQuick(r, c, elem);
                    }
                    ++r;
                }
                ++c;
            }
        }
        return M;
    }

    @Override
    public DComplexMatrix3D reshape(int slices, final int rows, final int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        final SparseDComplexMatrix3D M = new SparseDComplexMatrix3D(slices, rows, columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int c = 0;
                            while (c < columns) {
                                int idx = s * rows * columns + c * rows;
                                int r = 0;
                                while (r < rows) {
                                    double[] elem;
                                    if ((elem = SparseDComplexMatrix1D.this.getQuick(idx++))[0] != 0.0 || elem[1] != 0.0) {
                                        M.setQuick(s, r, c, elem);
                                    }
                                    ++r;
                                }
                                ++c;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int s = 0;
            while (s < slices) {
                int c = 0;
                while (c < columns) {
                    int r = 0;
                    while (r < rows) {
                        double[] elem;
                        if ((elem = this.getQuick(idx++))[0] != 0.0 || elem[1] != 0.0) {
                            ((DComplexMatrix3D)M).setQuick(s, r, c, elem);
                        }
                        ++r;
                    }
                    ++c;
                }
                ++s;
            }
        }
        return M;
    }

    @Override
    public synchronized void setQuick(int index, double[] value) {
        long i = (long)this.zero + (long)index * (long)this.stride;
        if (value[0] == 0.0 && value[1] == 0.0) {
            this.elements.remove(i);
        } else {
            this.elements.put(i, value);
        }
    }

    @Override
    public synchronized void setQuick(int index, double re, double im) {
        long i = (long)this.zero + (long)index * (long)this.stride;
        if (re == 0.0 && im == 0.0) {
            this.elements.remove(i);
        } else {
            this.elements.put(i, new double[]{re, im});
        }
    }

    @Override
    protected DComplexMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedSparseDComplexMatrix1D(this.elements, offsets);
    }

    @Override
    public DoubleMatrix1D getImaginaryPart() {
        final SparseDoubleMatrix1D Im = new SparseDoubleMatrix1D(this.size);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            Im.setQuick(i, SparseDComplexMatrix1D.this.getQuick(i)[1]);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                ((DoubleMatrix1D)Im).setQuick(i, this.getQuick(i)[1]);
                ++i;
            }
        }
        return Im;
    }

    @Override
    public DoubleMatrix1D getRealPart() {
        final SparseDoubleMatrix1D Re = new SparseDoubleMatrix1D(this.size);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            Re.setQuick(i, SparseDComplexMatrix1D.this.getQuick(i)[0]);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                ((DoubleMatrix1D)Re).setQuick(i, this.getQuick(i)[0]);
                ++i;
            }
        }
        return Re;
    }
}

