/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.units.quantity.Temperature;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsTemperatureEnumHandler;
import ome.xml.model.primitives.PrimitiveNumber;

public enum UnitsTemperature implements Enumeration
{
    DEGREEC("\u00b0C"),
    DEGREEF("\u00b0F"),
    K("K"),
    DEGREER("\u00b0R");

    private final String value;

    private UnitsTemperature(String value) {
        this.value = value;
    }

    public static UnitsTemperature fromString(String value) throws EnumerationException {
        if ("\u00b0C".equals(value)) {
            return DEGREEC;
        }
        if ("\u00b0F".equals(value)) {
            return DEGREEF;
        }
        if ("K".equals(value)) {
            return K;
        }
        if ("\u00b0R".equals(value)) {
            return DEGREER;
        }
        String s = String.format("'%s' not a supported value of '%s'", value, UnitsTemperature.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends PrimitiveNumber> Temperature create(T newValue, UnitsTemperature newUnit) {
        Temperature theQuantity = null;
        try {
            theQuantity = UnitsTemperatureEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Number> Temperature create(T newValue, UnitsTemperature newUnit) {
        Temperature theQuantity = null;
        try {
            theQuantity = UnitsTemperatureEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }
}

