/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.optim.LineSearchTask;
import mitiv.optim.OptimStatus;

public abstract class LineSearch {
    protected double stp = 0.0;
    protected double stpmin = 0.0;
    protected double stpmax = 0.0;
    protected double finit = 0.0;
    protected double ginit = 0.0;
    private LineSearchTask task;
    private OptimStatus status;

    protected LineSearch() {
        this.failure(OptimStatus.NOT_STARTED);
    }

    public LineSearchTask start(double f0, double g0, double nextStep, double minStep, double maxStep) {
        if (minStep < 0.0) {
            this.failure(OptimStatus.STPMIN_LT_ZERO);
        } else if (minStep > maxStep) {
            this.failure(OptimStatus.STPMIN_GT_STPMAX);
        } else if (nextStep < minStep) {
            this.failure(OptimStatus.STEP_LT_STPMIN);
        } else if (nextStep > maxStep) {
            this.failure(OptimStatus.STEP_GT_STPMAX);
        } else if (g0 >= 0.0) {
            this.failure(OptimStatus.NOT_A_DESCENT);
        } else {
            this.stp = nextStep;
            this.stpmin = minStep;
            this.stpmax = maxStep;
            this.finit = f0;
            this.ginit = g0;
            this.startHook();
        }
        return this.task;
    }

    public LineSearchTask iterate(double alpha, double f, double df) {
        if (this.task == LineSearchTask.SEARCH) {
            if (alpha != this.stp) {
                this.failure(OptimStatus.STEP_CHANGED);
            } else {
                this.iterateHook(f, df);
                if (this.status == OptimStatus.SUCCESS) {
                    if (this.stp >= this.stpmax) {
                        if (this.stp >= this.stpmax) {
                            this.warning(OptimStatus.STEP_EQ_STPMAX);
                        }
                        this.stp = this.stpmax;
                    } else if (this.stp <= this.stpmin) {
                        if (this.stp <= this.stpmin) {
                            this.warning(OptimStatus.STEP_EQ_STPMIN);
                        }
                        this.stp = this.stpmin;
                    }
                }
            }
        } else {
            this.failure(OptimStatus.NOT_STARTED);
        }
        return this.task;
    }

    protected void startHook() {
        this.success(LineSearchTask.SEARCH);
    }

    protected abstract void iterateHook(double var1, double var3);

    public double getStep() {
        return this.stp;
    }

    public final LineSearchTask getTask() {
        return this.task;
    }

    public final OptimStatus getStatus() {
        return this.status;
    }

    protected final LineSearchTask failure(OptimStatus status) {
        this.status = status;
        this.task = LineSearchTask.ERROR;
        return this.task;
    }

    protected final LineSearchTask warning(OptimStatus status) {
        this.status = status;
        this.task = LineSearchTask.WARNING;
        return this.task;
    }

    protected final LineSearchTask success(LineSearchTask task) {
        this.status = OptimStatus.SUCCESS;
        this.task = task;
        return this.task;
    }

    public final String getMessage() {
        return this.status == OptimStatus.SUCCESS ? this.task.toString() : this.status.toString();
    }

    public final boolean hasErrors() {
        return this.task.isError();
    }

    public final boolean hasWarnings() {
        return this.task.isWarning();
    }

    public final boolean converged() {
        return this.task == LineSearchTask.CONVERGENCE;
    }

    public final boolean finished() {
        return this.task != LineSearchTask.SEARCH;
    }

    static int checkWolfeConditions(double alpha, double f, double g, double finit, double ginit, double ftol, double gtol) {
        if (f - finit > ftol * ginit * alpha) {
            return 0;
        }
        double gtest = gtol * ginit;
        if (g < gtest) {
            return 1;
        }
        if (Math.abs(g) > -gtest) {
            return 2;
        }
        return 3;
    }
}

