/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Double1D;
import mitiv.array.DoubleScalar;
import mitiv.array.impl.Helper;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.random.DoubleGenerator;

public class SelectedDouble1D
extends Double1D {
    static final int order = 0;
    final double[] data;
    final int[] idx1;

    public SelectedDouble1D(double[] arr, int[] idx1) {
        super(idx1.length);
        this.data = arr;
        this.idx1 = idx1;
    }

    @Override
    public final void checkSanity() {
        int indexMax;
        int offsetMin = 0;
        int offsetMax = 0;
        int indexMin = indexMax = this.idx1[0];
        int i1 = 1;
        while (i1 < this.dim1) {
            int index = this.idx1[i1];
            if (index < indexMin) {
                indexMin = index;
            }
            if (index > indexMax) {
                indexMax = index;
            }
            ++i1;
        }
        if ((offsetMin += indexMin) < 0 || (offsetMax += indexMax) >= this.data.length) {
            throw new IndexOutOfBoundsException("Selected indices are out of bounds.");
        }
    }

    final int index(int i1) {
        return this.idx1[i1];
    }

    @Override
    public final double get(int i1) {
        return this.data[this.idx1[i1]];
    }

    @Override
    public final void set(int i1, double value) {
        this.data[this.idx1[i1]] = value;
    }

    @Override
    public final int getOrder() {
        return 0;
    }

    @Override
    public void fill(double value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1 = this.idx1[i1];
            this.data[j1] = value;
            ++i1;
        }
    }

    @Override
    public void fill(DoubleGenerator generator) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1 = this.idx1[i1];
            this.data[j1] = generator.nextDouble();
            ++i1;
        }
    }

    @Override
    public void increment(double value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1;
            int n = j1 = this.idx1[i1];
            this.data[n] = this.data[n] + value;
            ++i1;
        }
    }

    @Override
    public void decrement(double value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1;
            int n = j1 = this.idx1[i1];
            this.data[n] = this.data[n] - value;
            ++i1;
        }
    }

    @Override
    public void scale(double value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1;
            int n = j1 = this.idx1[i1];
            this.data[n] = this.data[n] * value;
            ++i1;
        }
    }

    @Override
    public void map(DoubleFunction function) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1 = this.idx1[i1];
            this.data[j1] = function.apply(this.data[j1]);
            ++i1;
        }
    }

    @Override
    public void scan(DoubleScanner scanner) {
        boolean initialized = false;
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1 = this.idx1[i1];
            if (initialized) {
                scanner.update(this.data[j1]);
            } else {
                scanner.initialize(this.data[j1]);
                initialized = true;
            }
            ++i1;
        }
    }

    @Override
    public double[] flatten(boolean forceCopy) {
        double[] out = new double[this.number];
        int j = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1 = this.idx1[i1];
            out[++j] = this.data[j1];
            ++i1;
        }
        return out;
    }

    @Override
    public DoubleScalar slice(int idx) {
        return new DoubleScalar(this.data, this.idx1[Helper.fixIndex(idx, this.dim1)]);
    }

    @Override
    public DoubleScalar slice(int idx, int dim) {
        Helper.fixSliceIndex(dim, 1);
        return new DoubleScalar(this.data, Helper.fixIndex(idx, this.dim1));
    }

    @Override
    public Double1D view(Range rng1) {
        int[] viewIndex1 = Helper.select(this.idx1, rng1);
        if (viewIndex1 == this.idx1) {
            return this;
        }
        return new SelectedDouble1D(this.data, viewIndex1);
    }

    @Override
    public Double1D view(int[] sel1) {
        int[] viewIndex1 = Helper.select(this.idx1, sel1);
        if (viewIndex1 == this.idx1) {
            return this;
        }
        return new SelectedDouble1D(this.data, viewIndex1);
    }

    @Override
    public Double1D as1D() {
        return this;
    }
}

