/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv.impl;

import mitiv.array.ShapedArray;
import mitiv.deconv.impl.ConvolutionFloat1D;
import mitiv.deconv.impl.WeightedConvolutionFloat;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public class WeightedConvolutionFloat1D
extends WeightedConvolutionFloat {
    private final float scale;
    private final int number;
    private final int dim1;
    private final int off1;
    private final int end1;
    private final ConvolutionFloat1D cnvl;

    public WeightedConvolutionFloat1D(ShapedVectorSpace objectSpace, ShapedVectorSpace dataSpace, int[] dataOffset) {
        super(objectSpace, dataSpace);
        if (objectSpace.getRank() != 1) {
            throw new IllegalArgumentException("Object space is not 1D");
        }
        if (dataSpace.getRank() != 1) {
            throw new IllegalArgumentException("Data space is not 1D");
        }
        this.number = objectSpace.getNumber();
        this.scale = 1.0f / (float)this.number;
        this.dim1 = objectSpace.getDimension(0);
        this.off1 = dataOffset[0];
        this.end1 = this.off1 + dataSpace.getDimension(0);
        if (this.off1 < 0 || this.off1 >= this.dim1) {
            throw new IllegalArgumentException("Out of range offset along 1st dimension.");
        }
        if (this.end1 > this.dim1) {
            throw new IllegalArgumentException("Data (+ offset) beyond 1st dimension.");
        }
        this.cnvl = new ConvolutionFloat1D(objectSpace);
    }

    @Override
    protected double cost(double alpha, Vector x) {
        this.checkData();
        this.cnvl.push(((FloatShapedVector)x).getData());
        this.cnvl.convolve(false);
        double sum = 0.0;
        float[] z = this.cnvl.getWorkspace();
        int j = 0;
        int real = 0;
        if (this.wgt == null) {
            int i1 = 0;
            while (i1 < this.dim1) {
                if (this.off1 <= i1 && i1 < this.end1) {
                    float r = this.scale * z[real] - this.dat[j];
                    sum += (double)(r * r);
                    ++j;
                }
                real += 2;
                ++i1;
            }
        } else {
            int i1 = 0;
            while (i1 < this.dim1) {
                if (this.off1 <= i1 && i1 < this.end1) {
                    float f;
                    float w = this.wgt[j];
                    if (f > 0.0f) {
                        float r = this.scale * z[real] - this.dat[j];
                        sum += (double)(w * r * r);
                    }
                    ++j;
                }
                real += 2;
                ++i1;
            }
        }
        return alpha * sum;
    }

    @Override
    protected double cost(double alpha, Vector x, Vector gx, boolean clr) {
        this.checkData();
        this.cnvl.push(((FloatShapedVector)x).getData());
        this.cnvl.convolve(false);
        float q = 2.0f * this.scale * (float)alpha;
        double sum = 0.0;
        float[] z = this.cnvl.getWorkspace();
        int j = 0;
        int real = 0;
        int imag = 1;
        if (this.wgt == null) {
            int i1 = 0;
            while (i1 < this.dim1) {
                if (this.off1 <= i1 && i1 < this.end1) {
                    float r = this.scale * z[real] - this.dat[j];
                    sum += (double)(r * r);
                    z[real] = q * r;
                    z[imag] = 0.0f;
                    ++j;
                } else {
                    z[real] = 0.0f;
                    z[imag] = 0.0f;
                }
                real += 2;
                imag += 2;
                ++i1;
            }
        } else {
            int i1 = 0;
            while (i1 < this.dim1) {
                if (this.off1 <= i1 && i1 < this.end1) {
                    float f;
                    float w = this.wgt[j];
                    if (f > 0.0f) {
                        float r = this.scale * z[real] - this.dat[j];
                        float wr = w * r;
                        sum += (double)(wr * r);
                        z[real] = q * wr;
                    } else {
                        z[real] = 0.0f;
                    }
                    z[imag] = 0.0f;
                    ++j;
                } else {
                    z[real] = 0.0f;
                    z[imag] = 0.0f;
                }
                real += 2;
                imag += 2;
                ++i1;
            }
        }
        float[] g = ((FloatShapedVector)gx).getData();
        this.cnvl.convolve(true);
        real = 0;
        if (clr) {
            int k = 0;
            while (k < this.number) {
                g[k] = z[real];
                ++k;
                real += 2;
            }
        } else {
            int k = 0;
            while (k < this.number) {
                int n = k++;
                g[n] = g[n] + z[real];
                real += 2;
            }
        }
        return alpha * sum;
    }

    @Override
    public void setPSF(ShapedArray psf, int[] off) {
        this.cnvl.setPSF(psf, off);
    }

    @Override
    public void setPSF(ShapedVector psf) {
        this.cnvl.setPSF(psf);
    }
}

