/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.array.DoubleArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.linalg.ArrayOps;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public class DoubleShapedVectorSpace
extends ShapedVectorSpace {
    public DoubleShapedVectorSpace(Shape shape) {
        super(5, shape);
    }

    public DoubleShapedVectorSpace(int[] dims) {
        super(5, dims);
    }

    public DoubleShapedVectorSpace(int dim1) {
        super(5, dim1);
    }

    public DoubleShapedVectorSpace(int dim1, int dim2) {
        super(5, dim1, dim2);
    }

    public DoubleShapedVectorSpace(int dim1, int dim2, int dim3) {
        super(5, dim1, dim2, dim3);
    }

    public DoubleShapedVectorSpace(int dim1, int dim2, int dim3, int dim4) {
        super(5, dim1, dim2, dim3, dim4);
    }

    @Override
    public DoubleShapedVector create() {
        return new DoubleShapedVector(this);
    }

    @Override
    public DoubleShapedVector create(double value) {
        DoubleShapedVector v = new DoubleShapedVector(this);
        ArrayOps.fill(this.number, v.getData(), value);
        return v;
    }

    @Override
    public DoubleShapedVector create(ShapedArray arr) {
        return this.create(arr, false);
    }

    @Override
    public DoubleShapedVector create(ShapedArray arr, boolean forceCopy) {
        this.checkShape(arr);
        DoubleArray tmp = arr.toDouble();
        return new DoubleShapedVector(this, tmp.flatten(forceCopy && tmp == arr));
    }

    public DoubleShapedVector create(DoubleArray arr) {
        return this.create(arr, false);
    }

    public DoubleShapedVector create(DoubleArray arr, boolean forceCopy) {
        this.checkShape(arr);
        return new DoubleShapedVector(this, arr.flatten(forceCopy));
    }

    public DoubleShapedVector clone(DoubleShapedVector vec) {
        this.check(vec);
        return this._clone(vec);
    }

    protected DoubleShapedVector _clone(DoubleShapedVector vec) {
        DoubleShapedVector cpy = new DoubleShapedVector(this);
        this._copy(vec, cpy);
        return cpy;
    }

    @Override
    public DoubleShapedVector clone(Vector vec) {
        this.check(vec);
        return this._clone(vec);
    }

    @Override
    protected DoubleShapedVector _clone(Vector vec) {
        return this._clone((DoubleShapedVector)vec);
    }

    public DoubleShapedVector wrap(double[] x) {
        return new DoubleShapedVector(this, x);
    }

    public void copy(double[] src, Vector dst) {
        this.check(dst);
        ((DoubleShapedVector)dst).set(src);
    }

    protected void _copy(DoubleShapedVector src, DoubleShapedVector dst) {
        ArrayOps.copy(this.number, src.getData(), dst.getData());
    }

    @Override
    protected void _copy(Vector src, Vector dst) {
        this._copy((DoubleShapedVector)src, (DoubleShapedVector)dst);
    }

    @Override
    protected void _swap(Vector x, Vector y) {
        this._copy((DoubleShapedVector)x, (DoubleShapedVector)y);
    }

    protected void _swap(DoubleShapedVector vx, DoubleShapedVector vy) {
        double[] x = vx.getData();
        double[] y = vy.getData();
        int n = vx.getNumber();
        int j = 0;
        while (j < n) {
            double a = x[j];
            x[j] = y[j];
            y[j] = a;
            ++j;
        }
    }

    @Override
    protected void _fill(Vector x, double alpha) {
        ArrayOps.fill(this.number, ((DoubleShapedVector)x).getData(), alpha);
    }

    @Override
    protected double _dot(Vector x, Vector y) {
        return ArrayOps.dot(this.number, ((DoubleShapedVector)x).getData(), ((DoubleShapedVector)y).getData());
    }

    @Override
    protected double _norm2(Vector x) {
        return ArrayOps.norm2(((DoubleShapedVector)x).getData());
    }

    @Override
    protected double _norm1(Vector x) {
        return ArrayOps.norm1(((DoubleShapedVector)x).getData());
    }

    @Override
    protected double _normInf(Vector x) {
        return ArrayOps.normInf(((DoubleShapedVector)x).getData());
    }

    @Override
    protected void _axpby(double alpha, Vector x, double beta, Vector y) {
        ArrayOps.axpby(this.number, alpha, ((DoubleShapedVector)x).getData(), beta, ((DoubleShapedVector)y).getData());
    }

    @Override
    protected void _axpby(double alpha, Vector x, double beta, Vector y, Vector dst) {
        ArrayOps.axpby(this.number, alpha, ((DoubleShapedVector)x).getData(), beta, ((DoubleShapedVector)y).getData(), ((DoubleShapedVector)dst).getData());
    }

    @Override
    protected void _axpbypcz(double alpha, Vector x, double beta, Vector y, double gamma, Vector z, Vector dst) {
        ArrayOps.axpbypcz(this.number, alpha, ((DoubleShapedVector)x).getData(), beta, ((DoubleShapedVector)y).getData(), gamma, ((DoubleShapedVector)z).getData(), ((DoubleShapedVector)dst).getData());
    }
}

