/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;

public class FlatEarth
extends ProjectionImpl {
    public static final String ROTATIONANGLE = "rotationAngle";
    private final double rotAngle;
    private final double radius;
    private final double lat0;
    private final double lon0;
    private double cosRot;
    private double sinRot;

    @Override
    public ProjectionImpl constructCopy() {
        FlatEarth result = new FlatEarth(this.getOriginLat(), this.getOriginLon(), this.getRotationAngle());
        result.setDefaultMapArea(this.defaultMapArea);
        result.setName(this.name);
        return result;
    }

    public FlatEarth() {
        this(0.0, 0.0, 0.0, EARTH_RADIUS);
    }

    public FlatEarth(double lat0, double lon0) {
        this(lat0, lon0, 0.0, EARTH_RADIUS);
    }

    public FlatEarth(double lat0, double lon0, double rotAngle) {
        this(lat0, lon0, rotAngle, EARTH_RADIUS);
    }

    public FlatEarth(double lat0, double lon0, double rotAngle, double radius) {
        super("FlatEarth", false);
        this.lat0 = Math.toRadians(lat0);
        this.lon0 = Math.toRadians(lon0);
        this.rotAngle = Math.toRadians(rotAngle);
        this.radius = radius;
        this.precalculate();
        this.addParameter("grid_mapping_name", "flat_earth");
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_projection_origin", lon0);
        this.addParameter(ROTATIONANGLE, rotAngle);
        this.addParameter("earth_radius", radius * 1000.0);
    }

    private void precalculate() {
        this.sinRot = Math.sin(this.rotAngle);
        this.cosRot = Math.cos(this.rotAngle);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlatEarth flatEarth = (FlatEarth)o;
        if (Double.compare(flatEarth.lat0, this.lat0) != 0) {
            return false;
        }
        if (Double.compare(flatEarth.lon0, this.lon0) != 0) {
            return false;
        }
        if (Double.compare(flatEarth.radius, this.radius) != 0) {
            return false;
        }
        if (Double.compare(flatEarth.rotAngle, this.rotAngle) != 0) {
            return false;
        }
        if (this.defaultMapArea == null != (flatEarth.defaultMapArea == null)) {
            return false;
        }
        return this.defaultMapArea == null || flatEarth.defaultMapArea.equals(this.defaultMapArea);
    }

    public int hashCode() {
        long temp = this.rotAngle != 0.0 ? Double.doubleToLongBits(this.rotAngle) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.radius != 0.0 ? Double.doubleToLongBits(this.radius) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.lat0 != 0.0 ? Double.doubleToLongBits(this.lat0) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.lon0 != 0.0 ? Double.doubleToLongBits(this.lon0) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public double getOriginLon() {
        return Math.toDegrees(this.lon0);
    }

    public double getOriginLat() {
        return Math.toDegrees(this.lat0);
    }

    public double getRotationAngle() {
        return this.rotAngle;
    }

    @Override
    public String getProjectionTypeLabel() {
        return "FlatEarth";
    }

    @Override
    public String paramsToString() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "FlatEarth{rotAngle=" + this.rotAngle + ", radius=" + this.radius + ", lat0=" + this.lat0 + ", lon0=" + this.lon0 + '}';
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        fromLat = Math.toRadians(fromLat);
        double dy = this.radius * (fromLat - this.lat0);
        double dx = this.radius * Math.cos(fromLat) * (Math.toRadians(fromLon) - this.lon0);
        double toX = this.cosRot * dx - this.sinRot * dy;
        double toY = this.sinRot * dx + this.cosRot * dy;
        result.setLocation(toX, toY);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double x = world.getX();
        double y = world.getY();
        boolean TOLERENCE = true;
        double xp = this.cosRot * x + this.sinRot * y;
        double yp = -this.sinRot * x + this.cosRot * y;
        double toLat = Math.toDegrees(this.lat0) + Math.toDegrees(yp / this.radius);
        double cosl = Math.cos(Math.toRadians(toLat));
        double toLon = Math.abs(cosl) < 1.0E-6 ? Math.toDegrees(this.lon0) : Math.toDegrees(this.lon0) + Math.toDegrees(xp / cosl / this.radius);
        toLon = LatLonPointImpl.lonNormal(toLon);
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }

    @Override
    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        float[] fromLatA = from[latIndex];
        float[] fromLonA = from[lonIndex];
        float[] resultXA = to[0];
        float[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            fromLat = Math.toRadians(fromLat);
            double dy = this.radius * (fromLat - this.lat0);
            double dx = this.radius * Math.cos(fromLat) * (Math.toRadians(fromLon) - this.lon0);
            double toX = this.cosRot * dx - this.sinRot * dy;
            double toY = this.sinRot * dx + this.cosRot * dy;
            resultXA[i] = (float)toX;
            resultYA[i] = (float)toY;
        }
        return to;
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return pt1.getX() * pt2.getX() < 0.0;
    }

    @Override
    public float[][] projToLatLon(float[][] from, float[][] to) {
        int cnt = from[0].length;
        float[] fromXA = from[0];
        float[] fromYA = from[1];
        float[] toLatA = to[0];
        float[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromX = fromXA[i];
            double fromY = fromYA[i];
            double xp = this.cosRot * fromX + this.sinRot * fromY;
            double yp = -this.sinRot * fromX + this.cosRot * fromY;
            double toLat = Math.toDegrees(this.lat0) + Math.toDegrees(yp / this.radius);
            double cosl = Math.cos(Math.toRadians(toLat));
            double toLon = Math.abs(cosl) < 1.0E-6 ? Math.toDegrees(this.lon0) : Math.toDegrees(this.lon0) + Math.toDegrees(xp / cosl / this.radius);
            toLon = LatLonPointImpl.lonNormal(toLon);
            toLatA[i] = (float)toLat;
            toLonA[i] = (float)toLon;
        }
        return to;
    }

    @Override
    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        double[] fromLatA = from[latIndex];
        double[] fromLonA = from[lonIndex];
        double[] resultXA = to[0];
        double[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            fromLat = Math.toRadians(fromLat);
            double dy = this.radius * (fromLat - this.lat0);
            double dx = this.radius * Math.cos(fromLat) * (Math.toRadians(fromLon) - this.lon0);
            double toX = this.cosRot * dx - this.sinRot * dy;
            double toY = this.sinRot * dx + this.cosRot * dy;
            resultXA[i] = toX;
            resultYA[i] = toY;
        }
        return to;
    }

    @Override
    public double[][] projToLatLon(double[][] from, double[][] to) {
        int cnt = from[0].length;
        double[] fromXA = from[0];
        double[] fromYA = from[1];
        double[] toLatA = to[0];
        double[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromX = fromXA[i];
            double fromY = fromYA[i];
            double xp = this.cosRot * fromX + this.sinRot * fromY;
            double yp = -this.sinRot * fromX + this.cosRot * fromY;
            double toLat = Math.toDegrees(this.lat0) + Math.toDegrees(yp / this.radius);
            double cosl = Math.cos(Math.toRadians(toLat));
            double toLon = Math.abs(cosl) < 1.0E-6 ? Math.toDegrees(this.lon0) : Math.toDegrees(this.lon0) + Math.toDegrees(xp / cosl / this.radius);
            toLon = LatLonPointImpl.lonNormal(toLon);
            toLatA[i] = toLat;
            toLonA[i] = toLon;
        }
        return to;
    }

    public static void main(String[] args) {
        FlatEarth a = new FlatEarth(90.0, -100.0, 0.0);
        ProjectionPointImpl p = a.latLonToProj(89.0, -101.0);
        System.out.println("proj point = " + p);
        LatLonPoint ll = a.projToLatLon(p);
        System.out.println("ll = " + ll);
    }
}

