package plugins.tprovoost.sequenceblocks.extract;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import plugins.adufour.blocks.tools.sequence.SequenceBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

/**
 * @author thomasprovoost
 */
public class CropSequence extends Plugin implements SequenceBlock, PluginLibrary, PluginBundled
{
    VarSequence inputSequence = new VarSequence("Sequence", null);
    Var<ROI> inputROI = new Var<ROI>("Roi", ROI.class);
    VarSequence outputSequence = new VarSequence("Cropped", null);

    @Override
    public void run()
    {
        Sequence s = inputSequence.getValue();
        ROI roi = inputROI.getValue();
        if (s == null)
            throw new VarException(inputSequence, "Input sequence is null.");
        if (roi == null)
            throw new VarException(inputROI, "Input ROI is null.");
        outputSequence.setValue(SequenceUtil.getSubSequence(s, roi));
    }

    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("sequence", inputSequence);
        inputMap.add("roi", inputROI);
    }

    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add("cropped", outputSequence);
    }

    @Override
    public String getMainPluginClassName()
    {
        return SequenceBlocks.class.getName();
    }
}
