/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVSReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SVSReader.class);
    public static final String APERIO_IMAGE_DESCRIPTION_PREFIX = "Aperio Image";
    private static final String DATE_FORMAT = "MM/dd/yy HH:mm:ss";
    private Length[] pixelSize;
    private String[] comments;
    private int[] ifdmap;
    private Double emissionWavelength;
    private Double excitationWavelength;
    private Double exposureTime;
    private Double exposureScale;
    private Double magnification;
    private String date;
    private String time;

    public SVSReader() {
        super("Aperio SVS", new String[]{"svs"});
        this.domains = new String[]{"Histology"};
        this.suffixNecessary = true;
        this.noSubresolutions = true;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isThisType(String name, boolean open) {
        boolean isThisType = super.isThisType(name, open);
        if (!isThisType && open) {
            RandomAccessInputStream stream = null;
            try {
                stream = new RandomAccessInputStream(name);
                TiffParser tiffParser = new TiffParser(stream);
                tiffParser.setDoCaching(false);
                if (!tiffParser.isValidHeader()) {
                    boolean bl = false;
                    return bl;
                }
                IFD ifd = tiffParser.getFirstIFD();
                if (ifd == null) {
                    boolean e = false;
                    return e;
                }
                Object description = ifd.get(270);
                if (description != null) {
                    String imageDescription = null;
                    if (description instanceof TiffIFDEntry) {
                        Object value = tiffParser.getIFDValue((TiffIFDEntry)description);
                        if (value != null) {
                            imageDescription = value.toString();
                        }
                    } else if (description instanceof String) {
                        imageDescription = (String)description;
                    }
                    if (imageDescription != null && imageDescription.startsWith(APERIO_IMAGE_DESCRIPTION_PREFIX)) {
                        boolean value = true;
                        return value;
                    }
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                LOGGER.debug("I/O exception during isThisType() evaluation.", e);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.debug("I/O exception during stream closure.", e);
                }
            }
        }
        return isThisType;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.core.size() == 1) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.tiffParser == null) {
            this.initTiffParser();
        }
        int ifd = this.ifdmap[this.getCoreIndex()];
        this.tiffParser.getSamples((IFD)this.ifds.get(ifd), buf, x, y, w, h);
        return buf;
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        if (this.core.size() == 1 || this.getSeries() >= this.getSeriesCount() - 2) {
            return super.openThumbBytes(no);
        }
        int smallestSeries = this.getSeriesCount() - 3;
        if (smallestSeries >= 0) {
            int thisSeries = this.getSeries();
            int resolution = this.getResolution();
            this.setSeries(smallestSeries);
            if (!this.hasFlattenedResolutions()) {
                this.setResolution(1);
            }
            byte[] thumb = FormatTools.openThumbBytes(this, no);
            this.setSeries(thisSeries);
            this.setResolution(resolution);
            return thumb;
        }
        return super.openThumbBytes(no);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelSize = null;
            this.comments = null;
            this.ifdmap = null;
            this.emissionWavelength = null;
            this.excitationWavelength = null;
            this.exposureTime = null;
            this.exposureScale = null;
            this.magnification = null;
            this.date = null;
            this.time = null;
        }
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            int ifd = this.ifdmap[this.getCoreIndex()];
            return (int)((IFD)this.ifds.get(ifd)).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileWidth();
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            int ifd = this.ifdmap[this.getCoreIndex()];
            return (int)((IFD)this.ifds.get(ifd)).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileHeight();
        }
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        int i;
        super.initStandardMetadata();
        this.ifds = this.tiffParser.getIFDs();
        int seriesCount = this.ifds.size();
        this.pixelSize = new Length[seriesCount];
        this.comments = new String[seriesCount];
        this.core.clear();
        for (i = 0; i < seriesCount; ++i) {
            this.core.add(new CoreMetadata());
        }
        for (i = 0; i < seriesCount; ++i) {
            String[] lines;
            String comment;
            this.setSeries(i);
            int index = this.getIFDIndex(i);
            this.tiffParser.fillInIFD((IFD)this.ifds.get(index));
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM || (comment = ((IFD)this.ifds.get(index)).getComment()) == null) continue;
            for (String line : lines = comment.split("\n")) {
                String[] tokens;
                for (String t : tokens = line.split("[|]")) {
                    if (t.indexOf("=") == -1) {
                        this.addGlobalMeta("Comment", t);
                        this.comments[i] = t;
                        continue;
                    }
                    String key = t.substring(0, t.indexOf("=")).trim();
                    String value = t.substring(t.indexOf("=") + 1).trim();
                    this.addSeriesMeta(key, value);
                    if (key.equals("MPP")) {
                        this.pixelSize[i] = FormatTools.getPhysicalSizeX(Double.parseDouble(value));
                        continue;
                    }
                    if (key.equals("Date")) {
                        this.date = value;
                        continue;
                    }
                    if (key.equals("Time")) {
                        this.time = value;
                        continue;
                    }
                    if (key.equals("Emission Wavelength")) {
                        this.emissionWavelength = new Double(value);
                        continue;
                    }
                    if (key.equals("Excitation Wavelength")) {
                        this.excitationWavelength = new Double(value);
                        continue;
                    }
                    if (key.equals("Exposure Time")) {
                        this.exposureTime = new Double(value);
                        continue;
                    }
                    if (key.equals("Exposure Scale")) {
                        this.exposureScale = new Double(value);
                        continue;
                    }
                    if (!key.equals("AppMag")) continue;
                    this.magnification = new Double(value);
                }
            }
        }
        this.setSeries(0);
        for (int s = 0; s < seriesCount; ++s) {
            CoreMetadata ms = (CoreMetadata)this.core.get(s);
            if (s == 0 && this.getSeriesCount() > 2) {
                ms.resolutionCount = this.getSeriesCount() - 2;
            }
            IFD ifd = (IFD)this.ifds.get(this.getIFDIndex(s));
            PhotoInterp p = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            ms.rgb = samples > 1 || p == PhotoInterp.RGB;
            ms.sizeX = (int)ifd.getImageWidth();
            ms.sizeY = (int)ifd.getImageLength();
            ms.sizeZ = 1;
            ms.sizeT = 1;
            ms.sizeC = ms.rgb ? samples : 1;
            ms.littleEndian = ifd.isLittleEndian();
            ms.indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
            ms.imageCount = 1;
            ms.pixelType = ifd.getPixelType();
            ms.metadataComplete = true;
            ms.interleaved = false;
            ms.falseColor = false;
            ms.dimensionOrder = "XYCZT";
            ms.thumbnail = s != 0;
        }
        this.reorderResolutions();
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        String instrument = MetadataTools.createLSID("Instrument", 0);
        String objective = MetadataTools.createLSID("Objective", 0, 0);
        store.setInstrumentID(instrument, 0);
        store.setObjectiveID(objective, 0, 0);
        store.setObjectiveNominalMagnification(this.magnification, 0, 0);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageInstrumentRef(instrument, i);
            store.setObjectiveSettingsID(objective, i);
            store.setImageName("Series " + (i + 1), i);
            store.setImageDescription(this.comments[i], i);
            if (this.getDatestamp() != null) {
                store.setImageAcquisitionDate(this.getDatestamp(), i);
            }
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                if (this.getEmission() != null) {
                    store.setChannelEmissionWavelength(this.getEmission(), i, c);
                }
                if (this.getExcitation() == null) continue;
                store.setChannelExcitationWavelength(this.getExcitation(), i, c);
            }
            if (i >= this.pixelSize.length || this.pixelSize[i] == null || !(this.pixelSize[i].value(UNITS.MICROM).doubleValue() - 1.0E-6 > 0.0)) continue;
            store.setPixelsPhysicalSizeX(this.pixelSize[i], i);
            store.setPixelsPhysicalSizeY(this.pixelSize[i], i);
        }
    }

    private int getIFDIndex(int coreIndex) {
        int index = coreIndex;
        if (coreIndex > 0 && coreIndex < this.core.size() - 2) {
            index = this.core.size() - 2 - coreIndex;
        }
        return index;
    }

    protected void reorderResolutions() {
        this.ifdmap = new int[this.core.size()];
        for (int i = 0; i < this.core.size(); i += ((CoreMetadata)this.core.get((int)i)).resolutionCount) {
            int resolutions = ((CoreMetadata)this.core.get((int)i)).resolutionCount;
            ArrayList savedCore = new ArrayList();
            int[] savedIFDs = new int[resolutions];
            HashMap<Integer, Integer> levels = new HashMap<Integer, Integer>();
            for (int c = 0; c < resolutions; ++c) {
                savedCore.add(this.core.get(i + c));
                savedIFDs[c] = this.getIFDIndex(i + c);
                levels.put(((CoreMetadata)savedCore.get((int)c)).sizeX, c);
            }
            Object[] keys = levels.keySet().toArray(new Integer[resolutions]);
            Arrays.sort(keys);
            for (int j = 0; j < resolutions; ++j) {
                this.core.set(i + j, savedCore.get((Integer)levels.get(keys[resolutions - j - 1])));
                this.ifdmap[i + j] = savedIFDs[(Integer)levels.get(keys[resolutions - j - 1])];
                ((CoreMetadata)this.core.get((int)(i + j))).resolutionCount = j == 0 ? resolutions : 1;
            }
        }
    }

    protected Length getEmission() {
        if (this.emissionWavelength != null && this.emissionWavelength > 0.0) {
            return FormatTools.getEmissionWavelength(this.emissionWavelength);
        }
        return null;
    }

    protected Length getExcitation() {
        if (this.excitationWavelength != null && this.excitationWavelength > 0.0) {
            return FormatTools.getExcitationWavelength(this.excitationWavelength);
        }
        return null;
    }

    protected Double getExposureTime() {
        return this.exposureTime;
    }

    protected Timestamp getDatestamp() {
        if (this.date != null && this.time != null) {
            try {
                return new Timestamp(DateTools.formatDate(this.date + " " + this.time, DATE_FORMAT));
            }
            catch (Exception e) {
                LOGGER.debug("Failed to parse '" + this.date + " " + this.time + "'", e);
            }
        }
        return null;
    }

    protected Length[] getPhysicalSizes() {
        return this.pixelSize;
    }

    protected double getMagnification() {
        return this.magnification;
    }
}

