/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.array.Double2D;
import mitiv.array.Double3D;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;

public class WeightGenerator {
    private double saturationLevel = Double.MAX_VALUE;
    private ShapedArray weightMap = null;
    private ShapedArray varianceMap = null;
    private ShapedArray computedVarianceMap = null;
    private ShapedArray pixelMap = null;
    private double gain = -1.0;
    private double readNoise = -1.0;

    public ShapedArray getWeightMap(Shape outputShape) {
        double[] output = null;
        if (this.weightMap != null) {
            output = (double[])this.weightMap.toDouble().flatten().clone();
            int i = 0;
            while (i < output.length) {
                if (output[i] < 0.0) {
                    throw new IllegalArgumentException("A weight map can not contain negative values");
                }
                ++i;
            }
        } else if (this.varianceMap != null) {
            output = (double[])this.varianceMap.toDouble().flatten().clone();
            int i = 0;
            while (i < output.length) {
                output[i] = 1.0 / Math.max(output[i], 0.0);
                ++i;
            }
        } else if (this.gain != -1.0 && this.readNoise != -1.0) {
            output = (double[])this.computedVarianceMap.toDouble().flatten().clone();
            int i = 0;
            while (i < output.length) {
                output[i] = 1.0 / (Math.max(output[i], 0.0) / this.gain + this.readNoise * this.readNoise);
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Before getting a weight map you should give something");
        }
        this.applyDeadPixelMapAndVerify(output);
        if (outputShape.rank() == 2 || outputShape.rank() == 3 && outputShape.dimension(2) == 1) {
            return Double2D.wrap(output, outputShape);
        }
        if (outputShape.rank() == 3) {
            return Double3D.wrap(output, outputShape);
        }
        throw new IllegalArgumentException("Output rank is not compatible: only 2D or 3D Data");
    }

    private void applyDeadPixelMapAndVerify(double[] input) {
        int i = 0;
        while (i < input.length) {
            if (input[i] == this.saturationLevel || Double.isNaN(input[i]) || input[i] > 255.0) {
                input[i] = 0.0;
            }
            ++i;
        }
        if (this.pixelMap != null) {
            double[] dblBad = this.pixelMap.toDouble().flatten();
            int i2 = 0;
            while (i2 < input.length) {
                input[i2] = input[i2] * dblBad[i2];
                ++i2;
            }
        }
    }

    public void setSaturation(double saturation) {
        this.saturationLevel = saturation;
    }

    public void setWeightMap(ShapedArray map) {
        this.weightMap = map;
    }

    public void setVarianceMap(ShapedArray map) {
        this.varianceMap = map;
    }

    public void setComputedVarianceMap(ShapedArray map) {
        this.computedVarianceMap = map;
    }

    public void setPixelMap(ShapedArray map) {
        this.pixelMap = map;
    }

    public void setComputedVariance(ShapedArray data, double alpha, double beta) {
        if (alpha < 0.0 || beta < 0.0) {
            throw new IllegalArgumentException("Computed variance canno't be negative");
        }
        this.gain = alpha;
        this.readNoise = beta;
        this.setComputedVarianceMap(data);
    }
}

