/*
 * Decompiled with CFR 0.152.
 */
package mitiv.io;

import mitiv.array.ByteArray;
import mitiv.array.DoubleArray;
import mitiv.array.FloatArray;
import mitiv.array.IntArray;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.exception.IllegalTypeException;
import mitiv.io.ColorModel;
import mitiv.io.DataFormat;

public class FormatOptions {
    private double minValue = 0.0;
    private boolean minValueGiven = false;
    private double maxValue = 0.0;
    private boolean maxValueGiven = false;
    private ColorModel colorModel = null;
    private DataFormat dataFormat = null;

    public double getMinValue() {
        return this.minValueGiven ? this.minValue : Double.NaN;
    }

    public void setMinValue(double value) {
        this.minValue = value;
        this.minValueGiven = true;
    }

    public void unsetMinValue() {
        this.minValue = Double.NaN;
        this.minValueGiven = false;
    }

    public double getMaxValue() {
        return this.maxValueGiven ? this.maxValue : Double.NaN;
    }

    public void setMaxValue(double value) {
        this.maxValue = value;
        this.maxValueGiven = true;
    }

    public void unsetMaxValue() {
        this.maxValue = Double.NaN;
        this.maxValueGiven = false;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public void setColorModel(ColorModel value) {
        this.colorModel = value;
    }

    public void unsetColorModel() {
        this.colorModel = null;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat value) {
        this.dataFormat = value;
    }

    public void unsetDataFormat() {
        this.dataFormat = null;
    }

    public double[] getScaling(ShapedArray arr, double fileMin, double fileMax) {
        double dataMax;
        double dataMin;
        block26: {
            block28: {
                block27: {
                    block25: {
                        if (arr == null) {
                            return new double[]{1.0, 0.0};
                        }
                        if (!this.minValueGiven || !this.maxValueGiven) break block25;
                        dataMin = this.minValue;
                        dataMax = this.maxValue;
                        break block26;
                    }
                    if (!this.minValueGiven) break block27;
                    dataMin = this.minValue;
                    switch (arr.getType()) {
                        case 0: {
                            dataMax = ((ByteArray)arr).max();
                            break block26;
                        }
                        case 1: {
                            dataMax = ((ShortArray)arr).max();
                            break block26;
                        }
                        case 2: {
                            dataMax = ((IntArray)arr).max();
                            break block26;
                        }
                        case 3: {
                            dataMax = ((LongArray)arr).max();
                            break block26;
                        }
                        case 4: {
                            dataMax = ((FloatArray)arr).max();
                            break block26;
                        }
                        case 5: {
                            dataMax = ((DoubleArray)arr).max();
                            break block26;
                        }
                        default: {
                            throw new IllegalTypeException();
                        }
                    }
                }
                if (!this.maxValueGiven) break block28;
                dataMax = this.maxValue;
                switch (arr.getType()) {
                    case 0: {
                        dataMin = ((ByteArray)arr).min();
                        break block26;
                    }
                    case 1: {
                        dataMin = ((ShortArray)arr).min();
                        break block26;
                    }
                    case 2: {
                        dataMin = ((IntArray)arr).min();
                        break block26;
                    }
                    case 3: {
                        dataMin = ((LongArray)arr).min();
                        break block26;
                    }
                    case 4: {
                        dataMin = ((FloatArray)arr).min();
                        break block26;
                    }
                    case 5: {
                        dataMin = ((DoubleArray)arr).min();
                        break block26;
                    }
                    default: {
                        throw new IllegalTypeException();
                    }
                }
            }
            switch (arr.getType()) {
                case 0: {
                    int[] intResult = ((ByteArray)arr).getMinAndMax();
                    dataMin = intResult[0];
                    dataMax = intResult[1];
                    break;
                }
                case 1: {
                    short[] shortResult = ((ShortArray)arr).getMinAndMax();
                    dataMin = shortResult[0];
                    dataMax = shortResult[1];
                    break;
                }
                case 2: {
                    int[] intResult = ((IntArray)arr).getMinAndMax();
                    dataMin = intResult[0];
                    dataMax = intResult[1];
                    break;
                }
                case 3: {
                    long[] longResult = ((LongArray)arr).getMinAndMax();
                    dataMin = longResult[0];
                    dataMax = longResult[1];
                    break;
                }
                case 4: {
                    float[] floatResult = ((FloatArray)arr).getMinAndMax();
                    dataMin = floatResult[0];
                    dataMax = floatResult[1];
                    break;
                }
                case 5: {
                    double[] doubleResult = ((DoubleArray)arr).getMinAndMax();
                    dataMin = doubleResult[0];
                    dataMax = doubleResult[1];
                    break;
                }
                default: {
                    throw new IllegalTypeException();
                }
            }
        }
        return FormatOptions.computeScalingFactors(dataMin, dataMax, fileMin, fileMax);
    }

    public static double[] computeScalingFactors(double dataMin, double dataMax, double fileMin, double fileMax) {
        double[] result = new double[2];
        FormatOptions.computeScalingFactors(dataMin, dataMax, fileMin, fileMax, result);
        return result;
    }

    public static void computeScalingFactors(double dataMin, double dataMax, double fileMin, double fileMax, double[] param) {
        double bias;
        double scale;
        if (dataMin == dataMax || fileMin == fileMax) {
            scale = 1.0;
            bias = (dataMin + dataMax) / 2.0;
        } else {
            double factor = Math.abs(dataMin);
            factor = Math.max(factor, Math.abs(dataMax));
            factor = Math.max(factor, Math.abs(fileMin));
            if ((factor = Math.max(factor, Math.abs(fileMax))) > 0.0 && factor != 1.0) {
                dataMin /= factor;
                dataMax /= factor;
                fileMin /= factor;
                fileMax /= factor;
            } else {
                factor = 1.0;
            }
            scale = (dataMax - dataMin) / (fileMax - fileMin);
            bias = Math.rint((fileMax * dataMin - fileMin * dataMax) / (dataMax - dataMin) * factor) * scale;
        }
        param[0] = scale;
        param[1] = bias;
    }
}

