/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Double1D;
import mitiv.array.Double2D;
import mitiv.array.impl.FlatDouble1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedDouble2D;
import mitiv.array.impl.StriddenDouble1D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.random.DoubleGenerator;

public class StriddenDouble2D
extends Double2D {
    final int order;
    final double[] data;
    final int offset;
    final int stride1;
    final int stride2;

    public StriddenDouble2D(double[] arr, int offset, int[] stride, int[] dims) {
        super(dims);
        if (stride.length != 2) {
            throw new IllegalArgumentException("There must be as many strides as the rank.");
        }
        this.data = arr;
        this.offset = offset;
        this.stride1 = stride[0];
        this.stride2 = stride[1];
        this.order = Double2D.checkViewStrides(this.data.length, offset, this.stride1, this.stride2, this.dim1, this.dim2);
    }

    public StriddenDouble2D(double[] arr, int offset, int stride1, int stride2, int dim1, int dim2) {
        super(dim1, dim2);
        this.data = arr;
        this.offset = offset;
        this.stride1 = stride1;
        this.stride2 = stride2;
        this.order = Double2D.checkViewStrides(this.data.length, offset, stride1, stride2, dim1, dim2);
    }

    @Override
    public void checkSanity() {
        Double2D.checkViewStrides(this.data.length, this.offset, this.stride1, this.stride2, this.dim1, this.dim2);
    }

    private boolean isFlat() {
        return this.offset == 0 && this.stride1 == 1 && this.stride2 == this.dim1;
    }

    final int index(int i1, int i2) {
        return this.offset + this.stride2 * i2 + this.stride1 * i1;
    }

    @Override
    public final double get(int i1, int i2) {
        return this.data[this.offset + this.stride2 * i2 + this.stride1 * i1];
    }

    @Override
    public final void set(int i1, int i2, double value) {
        this.data[this.offset + this.stride2 * i2 + this.stride1 * i1] = value;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    this.data[j2] = value;
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int j2 = this.stride2 * i2 + this.offset;
                int i1 = 0;
                while (i1 < this.dim1) {
                    int j1 = this.stride1 * i1 + j2;
                    this.data[j1] = value;
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void fill(DoubleGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    this.data[j2] = generator.nextDouble();
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int j2 = this.stride2 * i2 + this.offset;
                int i1 = 0;
                while (i1 < this.dim1) {
                    int j1 = this.stride1 * i1 + j2;
                    this.data[j1] = generator.nextDouble();
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void increment(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2;
                    int n = j2 = this.stride2 * i2 + j1;
                    this.data[n] = this.data[n] + value;
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int j2 = this.stride2 * i2 + this.offset;
                int i1 = 0;
                while (i1 < this.dim1) {
                    int j1;
                    int n = j1 = this.stride1 * i1 + j2;
                    this.data[n] = this.data[n] + value;
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void decrement(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2;
                    int n = j2 = this.stride2 * i2 + j1;
                    this.data[n] = this.data[n] - value;
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int j2 = this.stride2 * i2 + this.offset;
                int i1 = 0;
                while (i1 < this.dim1) {
                    int j1;
                    int n = j1 = this.stride1 * i1 + j2;
                    this.data[n] = this.data[n] - value;
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void scale(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2;
                    int n = j2 = this.stride2 * i2 + j1;
                    this.data[n] = this.data[n] * value;
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int j2 = this.stride2 * i2 + this.offset;
                int i1 = 0;
                while (i1 < this.dim1) {
                    int j1;
                    int n = j1 = this.stride1 * i1 + j2;
                    this.data[n] = this.data[n] * value;
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void map(DoubleFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    this.data[j2] = function.apply(this.data[j2]);
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int j2 = this.stride2 * i2 + this.offset;
                int i1 = 0;
                while (i1 < this.dim1) {
                    int j1 = this.stride1 * i1 + j2;
                    this.data[j1] = function.apply(this.data[j1]);
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void scan(DoubleScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    if (initialized) {
                        scanner.update(this.data[j2]);
                    } else {
                        scanner.initialize(this.data[j2]);
                        initialized = true;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int j2 = this.stride2 * i2 + this.offset;
                int i1 = 0;
                while (i1 < this.dim1) {
                    int j1 = this.stride1 * i1 + j2;
                    if (initialized) {
                        scanner.update(this.data[j1]);
                    } else {
                        scanner.initialize(this.data[j1]);
                        initialized = true;
                    }
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public double[] flatten(boolean forceCopy) {
        if (!forceCopy && this.isFlat()) {
            return this.data;
        }
        double[] out = new double[this.number];
        int j = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int j2 = this.stride2 * i2 + this.offset;
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + j2;
                out[++j] = this.data[j1];
                ++i1;
            }
            ++i2;
        }
        return out;
    }

    @Override
    public Double1D slice(int idx) {
        return new StriddenDouble1D(this.data, this.offset + this.stride2 * idx, this.stride1, this.dim1);
    }

    @Override
    public Double1D slice(int idx, int dim) {
        int sliceDim1;
        int sliceStride1;
        int sliceOffset;
        if (dim < 0) {
            dim += 2;
        }
        if (dim == 0) {
            sliceOffset = this.offset + this.stride1 * idx;
            sliceStride1 = this.stride2;
            sliceDim1 = this.dim2;
        } else if (dim == 1) {
            sliceOffset = this.offset + this.stride2 * idx;
            sliceStride1 = this.stride1;
            sliceDim1 = this.dim1;
        } else {
            throw new IndexOutOfBoundsException("Dimension index out of bounds.");
        }
        return new StriddenDouble1D(this.data, sliceOffset, sliceStride1, sliceDim1);
    }

    @Override
    public Double2D view(Range rng1, Range rng2) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, this.offset, this.stride1);
        CompiledRange cr2 = new CompiledRange(rng2, this.dim2, 0, this.stride2);
        if (cr1.doesNothing() && cr2.doesNothing()) {
            return this;
        }
        return new StriddenDouble2D(this.data, cr1.getOffset() + cr2.getOffset(), cr1.getStride(), cr2.getStride(), cr1.getNumber(), cr2.getNumber());
    }

    @Override
    public Double2D view(int[] sel1, int[] sel2) {
        int[] idx1 = Helper.select(this.offset, this.stride1, this.dim1, sel1);
        int[] idx2 = Helper.select(0, this.stride2, this.dim2, sel2);
        return new SelectedDouble2D(this.data, idx1, idx2);
    }

    @Override
    public Double1D as1D() {
        return new FlatDouble1D(this.flatten(), this.number);
    }
}

