/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dst;

import edu.emory.mathcs.jtransforms.dct.DoubleDCT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DoubleDST_1D {
    private int n;
    private DoubleDCT_1D dct;

    public DoubleDST_1D(int n) {
        this.n = n;
        this.dct = new DoubleDCT_1D(n);
    }

    public void forward(double[] a, boolean scale) {
        this.forward(a, 0, scale);
    }

    public void forward(final double[] a, final int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        int nd2 = this.n / 2;
        int startIdx = 1 + offa;
        int stopIdx = offa + this.n;
        int i = startIdx;
        while (i < stopIdx) {
            a[i] = -a[i];
            i += 2;
        }
        this.dct.forward(a, offa, scale);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && nd2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            nthreads = 2;
            int k = nd2 / nthreads;
            Future[] futures = new Future[nthreads];
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? nd2 : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx0 = offa + DoubleDST_1D.this.n - 1;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            int idx2 = offa + i;
                            double tmp = a[idx2];
                            int idx1 = idx0 - i;
                            a[idx2] = a[idx1];
                            a[idx1] = tmp;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx0 = offa + this.n - 1;
            int i2 = 0;
            while (i2 < nd2) {
                int idx2 = offa + i2;
                double tmp = a[idx2];
                int idx1 = idx0 - i2;
                a[idx2] = a[idx1];
                a[idx1] = tmp;
                ++i2;
            }
        }
    }

    public void inverse(double[] a, boolean scale) {
        this.inverse(a, 0, scale);
    }

    public void inverse(final double[] a, final int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        int nd2 = this.n / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && nd2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            nthreads = 2;
            int k = nd2 / nthreads;
            Future[] futures = new Future[nthreads];
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? nd2 : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx0 = offa + DoubleDST_1D.this.n - 1;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            int idx2 = offa + i;
                            double tmp = a[idx2];
                            int idx1 = idx0 - i;
                            a[idx2] = a[idx1];
                            a[idx1] = tmp;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx0 = offa + this.n - 1;
            int i = 0;
            while (i < nd2) {
                double tmp = a[offa + i];
                a[offa + i] = a[idx0 - i];
                a[idx0 - i] = tmp;
                ++i;
            }
        }
        this.dct.inverse(a, offa, scale);
        int startidx = 1 + offa;
        int stopidx = offa + this.n;
        int i = startidx;
        while (i < stopidx) {
            a[i] = -a[i];
            i += 2;
        }
    }
}

