/*
 * Decompiled with CFR 0.152.
 */
package plugins.mitiv.reconstruction;

import icy.image.IcyBufferedImage;
import icy.type.DataType;
import mitiv.array.ByteArray;
import mitiv.array.DoubleArray;
import mitiv.array.FloatArray;
import mitiv.array.IntArray;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;

public class ReconstructionThreadForIcyUtils {
    public static DataType toIcyDataType(int type) {
        switch (type) {
            case 0: {
                return DataType.BYTE;
            }
            case 1: {
                return DataType.SHORT;
            }
            case 2: {
                return DataType.INT;
            }
            case 3: {
                return DataType.LONG;
            }
            case 4: {
                return DataType.FLOAT;
            }
            case 5: {
                return DataType.DOUBLE;
            }
        }
        throw new IllegalArgumentException("Unknown data type.");
    }

    public void fetchResult(ShapedArray result, IcyBufferedImage image) {
        int n = result.getNumber();
        switch (result.getType()) {
            case 0: {
                byte[] src = ((ByteArray)result).flatten(false);
                byte[] dst = image.getDataXYAsByte(0);
                int j = 0;
                while (j < n) {
                    dst[j] = src[j];
                    ++j;
                }
                break;
            }
            case 1: {
                short[] src = ((ShortArray)result).flatten(false);
                short[] dst = image.getDataXYAsShort(0);
                int j = 0;
                while (j < n) {
                    dst[j] = src[j];
                    ++j;
                }
                break;
            }
            case 2: {
                int[] src = ((IntArray)result).flatten(false);
                int[] dst = image.getDataXYAsInt(0);
                int j = 0;
                while (j < n) {
                    dst[j] = src[j];
                    ++j;
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException("Type 'long' not supported in Icy.");
            }
            case 4: {
                float[] src = ((FloatArray)result).flatten(false);
                float[] dst = image.getDataXYAsFloat(0);
                int j = 0;
                while (j < n) {
                    dst[j] = src[j];
                    ++j;
                }
                break;
            }
            case 5: {
                double[] src = ((DoubleArray)result).flatten(false);
                double[] dst = image.getDataXYAsDouble(0);
                int j = 0;
                while (j < n) {
                    dst[j] = src[j];
                    ++j;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type.");
            }
        }
        image.dataChanged();
    }
}

