/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.FloatBufferWrapper;
import java.util.ArrayList;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.IndexedGeometryStripArrayRetained;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LineStripArrayRetained;
import javax.media.j3d.TriangleFanArrayRetained;
import javax.media.j3d.TriangleStripArrayRetained;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;

abstract class GeometryStripArrayRetained
extends GeometryArrayRetained {
    int[] stripVertexCounts;
    int[] stripStartVertexIndices;
    int[] stripStartOffsetIndices;
    int[] compileNumStrips;
    int[] compileStripCountOffset;

    GeometryStripArrayRetained() {
    }

    void setStripVertexCounts(int[] nArray) {
        boolean bl;
        int n;
        boolean bl2 = false;
        int n2 = nArray.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 += nArray[n];
            if (this instanceof LineStripArrayRetained) {
                if (nArray[n] >= 2) continue;
                throw new IllegalArgumentException(J3dI18N.getString("LineStripArrayRetained1"));
            }
            if (this instanceof TriangleStripArrayRetained) {
                if (nArray[n] >= 3) continue;
                throw new IllegalArgumentException(J3dI18N.getString("TriangleStripArrayRetained1"));
            }
            if (!(this instanceof TriangleFanArrayRetained) || nArray[n] >= 3) continue;
            throw new IllegalArgumentException(J3dI18N.getString("TriangleFanArrayRetained1"));
        }
        if (this.initialVertexIndex + n3 > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray3"));
        }
        if (this.initialCoordIndex + n3 > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray7"));
        }
        if (this.initialColorIndex + n3 > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray4"));
        }
        if (this.initialNormalIndex + n3 > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray5"));
        }
        if ((this.vertexFormat & 0x460) != 0 && (this.vertexFormat & (0x80 | this.vertexFormat & 0x100)) == 128) {
            for (n = 0; n < this.texCoordSetCount; ++n) {
                if (this.initialTexCoordIndex[n] + n3 <= this.vertexCount) continue;
                throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray6"));
            }
        }
        if ((this.vertexFormat & 0x1000) != 0 && (this.vertexFormat & (0x80 | this.vertexFormat & 0x100)) == 128) {
            for (n = 0; n < this.vertexAttrCount; ++n) {
                if (this.initialVertexAttrIndex[n] + n3 <= this.vertexCount) continue;
                throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray8"));
            }
        }
        boolean bl3 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x40;
        this.validVertexCount = n3;
        this.stripVertexCounts = new int[n2];
        this.stripStartVertexIndices = new int[n2];
        this.stripStartOffsetIndices = new int[n2];
        this.stripStartOffsetIndices[0] = 0;
        if ((this.vertexFormat & (0x80 | this.vertexFormat & 0x100)) == 128) {
            this.stripStartVertexIndices[0] = this.initialCoordIndex;
            bl2 = (this.vertexType & 0xF) == 0;
        } else {
            this.stripStartVertexIndices[0] = this.initialVertexIndex;
            if ((this.vertexFormat & 0x100) != 0) {
                bl2 = (this.vertexFormat & 0x800) != 0 ? this.interLeavedVertexData == null : this.interleavedFloatBufferImpl == null;
            }
        }
        for (n = 0; n < n2 - 1; ++n) {
            this.stripVertexCounts[n] = nArray[n];
            this.stripStartVertexIndices[n + 1] = this.stripStartVertexIndices[n] + nArray[n];
            this.stripStartOffsetIndices[n + 1] = this.stripStartOffsetIndices[n] + nArray[n];
        }
        this.stripVertexCounts[n2 - 1] = nArray[n2 - 1];
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.processCoordsChanged(bl2);
            this.sendDataChangedMessage(true);
        }
    }

    void unIndexify(IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained) {
        if ((indexedGeometryStripArrayRetained.vertexFormat & 0x800) == 0) {
            this.unIndexifyJavaArray(indexedGeometryStripArrayRetained);
        } else {
            this.unIndexifyNIOBuffer(indexedGeometryStripArrayRetained);
        }
    }

    private void unIndexifyJavaArray(IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained) {
        int n = 0;
        int n2 = 0;
        int n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
        int n4 = 0;
        float[] fArray = null;
        if ((indexedGeometryStripArrayRetained.vertexFormat & 0x80) == 0 || (indexedGeometryStripArrayRetained.vertexFormat & 0x100) != 0) {
            if ((indexedGeometryStripArrayRetained.vertexFormat & 0x80) == 0) {
                fArray = indexedGeometryStripArrayRetained.vertexData;
                if ((indexedGeometryStripArrayRetained.vertexFormat & 4) != 0) {
                    n4 = 4;
                }
            } else if ((indexedGeometryStripArrayRetained.vertexFormat & 0x100) != 0) {
                fArray = indexedGeometryStripArrayRetained.interLeavedVertexData;
                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                    n4 = 4;
                } else if ((indexedGeometryStripArrayRetained.vertexFormat & 4) != 0) {
                    n4 = 3;
                }
            }
            for (int i = 0; i < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++i) {
                for (int j = 0; j < indexedGeometryStripArrayRetained.stripIndexCounts[i]; ++j) {
                    int n5;
                    int n6 = j + n3;
                    if ((this.vertexFormat & 2) != 0) {
                        System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexNormal[n6] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.normalOffset, this.vertexData, n + this.normalOffset, 3);
                    }
                    if (n4 == 4) {
                        System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexColor[n6] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.colorOffset, this.vertexData, n + this.colorOffset, n4);
                    } else if (n4 == 3) {
                        System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexColor[n6] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.colorOffset, this.vertexData, n + this.colorOffset, n4);
                        this.vertexData[n + this.colorOffset + 3] = 1.0f;
                    }
                    if ((this.vertexFormat & 0x460) != 0) {
                        for (n5 = 0; n5 < this.texCoordSetCount; ++n5) {
                            System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexTexCoord[n5][n6] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.textureOffset + indexedGeometryStripArrayRetained.texCoordSetMapOffset[n5], this.vertexData, n + this.textureOffset + this.texCoordSetMapOffset[n5], this.texCoordStride);
                        }
                    }
                    if ((this.vertexFormat & 0x1000) != 0) {
                        for (n5 = 0; n5 < this.vertexAttrCount; ++n5) {
                            System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexVertexAttr[n5][n6] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.vertexAttrOffsets[n5], this.vertexData, n + this.vertexAttrOffsets[n5], this.vertexAttrSizes[n5]);
                        }
                    }
                    if ((this.vertexFormat & 1) != 0) {
                        System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexCoord[n6] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.coordinateOffset, this.vertexData, n + this.coordinateOffset, 3);
                    }
                    n += this.stride;
                }
                n3 += indexedGeometryStripArrayRetained.stripIndexCounts[i];
            }
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            if ((this.vertexFormat & 2) != 0) {
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n = this.normalOffset;
                switch (indexedGeometryStripArrayRetained.vertexType & 0xC00) {
                    case 1024: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = n9 + n3;
                                System.arraycopy(indexedGeometryStripArrayRetained.floatRefNormals, indexedGeometryStripArrayRetained.indexNormal[n8] * 3, this.vertexData, n, 3);
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                    case 2048: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = indexedGeometryStripArrayRetained.indexNormal[n9 + n3];
                                this.vertexData[n] = indexedGeometryStripArrayRetained.v3fRefNormals[n8].x;
                                this.vertexData[n + 1] = indexedGeometryStripArrayRetained.v3fRefNormals[n8].y;
                                this.vertexData[n + 2] = indexedGeometryStripArrayRetained.v3fRefNormals[n8].z;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n = this.colorOffset;
                int n11 = 3;
                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                    n11 = 4;
                }
                switch (indexedGeometryStripArrayRetained.vertexType & 0x3F0) {
                    case 16: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = n9 + n3;
                                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                                    System.arraycopy(indexedGeometryStripArrayRetained.floatRefColors, indexedGeometryStripArrayRetained.indexColor[n8] * n11, this.vertexData, n, 4);
                                } else {
                                    System.arraycopy(indexedGeometryStripArrayRetained.floatRefColors, indexedGeometryStripArrayRetained.indexColor[n8] * n11, this.vertexData, n, 3);
                                    this.vertexData[n + 3] = 1.0f;
                                }
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                    case 32: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = indexedGeometryStripArrayRetained.indexColor[n9 + n3] * n11;
                                this.vertexData[n] = (float)(indexedGeometryStripArrayRetained.byteRefColors[n8] & 0xFF) * 0.003921569f;
                                this.vertexData[n + 1] = (float)(indexedGeometryStripArrayRetained.byteRefColors[n8 + 1] & 0xFF) * 0.003921569f;
                                this.vertexData[n + 2] = (float)(indexedGeometryStripArrayRetained.byteRefColors[n8 + 2] & 0xFF) * 0.003921569f;
                                this.vertexData[n + 3] = (indexedGeometryStripArrayRetained.vertexFormat & 8) != 0 ? (float)(indexedGeometryStripArrayRetained.byteRefColors[n8 + 3] & 0xFF) * 0.003921569f : 1.0f;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                    case 64: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = indexedGeometryStripArrayRetained.indexColor[n9 + n3];
                                this.vertexData[n] = indexedGeometryStripArrayRetained.c3fRefColors[n8].x;
                                this.vertexData[n + 1] = indexedGeometryStripArrayRetained.c3fRefColors[n8].y;
                                this.vertexData[n + 2] = indexedGeometryStripArrayRetained.c3fRefColors[n8].z;
                                this.vertexData[n + 3] = 1.0f;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                    case 128: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = indexedGeometryStripArrayRetained.indexColor[n9 + n3];
                                this.vertexData[n] = indexedGeometryStripArrayRetained.c4fRefColors[n8].x;
                                this.vertexData[n + 1] = indexedGeometryStripArrayRetained.c4fRefColors[n8].y;
                                this.vertexData[n + 2] = indexedGeometryStripArrayRetained.c4fRefColors[n8].z;
                                this.vertexData[n + 3] = indexedGeometryStripArrayRetained.c4fRefColors[n8].w;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                    case 256: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = indexedGeometryStripArrayRetained.indexColor[n9 + n3];
                                this.vertexData[n] = (float)(indexedGeometryStripArrayRetained.c3bRefColors[n8].x & 0xFF) * 0.003921569f;
                                this.vertexData[n + 1] = (float)(indexedGeometryStripArrayRetained.c3bRefColors[n8].y & 0xFF) * 0.003921569f;
                                this.vertexData[n + 2] = (float)(indexedGeometryStripArrayRetained.c3bRefColors[n8].z & 0xFF) * 0.003921569f;
                                this.vertexData[n + 3] = 1.0f;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                    case 512: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = indexedGeometryStripArrayRetained.indexColor[n9 + n3];
                                this.vertexData[n] = (float)(indexedGeometryStripArrayRetained.c4bRefColors[n8].x & 0xFF) * 0.003921569f;
                                this.vertexData[n + 1] = (float)(indexedGeometryStripArrayRetained.c4bRefColors[n8].y & 0xFF) * 0.003921569f;
                                this.vertexData[n + 2] = (float)(indexedGeometryStripArrayRetained.c4bRefColors[n8].z & 0xFF) * 0.003921569f;
                                this.vertexData[n + 3] = (float)(indexedGeometryStripArrayRetained.c4bRefColors[n8].w & 0xFF) * 0.003921569f;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n = this.textureOffset;
                switch (indexedGeometryStripArrayRetained.vertexType & 0x7000) {
                    case 4096: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = n9 + n3;
                                n2 = n;
                                for (n7 = 0; n7 < this.texCoordSetCount; ++n7) {
                                    System.arraycopy(indexedGeometryStripArrayRetained.refTexCoords[n7], indexedGeometryStripArrayRetained.indexTexCoord[n7][n8] * this.texCoordStride, this.vertexData, n2, this.texCoordStride);
                                    n2 += this.texCoordStride;
                                }
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                    case 8192: {
                        int n12;
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = n9 + n3;
                                n2 = n;
                                for (n7 = 0; n7 < this.texCoordSetCount; ++n7) {
                                    n12 = indexedGeometryStripArrayRetained.indexTexCoord[n7][n8];
                                    this.vertexData[n2] = ((TexCoord2f[])indexedGeometryStripArrayRetained.refTexCoords[n7])[n12].x;
                                    this.vertexData[n2 + 1] = ((TexCoord2f[])indexedGeometryStripArrayRetained.refTexCoords[n7])[n12].y;
                                    n2 += this.texCoordStride;
                                }
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                    case 16384: {
                        int n12;
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = n9 + n3;
                                n2 = n;
                                for (n7 = 0; n7 < this.texCoordSetCount; ++n7) {
                                    n12 = indexedGeometryStripArrayRetained.indexTexCoord[n7][n8];
                                    this.vertexData[n2] = ((TexCoord3f[])indexedGeometryStripArrayRetained.refTexCoords[n7])[n12].x;
                                    this.vertexData[n2 + 1] = ((TexCoord3f[])indexedGeometryStripArrayRetained.refTexCoords[n7])[n12].y;
                                    this.vertexData[n2 + 2] = ((TexCoord3f[])indexedGeometryStripArrayRetained.refTexCoords[n7])[n12].z;
                                    n2 += this.texCoordStride;
                                }
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n = 0;
                switch (indexedGeometryStripArrayRetained.vertexType & 0x8000) {
                    case 32768: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = n9 + n3;
                                for (n7 = 0; n7 < this.vertexAttrCount; ++n7) {
                                    System.arraycopy(indexedGeometryStripArrayRetained.floatRefVertexAttrs[n7], indexedGeometryStripArrayRetained.indexVertexAttr[n7][n8] * this.vertexAttrSizes[n7], this.vertexData, n + this.vertexAttrOffsets[n7], this.vertexAttrSizes[n7]);
                                }
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                n = this.coordinateOffset;
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                switch (indexedGeometryStripArrayRetained.vertexType & 0xF) {
                    case 1: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = n9 + n3;
                                System.arraycopy(indexedGeometryStripArrayRetained.floatRefCoords, indexedGeometryStripArrayRetained.indexCoord[n8] * 3, this.vertexData, n, 3);
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                    case 2: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = indexedGeometryStripArrayRetained.indexCoord[n9 + n3] * 3;
                                this.vertexData[n] = (float)indexedGeometryStripArrayRetained.doubleRefCoords[n8];
                                this.vertexData[n + 1] = (float)indexedGeometryStripArrayRetained.doubleRefCoords[n8 + 1];
                                this.vertexData[n + 2] = (float)indexedGeometryStripArrayRetained.doubleRefCoords[n8 + 2];
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                    case 4: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = indexedGeometryStripArrayRetained.indexCoord[n9 + n3];
                                this.vertexData[n] = indexedGeometryStripArrayRetained.p3fRefCoords[n8].x;
                                this.vertexData[n + 1] = indexedGeometryStripArrayRetained.p3fRefCoords[n8].y;
                                this.vertexData[n + 2] = indexedGeometryStripArrayRetained.p3fRefCoords[n8].z;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                    case 8: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = indexedGeometryStripArrayRetained.indexCoord[n9 + n3];
                                this.vertexData[n] = (float)indexedGeometryStripArrayRetained.p3dRefCoords[n8].x;
                                this.vertexData[n + 1] = (float)indexedGeometryStripArrayRetained.p3dRefCoords[n8].y;
                                this.vertexData[n + 2] = (float)indexedGeometryStripArrayRetained.p3dRefCoords[n8].z;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                }
            }
        }
    }

    private void unIndexifyNIOBuffer(IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained) {
        int n = 0;
        int n2 = 0;
        int n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
        int n4 = 0;
        if ((indexedGeometryStripArrayRetained.vertexFormat & 0x100) != 0) {
            if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                n4 = 4;
            } else if ((indexedGeometryStripArrayRetained.vertexFormat & 4) != 0) {
                n4 = 3;
            }
            for (int i = 0; i < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++i) {
                for (int j = 0; j < indexedGeometryStripArrayRetained.stripIndexCounts[i]; ++j) {
                    int n5 = j + n3;
                    if ((this.vertexFormat & 2) != 0) {
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryStripArrayRetained.indexNormal[n5] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.normalOffset);
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.normalOffset, 3);
                    }
                    if (n4 == 4) {
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryStripArrayRetained.indexColor[n5] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.colorOffset);
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.colorOffset, n4);
                    } else if (n4 == 3) {
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryStripArrayRetained.indexColor[n5] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.colorOffset);
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.colorOffset, n4);
                        this.vertexData[n + this.colorOffset + 3] = 1.0f;
                    }
                    if ((this.vertexFormat & 0x460) != 0) {
                        for (int k = 0; k < this.texCoordSetCount; ++k) {
                            indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryStripArrayRetained.indexTexCoord[k][n5] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.textureOffset + indexedGeometryStripArrayRetained.texCoordSetMapOffset[k]);
                            indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.textureOffset + this.texCoordSetMapOffset[k], this.texCoordStride);
                        }
                    }
                    if ((this.vertexFormat & 1) != 0) {
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryStripArrayRetained.indexCoord[n5] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.coordinateOffset);
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.coordinateOffset, 3);
                    }
                    n += this.stride;
                }
                n3 += indexedGeometryStripArrayRetained.stripIndexCounts[i];
            }
        } else {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            if ((this.vertexFormat & 2) != 0) {
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n = this.normalOffset;
                if ((indexedGeometryStripArrayRetained.vertexType & 0xC00) != 0) {
                    for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                        for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                            n8 = n9 + n3;
                            indexedGeometryStripArrayRetained.floatBufferRefNormals.position(indexedGeometryStripArrayRetained.indexNormal[n8] * 3);
                            indexedGeometryStripArrayRetained.floatBufferRefNormals.get(this.vertexData, n, 3);
                            n += this.stride;
                        }
                        n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n = this.colorOffset;
                n7 = 3;
                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                    n7 = 4;
                }
                switch (indexedGeometryStripArrayRetained.vertexType & 0x3F0) {
                    case 16: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = n9 + n3;
                                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                                    indexedGeometryStripArrayRetained.floatBufferRefColors.position(indexedGeometryStripArrayRetained.indexColor[n8] * n7);
                                    indexedGeometryStripArrayRetained.floatBufferRefColors.get(this.vertexData, n, 4);
                                } else {
                                    indexedGeometryStripArrayRetained.floatBufferRefColors.position(indexedGeometryStripArrayRetained.indexColor[n8] * n7);
                                    indexedGeometryStripArrayRetained.floatBufferRefColors.get(this.vertexData, n, 3);
                                    this.vertexData[n + 3] = 1.0f;
                                }
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                    case 32: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = indexedGeometryStripArrayRetained.indexColor[n9 + n3] * n7;
                                this.vertexData[n] = (float)(indexedGeometryStripArrayRetained.byteBufferRefColors.get(n8) & 0xFF) * 0.003921569f;
                                this.vertexData[n + 1] = (float)(indexedGeometryStripArrayRetained.byteBufferRefColors.get(n8 + 1) & 0xFF) * 0.003921569f;
                                this.vertexData[n + 2] = (float)(indexedGeometryStripArrayRetained.byteBufferRefColors.get(n8 + 2) & 0xFF) * 0.003921569f;
                                this.vertexData[n + 3] = (indexedGeometryStripArrayRetained.vertexFormat & 8) != 0 ? (float)(indexedGeometryStripArrayRetained.byteBufferRefColors.get(n8 + 3) & 0xFF) * 0.003921569f : 1.0f;
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n = this.textureOffset;
                if ((indexedGeometryStripArrayRetained.vertexType & 0x7000) != 0) {
                    for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                        for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                            n8 = n9 + n3;
                            n2 = n;
                            for (n6 = 0; n6 < this.texCoordSetCount; ++n6) {
                                FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)indexedGeometryStripArrayRetained.refTexCoordsBuffer[n6]).getBufferImpl();
                                floatBufferWrapper.position(indexedGeometryStripArrayRetained.indexTexCoord[n6][n8] * this.texCoordStride);
                                floatBufferWrapper.get(this.vertexData, n2, this.texCoordStride);
                                n2 += this.texCoordStride;
                            }
                            n += this.stride;
                        }
                        n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                    }
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n = 0;
                if ((indexedGeometryStripArrayRetained.vertexType & 0x8000) == 32768) {
                    for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                        for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                            n8 = n9 + n3;
                            for (n6 = 0; n6 < this.vertexAttrCount; ++n6) {
                                n7 = n + this.vertexAttrOffsets[n6];
                                FloatBufferWrapper floatBufferWrapper = indexedGeometryStripArrayRetained.floatBufferRefVertexAttrs[n6];
                                floatBufferWrapper.position(indexedGeometryStripArrayRetained.indexVertexAttr[n6][n8] * this.vertexAttrSizes[n6]);
                                floatBufferWrapper.get(this.vertexData, n7, this.vertexAttrSizes[n6]);
                            }
                            n += this.stride;
                        }
                        n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                n = this.coordinateOffset;
                n3 = indexedGeometryStripArrayRetained.initialIndexIndex;
                switch (indexedGeometryStripArrayRetained.vertexType & 0xF) {
                    case 1: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = n9 + n3;
                                indexedGeometryStripArrayRetained.floatBufferRefCoords.position(indexedGeometryStripArrayRetained.indexCoord[n8] * 3);
                                indexedGeometryStripArrayRetained.floatBufferRefCoords.get(this.vertexData, n, 3);
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                    case 2: {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n10) {
                            for (n9 = 0; n9 < indexedGeometryStripArrayRetained.stripIndexCounts[n10]; ++n9) {
                                n8 = indexedGeometryStripArrayRetained.indexCoord[n9 + n3] * 3;
                                this.vertexData[n] = (float)indexedGeometryStripArrayRetained.doubleBufferRefCoords.get(n8);
                                this.vertexData[n + 1] = (float)indexedGeometryStripArrayRetained.doubleBufferRefCoords.get(n8 + 1);
                                this.vertexData[n + 2] = (float)indexedGeometryStripArrayRetained.doubleBufferRefCoords.get(n8 + 2);
                                n += this.stride;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n10];
                        }
                        break;
                    }
                }
            }
        }
    }

    int getNumStrips() {
        return this.stripVertexCounts.length;
    }

    void getStripVertexCounts(int[] nArray) {
        for (int nArray[var2_3] : this.stripVertexCounts) {
        }
    }

    void getStripVertexCounts(int n, int[] nArray) {
        int n2 = this.compileStripCountOffset[n];
        int n3 = this.compileNumStrips[n];
        System.arraycopy(this.stripVertexCounts, n2, nArray, 0, n3);
    }

    int getNumStrips(int n) {
        return this.compileNumStrips[n];
    }

    void mergeGeometryArrays(ArrayList arrayList) {
        int n;
        int n2 = arrayList.size();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 += ((GeometryStripArrayRetained)arrayList.get((int)n)).stripVertexCounts.length;
        }
        this.stripVertexCounts = new int[n3];
        this.stripStartVertexIndices = new int[n3];
        this.stripStartOffsetIndices = new int[n3];
        n = 0;
        int n4 = 0;
        this.compileNumStrips = new int[n2];
        this.compileStripCountOffset = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n5;
            GeometryStripArrayRetained geometryStripArrayRetained = (GeometryStripArrayRetained)arrayList.get(i);
            int[] nArray = geometryStripArrayRetained.stripVertexCounts;
            int[] nArray2 = geometryStripArrayRetained.stripStartVertexIndices;
            int[] nArray3 = geometryStripArrayRetained.stripStartOffsetIndices;
            this.compileNumStrips[i] = n5 = nArray.length;
            this.compileStripCountOffset[i] = n;
            System.arraycopy(nArray, 0, this.stripVertexCounts, n, n5);
            for (int j = 0; j < n5; ++j) {
                this.stripStartVertexIndices[j + n] = nArray2[j] + n4;
                this.stripStartOffsetIndices[j + n] = nArray3[j] + n4;
            }
            n += n5;
            n4 += geometryStripArrayRetained.validVertexCount;
        }
        this.validVertexCount = n4;
        super.mergeGeometryArrays(arrayList);
    }
}

