/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block.decomposition.chol;

import org.ejml.alg.block.BlockInnerRankUpdate;
import org.ejml.alg.block.BlockMatrixOps;
import org.ejml.alg.block.BlockTriangularSolver;
import org.ejml.alg.block.decomposition.chol.BlockInnerCholesky;
import org.ejml.alg.dense.decomposition.CholeskyDecomposition;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.D1Submatrix64F;

public class BlockCholeskyOuterForm
implements CholeskyDecomposition<BlockMatrix64F> {
    private boolean lower = false;
    private BlockMatrix64F T;

    public BlockCholeskyOuterForm(boolean bl) {
        this.lower = bl;
    }

    @Override
    public boolean decompose(BlockMatrix64F blockMatrix64F) {
        if (blockMatrix64F.numCols != blockMatrix64F.numRows) {
            throw new IllegalArgumentException("A must be square");
        }
        this.T = blockMatrix64F;
        if (this.lower) {
            return this.decomposeLower();
        }
        return this.decomposeUpper();
    }

    private boolean decomposeLower() {
        int n = this.T.blockLength;
        D1Submatrix64F d1Submatrix64F = new D1Submatrix64F(this.T);
        D1Submatrix64F d1Submatrix64F2 = new D1Submatrix64F(this.T);
        D1Submatrix64F d1Submatrix64F3 = new D1Submatrix64F(this.T);
        for (int i = 0; i < this.T.numCols; i += n) {
            int n2 = Math.min(n, this.T.numCols - i);
            d1Submatrix64F.col0 = i;
            d1Submatrix64F.col1 = i + n2;
            d1Submatrix64F.row0 = d1Submatrix64F.col0;
            d1Submatrix64F.row1 = d1Submatrix64F.col1;
            d1Submatrix64F2.col0 = i;
            d1Submatrix64F2.col1 = i + n2;
            d1Submatrix64F2.row0 = i + n2;
            d1Submatrix64F2.row1 = this.T.numRows;
            d1Submatrix64F3.col0 = i + n2;
            d1Submatrix64F3.col1 = this.T.numRows;
            d1Submatrix64F3.row0 = i + n2;
            d1Submatrix64F3.row1 = this.T.numRows;
            if (!BlockInnerCholesky.lower(d1Submatrix64F)) {
                return false;
            }
            if (n2 != n) continue;
            BlockTriangularSolver.solveBlock(n, false, d1Submatrix64F, d1Submatrix64F2, false, true);
            BlockInnerRankUpdate.symmRankNMinus_L(n, d1Submatrix64F3, d1Submatrix64F2);
        }
        BlockMatrixOps.zeroTriangle(true, this.T);
        return true;
    }

    private boolean decomposeUpper() {
        int n = this.T.blockLength;
        D1Submatrix64F d1Submatrix64F = new D1Submatrix64F(this.T);
        D1Submatrix64F d1Submatrix64F2 = new D1Submatrix64F(this.T);
        D1Submatrix64F d1Submatrix64F3 = new D1Submatrix64F(this.T);
        for (int i = 0; i < this.T.numCols; i += n) {
            int n2 = Math.min(n, this.T.numCols - i);
            d1Submatrix64F.col0 = i;
            d1Submatrix64F.col1 = i + n2;
            d1Submatrix64F.row0 = d1Submatrix64F.col0;
            d1Submatrix64F.row1 = d1Submatrix64F.col1;
            d1Submatrix64F2.col0 = i + n2;
            d1Submatrix64F2.col1 = this.T.numCols;
            d1Submatrix64F2.row0 = i;
            d1Submatrix64F2.row1 = i + n2;
            d1Submatrix64F3.col0 = i + n2;
            d1Submatrix64F3.col1 = this.T.numCols;
            d1Submatrix64F3.row0 = i + n2;
            d1Submatrix64F3.row1 = this.T.numCols;
            if (!BlockInnerCholesky.upper(d1Submatrix64F)) {
                return false;
            }
            if (n2 != n) continue;
            BlockTriangularSolver.solveBlock(n, true, d1Submatrix64F, d1Submatrix64F2, true, false);
            BlockInnerRankUpdate.symmRankNMinus_U(n, d1Submatrix64F3, d1Submatrix64F2);
        }
        BlockMatrixOps.zeroTriangle(false, this.T);
        return true;
    }

    @Override
    public boolean isLower() {
        return this.lower;
    }

    @Override
    public BlockMatrix64F getT(BlockMatrix64F blockMatrix64F) {
        if (blockMatrix64F == null) {
            return this.T;
        }
        blockMatrix64F.set(this.T);
        return blockMatrix64F;
    }

    @Override
    public boolean inputModified() {
        return true;
    }
}

