/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public class TruncatedConjugateGradient {
    public static final int SUCCESS = 0;
    public static final int FAILURE = -1;
    public static final int IN_PROGRESS = 0;
    public static final int CONVERGED = 1;
    public static final int TRUNCATED = 2;
    public static final int TOO_MANY_ITERATIONS = 3;
    public static final int A_IS_NOT_POSITIVE_DEFINITE = 4;
    public static final int P_IS_NOT_POSITIVE_DEFINITE = 5;
    public static final int BUG = 7;
    public static final int FOREVER = -1;
    public static final double DEFAULT_ABSOLUTE_TOLERANCE = 0.0;
    public static final double DEFAULT_RELATIVE_TOLERANCE = 1.0E-6;
    public static final int DEFAULT_MAXIMUM_ITERATIONS = -1;
    protected double atol = 0.0;
    protected double rtol = 1.0E-6;
    protected int maxiter = -1;
    protected LinearOperator A = null;
    protected Vector b = null;
    protected double delta = 0.0;

    public void setDefaults() {
        this.atol = 0.0;
        this.rtol = 1.0E-6;
        this.maxiter = -1;
    }

    public void releaseMemory() {
        this.b = null;
    }

    public void setPreconditioner(LinearOperator P) {
    }

    public void setRightHandSideVector(Vector b) {
    }

    public void setLeftHandSideOperator(LinearOperator A) {
    }

    public double getAbsoluteTolerance() {
        return this.atol;
    }

    public void setAbsoluteTolerance(double atol) {
        this.atol = Math.max(0.0, atol);
    }

    public double getRelativeTolerance() {
        return this.rtol;
    }

    public void setRelativeTolerance(double rtol) {
        this.rtol = Math.max(0.0, rtol);
    }

    public int getMaximumIterations() {
        return this.maxiter;
    }

    public void setMaximumIterations(int maxiter) {
        this.maxiter = maxiter >= 0 ? maxiter : -1;
    }

    public static int solveQuadratic(double[] x, double a, double b, double c) {
        if (a != 0.0) {
            double p = a + a;
            double q = c + c;
            double r = b * b - p * q;
            if (r > 0.0) {
                double xb;
                r = b >= 0.0 ? -b - Math.sqrt(r) : Math.sqrt(r) - b;
                double xa = q / r;
                if (xa < (xb = r / p)) {
                    x[0] = xa;
                    x[1] = xb;
                } else {
                    x[0] = xb;
                    x[1] = xa;
                }
                return 2;
            }
            if (r == 0.0) {
                x[0] = x[1] = -b / p;
                return 1;
            }
        } else if (b != 0.0) {
            x[0] = x[1] = -c / b;
            return 1;
        }
        return 0;
    }

    private static int adjustStep(Vector x, Vector p, double delta, double xnrm) throws IncorrectSpaceException {
        if (delta < 0.0) {
            return -1;
        }
        if (xnrm == delta) {
            return 0;
        }
        double a = p.dot(p);
        double b = 2.0 * p.dot(x);
        double c = (xnrm + delta) * (xnrm - delta);
        double[] t = new double[2];
        double alpha = 0.0;
        if (TruncatedConjugateGradient.solveQuadratic(t, a, b, c) >= 1) {
            alpha = xnrm > delta ? Math.min(0.0, t[0]) : Math.max(0.0, t[1]);
        }
        if (alpha == 0.0) {
            return -1;
        }
        x.combine(1.0, x, alpha, p);
        return 0;
    }

    public int truncatedConjugateGradient(LinearOperator A, Vector b, Vector x, double delta, int maxiter) throws IncorrectSpaceException {
        return this.truncatedConjugateGradient(A, b, x, null, delta, maxiter);
    }

    public int truncatedConjugateGradient(LinearOperator A, Vector b, Vector x, LinearOperator P, double delta, int maxiter) throws IncorrectSpaceException {
        LinearOperator.checkLinearProblem(A, b, x, true);
        VectorSpace vsp = b.getSpace();
        Vector r = vsp.create();
        Vector p = vsp.create();
        Vector q = vsp.create();
        Vector z = null;
        vsp.zero(x);
        double xnrm = 0.0;
        r.copyFrom(b);
        if (P != null) {
            if (P.getInputSpace() != vsp || P.getOutputSpace() != vsp) {
                throw new IncorrectSpaceException();
            }
            z = vsp.create();
            P.apply(z, r);
        } else {
            z = r;
        }
        double rho = z.dot(r);
        double rho_prev = 0.0;
        double epsilon = 0.0;
        int iter = 0;
        while (!(rho <= epsilon)) {
            if (maxiter >= 0 && iter >= maxiter) {
                return 3;
            }
            if (iter == 0) {
                p.copyFrom(z);
            } else {
                double beta = rho / rho_prev;
                p.combine(1.0, z, beta, p);
            }
            A.apply(q, p);
            double gamma = p.dot(q);
            if (gamma <= 0.0) {
                TruncatedConjugateGradient.adjustStep(x, p, delta, xnrm);
                return 4;
            }
            double alpha = rho / gamma;
            x.combine(1.0, x, alpha, p);
            xnrm = Math.sqrt(x.dot(x));
            if (xnrm >= delta) {
                TruncatedConjugateGradient.adjustStep(x, p, delta, xnrm);
                return 2;
            }
            r.combine(1.0, r, -alpha, q);
            if (P != null) {
                P.apply(z, r);
            }
            rho_prev = rho;
            rho = z.dot(r);
            ++iter;
        }
        return 1;
    }
}

