/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInDialog;
import ij.plugin.frame.Recorder;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class Channels
extends PlugInDialog
implements PlugIn,
ItemListener,
ActionListener {
    private static String[] modes = new String[]{"Composite", "Color", "Grayscale"};
    private static String[] menuItems = new String[]{"Make Composite", "Convert to RGB", "Split Channels", "Merge Channels...", "Edit LUT...", "-", "Red", "Green", "Blue", "Cyan", "Magenta", "Yellow", "Grays"};
    private static String moreLabel = "More \u00bb";
    private Choice choice;
    private Checkbox[] checkbox;
    private Button moreButton;
    private static Channels instance;
    private int id;
    private static Point location;
    private PopupMenu pm;

    public Channels() {
        super("Channels");
        int i;
        int nCheckBoxes;
        if (instance != null) {
            instance.toFront();
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        int y = 0;
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        int margin = 32;
        if (IJ.isMacOSX()) {
            margin = 20;
        }
        c.insets = new Insets(10, margin, 10, margin);
        this.choice = new Choice();
        for (int i2 = 0; i2 < modes.length; ++i2) {
            this.choice.addItem(modes[i2]);
        }
        this.choice.select(0);
        this.choice.addItemListener(this);
        this.add((Component)this.choice, c);
        CompositeImage ci = this.getImage();
        int n = nCheckBoxes = ci != null ? ci.getNChannels() : 3;
        if (nCheckBoxes > 7) {
            nCheckBoxes = 7;
        }
        this.checkbox = new Checkbox[nCheckBoxes];
        for (i = 0; i < nCheckBoxes; ++i) {
            this.checkbox[i] = new Checkbox("Channel " + (i + 1), true);
            c.insets = new Insets(0, 25, i < nCheckBoxes - 1 ? 0 : 10, 5);
            c.gridy = y++;
            this.add((Component)this.checkbox[i], c);
            this.checkbox[i].addItemListener(this);
        }
        c.insets = new Insets(0, 15, 10, 15);
        c.fill = 0;
        c.gridy = y++;
        this.moreButton = new Button(moreLabel);
        this.moreButton.addActionListener(this);
        this.add((Component)this.moreButton, c);
        this.update();
        this.pm = new PopupMenu();
        for (i = 0; i < menuItems.length; ++i) {
            this.addPopupItem(menuItems[i]);
        }
        this.add(this.pm);
        this.addKeyListener(IJ.getInstance());
        this.setResizable(false);
        this.pack();
        if (location == null) {
            GUI.center(this);
            location = this.getLocation();
        } else {
            this.setLocation(location);
        }
        this.show();
    }

    public void update() {
        CompositeImage ci = this.getImage();
        if (ci == null || this.checkbox == null) {
            return;
        }
        int n = this.checkbox.length;
        int nChannels = ci.getNChannels();
        if (nChannels != n && nChannels <= 7) {
            instance = null;
            location = this.getLocation();
            this.close();
            new Channels();
            return;
        }
        boolean[] active = ci.getActiveChannels();
        for (int i = 0; i < this.checkbox.length; ++i) {
            this.checkbox[i].setState(active[i]);
        }
        int index = 0;
        switch (ci.getMode()) {
            case 1: {
                index = 0;
                break;
            }
            case 2: {
                index = 1;
                break;
            }
            case 3: {
                index = 2;
            }
        }
        this.choice.select(index);
    }

    public static void updateChannels() {
        if (!(instance == null || IJ.isMacOSX() && IJ.isJava18())) {
            instance.update();
        }
    }

    void addPopupItem(String s) {
        MenuItem mi = new MenuItem(s);
        mi.addActionListener(this);
        this.pm.add(mi);
    }

    CompositeImage getImage() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null || !imp.isComposite()) {
            return null;
        }
        return (CompositeImage)imp;
    }

    public void itemStateChanged(ItemEvent e) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        if (!imp.isComposite()) {
            int channels = imp.getNChannels();
            if (channels == 1 && imp.getStackSize() <= 4) {
                channels = imp.getStackSize();
            }
            if (imp.getBitDepth() == 24 || channels > 1 && channels < 7) {
                GenericDialog gd = new GenericDialog(imp.getTitle());
                gd.addMessage("Convert to multi-channel composite image?");
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return;
                }
                IJ.doCommand("Make Composite");
            } else {
                IJ.error("Channels", "A composite image is required (e.g., " + moreLabel + " Open HeLa Cells),\nor create one using " + moreLabel + " Make Composite.");
                return;
            }
        }
        if (!imp.isComposite()) {
            return;
        }
        CompositeImage ci = (CompositeImage)imp;
        Object source = e.getSource();
        if (source == this.choice) {
            int index = ((Choice)source).getSelectedIndex();
            switch (index) {
                case 0: {
                    ci.setMode(1);
                    break;
                }
                case 1: {
                    ci.setMode(2);
                    break;
                }
                case 2: {
                    ci.setMode(3);
                }
            }
            ci.updateAndDraw();
            if (Recorder.record) {
                String mode = null;
                if (Recorder.scriptMode()) {
                    switch (index) {
                        case 0: {
                            mode = "IJ.COMPOSITE";
                            break;
                        }
                        case 1: {
                            mode = "IJ.COLOR";
                            break;
                        }
                        case 2: {
                            mode = "IJ.GRAYSCALE";
                        }
                    }
                    Recorder.recordCall("imp.setDisplayMode(" + mode + ");");
                } else {
                    switch (index) {
                        case 0: {
                            mode = "composite";
                            break;
                        }
                        case 1: {
                            mode = "color";
                            break;
                        }
                        case 2: {
                            mode = "grayscale";
                        }
                    }
                    Recorder.record("Stack.setDisplayMode", mode);
                }
            }
        } else if (source instanceof Checkbox) {
            for (int i = 0; i < this.checkbox.length; ++i) {
                Checkbox cb = (Checkbox)source;
                if (cb != this.checkbox[i]) continue;
                if (ci.getMode() == 1) {
                    boolean[] active = ci.getActiveChannels();
                    active[i] = cb.getState();
                    if (Recorder.record) {
                        String str = "";
                        for (int c = 0; c < ci.getNChannels(); ++c) {
                            str = str + (active[c] ? "1" : "0");
                        }
                        if (Recorder.scriptMode()) {
                            Recorder.recordCall("imp.setActiveChannels(\"" + str + "\");");
                        } else {
                            Recorder.record("Stack.setActiveChannels", str);
                        }
                    }
                } else {
                    imp.setPosition(i + 1, imp.getSlice(), imp.getFrame());
                    if (Recorder.record) {
                        if (Recorder.scriptMode()) {
                            Recorder.recordCall("imp.setC(" + (i + 1) + ");");
                        } else {
                            Recorder.record("Stack.setChannel", i + 1);
                        }
                    }
                }
                ci.updateAndDraw();
                return;
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == null) {
            return;
        }
        if (command.equals(moreLabel)) {
            Point bloc = this.moreButton.getLocation();
            this.pm.show(this, bloc.x, bloc.y);
        } else if (command.equals("Convert to RGB")) {
            IJ.doCommand("Stack to RGB");
        } else {
            IJ.doCommand(command);
        }
    }

    public static Frame getInstance() {
        return null;
    }

    public void close() {
        super.close();
        instance = null;
        location = this.getLocation();
    }
}

