/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.processing;

import ij.ImageStack;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.TreeSet;
import mcib3d.geom.ComparatorVoxel;
import mcib3d.geom.Voxel3D;
import mcib3d.geom.Voxel3DComparable;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageLabeller;
import mcib3d.image3d.ImageShort;
import mcib3d.utils.ArrayUtil;

public class Watershed3D {
    ImageHandler rawImage;
    ImageHandler seedsImage;
    ImageInt watershedImage = null;
    ImageInt mask;
    LinkedList<Voxel3DComparable> voxels = null;
    final int NO_LABEL = 0;
    final int QUEUE = 1;
    private int rawThreshold;
    private final int seedsThreshold;
    boolean okseeds = false;
    boolean anim = false;

    public Watershed3D(ImageHandler imageHandler, ImageHandler imageHandler2, int n, int n2) {
        this.rawImage = imageHandler;
        this.seedsImage = imageHandler2;
        this.rawThreshold = n;
        this.seedsThreshold = n2;
    }

    public Watershed3D(ImageStack imageStack, ImageStack imageStack2, int n, int n2) {
        this.rawImage = ImageHandler.wrap(imageStack);
        this.seedsImage = ImageInt.wrap(imageStack2);
        this.rawThreshold = n;
        this.seedsThreshold = n2;
    }

    public ImageHandler getRawImage() {
        return this.rawImage;
    }

    public void setRawImage(ImageHandler imageHandler) {
        this.rawImage = imageHandler;
    }

    public ImageHandler getSeeds() {
        return this.seedsImage;
    }

    public void setSeeds(ImageInt imageInt) {
        this.seedsImage = imageInt;
    }

    public void setAnim(boolean bl) {
        this.anim = bl;
    }

    public ImageInt getWatershedImage3D() {
        return this.getClassicWatershed();
    }

    private ImageInt getClassicWatershed() {
        long l = 100L;
        this.createNeigList();
        long l2 = System.currentTimeMillis();
        if (this.anim) {
            this.watershedImage.show();
        }
        if (this.rawImage.getMin() > (double)this.rawThreshold) {
            this.rawThreshold = (int)this.rawImage.getMin();
        }
        boolean bl = true;
        ComparatorVoxel comparatorVoxel = new ComparatorVoxel();
        TreeSet<Voxel3DComparable> treeSet = new TreeSet<Voxel3DComparable>(comparatorVoxel);
        TreeSet<Voxel3DComparable> treeSet2 = new TreeSet<Voxel3DComparable>(comparatorVoxel);
        int n = 1;
        for (Voxel3DComparable voxel3DComparable : this.voxels) {
            voxel3DComparable.setMax(n++, 0);
            treeSet.add(voxel3DComparable);
        }
        boolean bl2 = true;
        while (bl2) {
            bl2 = false;
            while (!treeSet.isEmpty() && bl) {
                Voxel3DComparable voxel3DComparable;
                voxel3DComparable = treeSet.pollFirst();
                ArrayList<Voxel3D> arrayList = this.watershedImage.getNeighborhood3x3x3ListNoCenter(voxel3DComparable.getRoundX(), voxel3DComparable.getRoundY(), voxel3DComparable.getRoundZ());
                ArrayUtil arrayUtil = new ArrayUtil(arrayList.size());
                int n2 = 0;
                double d = -1.0;
                for (Voxel3D voxel3D : arrayList) {
                    if (!(voxel3D.getValue() > 1.0)) continue;
                    arrayUtil.addValue(n2++, voxel3D.getValue());
                    if (d == -1.0) {
                        d = voxel3D.getValue();
                        continue;
                    }
                    if (voxel3D.getValue() == d) break;
                    d = -2.0;
                    break;
                }
                boolean bl3 = false;
                if (d > 0.0) {
                    this.watershedImage.setPixel(voxel3DComparable, (float)arrayUtil.getValueInt(0));
                    bl3 = true;
                }
                if (bl3) {
                    for (Voxel3D voxel3D : arrayList) {
                        int n3 = (int)this.rawImage.getPixel(voxel3D);
                        if (voxel3D.getValue() != 0.0 || n3 <= this.rawThreshold) continue;
                        this.watershedImage.setPixel(voxel3D, 1.0f);
                        Voxel3DComparable voxel3DComparable2 = new Voxel3DComparable(voxel3D.getRoundX(), voxel3D.getRoundY(), voxel3D.getRoundZ(), n3, voxel3DComparable.getLabel());
                        voxel3DComparable2.setMax(n++, 0);
                        treeSet.add(voxel3DComparable2);
                    }
                }
                if (System.currentTimeMillis() - l2 <= l) continue;
                if (this.anim) {
                    this.watershedImage.updateDisplay();
                }
                l2 = System.currentTimeMillis();
            }
        }
        this.watershedImage.replacePixelsValue(1, 0);
        return this.watershedImage;
    }

    private void createNeigList() {
        this.voxels = new LinkedList();
        int n = this.rawImage.sizeX;
        int n2 = this.rawImage.sizeY;
        int n3 = this.rawImage.sizeZ;
        this.watershedImage = new ImageShort("watershed", n, n2, n3);
        this.okseeds = false;
        ImageLabeller imageLabeller = new ImageLabeller();
        ImageInt imageInt = imageLabeller.getLabels(this.seedsImage.thresholdAboveExclusive(this.seedsThreshold));
        int n4 = (int)imageInt.getMax();
        imageInt.replacePixelsValue(1, n4 + 1);
        imageInt.resetStats(null);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    float f = this.rawImage.getPixel(k, j, i);
                    float f2 = imageInt.getPixel(k, j, i);
                    if (!(f > (float)this.rawThreshold) || !(f2 > 0.0f)) continue;
                    this.watershedImage.setPixel(k, j, i, f2);
                    this.okseeds = true;
                    for (Voxel3D voxel3D : this.watershedImage.getNeighborhood3x3x3ListNoCenter(k, j, i)) {
                        int n5;
                        int n6;
                        int n7 = (int)voxel3D.getX();
                        int n8 = (int)this.rawImage.getPixel(n7, n6 = (int)voxel3D.getY(), n5 = (int)voxel3D.getZ());
                        if (n8 <= this.rawThreshold || imageInt.getPixel(n7, n6, n5) != 0.0f || this.watershedImage.getPixel(n7, n6, n5) == 1.0f) continue;
                        this.voxels.add(new Voxel3DComparable(n7, n6, n5, n8, f2));
                        this.watershedImage.setPixel(n7, n6, n5, 1);
                    }
                }
            }
        }
    }
}

