/*
 * Decompiled with CFR 0.152.
 */
package plugins.mitiv.reconstruction;

import icy.sequence.Sequence;
import mitiv.array.ArrayFactory;
import mitiv.array.DoubleArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.cost.CompositeDifferentiableCostFunction;
import mitiv.cost.HyperbolicTotalVariation;
import mitiv.deconv.WeightedConvolutionCost;
import mitiv.invpb.ReconstructionJob;
import mitiv.invpb.ReconstructionSynchronizer;
import mitiv.invpb.ReconstructionViewer;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.optim.BLMVM;
import mitiv.optim.BoundProjector;
import mitiv.optim.LBFGS;
import mitiv.optim.LineSearch;
import mitiv.optim.MoreThuenteLineSearch;
import mitiv.optim.NonLinearConjugateGradient;
import mitiv.optim.OptimTask;
import mitiv.optim.ReverseCommunicationOptimizer;
import mitiv.optim.SimpleBounds;
import mitiv.optim.SimpleLowerBound;
import mitiv.optim.SimpleUpperBound;
import mitiv.utils.Timer;
import mitiv.utils.reconstruction.ReconstructionThreadToken;
import plugins.mitiv.reconstruction.ReconstructionJobForIcy;

public class TotalVariationJobForIcy
extends ReconstructionJobForIcy
implements ReconstructionJob {
    private double mu = 10.0;
    private double epsilon = 1.0;
    private double gatol = 0.0;
    private double grtol = 0.001;
    private int limitedMemorySize = 5;
    private double lowerBound = Double.NEGATIVE_INFINITY;
    private double upperBound = Double.POSITIVE_INFINITY;
    private int maxiter = 200;
    private Shape resultShape;
    private DoubleArray data = null;
    private DoubleArray psf = null;
    private DoubleArray weight = null;
    private double fcost = 0.0;
    private DoubleShapedVector gcost = null;
    private Timer timer = new Timer();
    private ReverseCommunicationOptimizer minimizer = null;
    private ReconstructionViewer viewer = null;
    private ReconstructionSynchronizer synchronizer = null;
    private double[] synchronizedParameters = new double[]{0.0, 0.0};
    private boolean[] change = new boolean[2];

    public ReconstructionViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(ReconstructionViewer rv) {
        this.viewer = rv;
    }

    public ReconstructionSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public void createSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizedParameters[0] = this.mu;
            this.synchronizedParameters[1] = this.epsilon;
            this.synchronizer = new ReconstructionSynchronizer(this.synchronizedParameters);
        }
    }

    public void deleteSynchronizer() {
        this.synchronizer = null;
    }

    public DoubleArray getData() {
        return this.data;
    }

    public void setData(DoubleArray data) {
        this.data = data;
    }

    public DoubleArray getPsf() {
        return this.psf;
    }

    public void setPsf(DoubleArray psf) {
        this.psf = psf;
    }

    @Override
    public ShapedArray getResult() {
        return this.result;
    }

    public void setResult(ShapedArray result) {
        this.result = result;
    }

    public void setMaximumIterations(int value) {
        this.maxiter = value;
    }

    public void setLimitedMemorySize(int value) {
        this.limitedMemorySize = value;
    }

    public void setRegularizationWeight(double value) {
        this.mu = value;
    }

    public void setRegularizationThreshold(double value) {
        this.epsilon = value;
    }

    public void setAbsoluteTolerance(double value) {
        this.gatol = value;
    }

    public void setRelativeTolerance(double value) {
        this.grtol = value;
    }

    @Override
    public double getRelativeTolerance() {
        return this.grtol;
    }

    public void setLowerBound(double value) {
        this.lowerBound = value;
    }

    public void setUpperBound(double value) {
        this.upperBound = value;
    }

    public void setWeight(DoubleArray W) {
        this.weight = W;
    }

    public void setOutputShape(Shape shape) {
        this.resultShape = shape;
    }

    public void setPositivity(boolean bool) {
        this.lowerBound = bool ? 0.0 : Double.NEGATIVE_INFINITY;
    }

    public TotalVariationJobForIcy(Sequence sequence, ReconstructionThreadToken token) {
        super(sequence, token);
    }

    public TotalVariationJobForIcy(ReconstructionThreadToken token) {
        this(null, token);
    }

    private static void fatal(String reason) {
        throw new IllegalArgumentException(reason);
    }

    @Override
    public void run() {
        int k;
        this.timer.start();
        if (this.data == null) {
            TotalVariationJobForIcy.fatal("Input data not specified.");
        }
        Shape dataShape = this.data.getShape();
        Shape psfShape = this.psf.getShape();
        int rank = this.data.getRank();
        if (this.psf == null) {
            TotalVariationJobForIcy.fatal("PSF not specified.");
        }
        if (this.psf.getRank() != rank) {
            TotalVariationJobForIcy.fatal("PSF must have same rank as data.");
        }
        if (this.resultShape == null) {
            TotalVariationJobForIcy.fatal("An output shape must ge given.");
        }
        if (this.result != null) {
            k = 0;
            while (k < rank) {
                if (this.result.getDimension(k) != this.data.getDimension(k)) {
                    this.result = null;
                    break;
                }
                ++k;
            }
        }
        k = 0;
        while (k < rank) {
            if (this.resultShape.dimension(k) < dataShape.dimension(k)) {
                TotalVariationJobForIcy.fatal("The dimensions of the result must be at least those of the data.");
            }
            if (this.resultShape.dimension(k) < psfShape.dimension(k)) {
                TotalVariationJobForIcy.fatal("The dimensions of the result must be at least those of the PSF.");
            }
            ++k;
        }
        DoubleShapedVectorSpace dataSpace = new DoubleShapedVectorSpace(dataShape);
        DoubleShapedVectorSpace resultSpace = new DoubleShapedVectorSpace(this.resultShape);
        DoubleShapedVector x = null;
        x = this.result != null ? resultSpace.create(this.result) : resultSpace.create(0.0);
        this.result = ArrayFactory.wrap(x.getData(), this.resultShape);
        WeightedConvolutionCost weightedCost = WeightedConvolutionCost.build(resultSpace, dataSpace);
        weightedCost.setPSF(this.psf);
        weightedCost.setWeightsAndData(this.weight, this.data);
        WeightedConvolutionCost fdata = weightedCost;
        HyperbolicTotalVariation fprior = new HyperbolicTotalVariation(resultSpace, this.epsilon);
        CompositeDifferentiableCostFunction cost = new CompositeDifferentiableCostFunction(1.0, fdata, this.mu, fprior);
        this.fcost = 0.0;
        this.gcost = resultSpace.create();
        this.timer.stop();
        this.timer.reset();
        this.timer.start();
        MoreThuenteLineSearch lineSearch = null;
        LBFGS lbfgs = null;
        BLMVM blmvm = null;
        NonLinearConjugateGradient nlcg = null;
        BoundProjector projector = null;
        int bounded = 0;
        if (this.lowerBound != Double.NEGATIVE_INFINITY) {
            bounded |= 1;
        }
        if (this.upperBound != Double.POSITIVE_INFINITY) {
            bounded |= 2;
        }
        if (bounded == 0) {
            lineSearch = new MoreThuenteLineSearch(0.05, 0.1, 1.0E-17);
            if (this.limitedMemorySize > 0) {
                lbfgs = new LBFGS(resultSpace, this.limitedMemorySize, (LineSearch)lineSearch);
                lbfgs.setAbsoluteTolerance(this.gatol);
                lbfgs.setRelativeTolerance(this.grtol);
                this.minimizer = lbfgs;
            } else {
                int method = 771;
                nlcg = new NonLinearConjugateGradient(resultSpace, method, lineSearch);
                nlcg.setAbsoluteTolerance(this.gatol);
                nlcg.setRelativeTolerance(this.grtol);
                this.minimizer = nlcg;
            }
        } else {
            projector = bounded == 1 ? new SimpleLowerBound(resultSpace, this.lowerBound) : (bounded == 2 ? new SimpleUpperBound(resultSpace, this.upperBound) : new SimpleBounds(resultSpace, this.lowerBound, this.upperBound));
            int m = this.limitedMemorySize > 1 ? this.limitedMemorySize : 3;
            blmvm = new BLMVM(resultSpace, projector, m);
            blmvm.setAbsoluteTolerance(this.gatol);
            blmvm.setRelativeTolerance(this.grtol);
            this.minimizer = blmvm;
            projector.projectVariables(x);
        }
        this.timer.stop();
        this.timer.reset();
        OptimTask task = this.minimizer.start();
        while (!this.token.isStopped()) {
            if (task == OptimTask.COMPUTE_FG) {
                this.timer.resume();
                this.fcost = cost.computeCostAndGradient(1.0, x, this.gcost, true);
                this.timer.stop();
            } else if (task == OptimTask.NEW_X || task == OptimTask.FINAL_X) {
                boolean stop;
                if (this.viewer != null) {
                    this.viewer.display(this);
                }
                boolean bl = stop = task == OptimTask.FINAL_X;
                if (!stop && this.maxiter >= 0 && this.minimizer.getIterations() >= this.maxiter) {
                    System.err.format("Warning: too many iterations (%d).\n", this.maxiter);
                    stop = true;
                }
                if (stop) {
                    break;
                }
            } else {
                System.err.println("TotalVariationJobForIcy error/warning: " + this.minimizer.getReason());
                break;
            }
            if (this.synchronizer != null) {
                if (this.synchronizer.getTask() == 1) break;
                this.synchronizedParameters[0] = this.mu;
                this.synchronizedParameters[1] = this.epsilon;
                if (this.synchronizer.updateParameters(this.synchronizedParameters, this.change)) {
                    if (this.change[0]) {
                        this.mu = this.synchronizedParameters[0];
                    }
                    if (this.change[1]) {
                        this.epsilon = this.synchronizedParameters[1];
                    }
                }
            }
            task = this.minimizer.iterate(x, this.fcost, this.gcost);
        }
    }

    @Override
    public int getIterations() {
        return this.minimizer == null ? 0 : this.minimizer.getIterations();
    }

    @Override
    public int getEvaluations() {
        return this.minimizer == null ? 0 : this.minimizer.getEvaluations();
    }

    @Override
    public double getCost() {
        return this.fcost;
    }

    @Override
    public double getGradientNorm2() {
        return this.gcost == null ? 0.0 : this.gcost.norm2();
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public double getGradientNorm1() {
        return this.gcost == null ? 0.0 : this.gcost.norm1();
    }

    @Override
    public double getGradientNormInf() {
        return this.gcost == null ? 0.0 : this.gcost.normInf();
    }
}

