/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Byte1D;
import mitiv.array.DoubleArray;
import mitiv.array.DoubleScalar;
import mitiv.array.Float1D;
import mitiv.array.Int1D;
import mitiv.array.Long1D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.impl.FlatDouble1D;
import mitiv.array.impl.StriddenDouble1D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public abstract class Double1D
extends Array1D
implements DoubleArray {
    protected Double1D(int dim1) {
        super(dim1);
    }

    protected Double1D(int[] dims) {
        super(dims);
    }

    protected Double1D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 5;
    }

    public abstract double get(int var1);

    public abstract void set(int var1, double var2);

    @Override
    public void fill(double value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, value);
            ++i1;
        }
    }

    @Override
    public void increment(double value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, this.get(i1) + value);
            ++i1;
        }
    }

    @Override
    public void decrement(double value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, this.get(i1) - value);
            ++i1;
        }
    }

    @Override
    public void scale(double value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, this.get(i1) * value);
            ++i1;
        }
    }

    @Override
    public void map(DoubleFunction function) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, function.apply(this.get(i1)));
            ++i1;
        }
    }

    @Override
    public void fill(DoubleGenerator generator) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, generator.nextDouble());
            ++i1;
        }
    }

    @Override
    public void scan(DoubleScanner scanner) {
        scanner.initialize(this.get(0));
        int i1 = 1;
        while (i1 < this.dim1) {
            scanner.update(this.get(i1));
            ++i1;
        }
    }

    @Override
    public double[] flatten(boolean forceCopy) {
        double[] out = new double[this.number];
        int i1 = 0;
        while (i1 < this.dim1) {
            out[i1] = this.get(i1);
            ++i1;
        }
        return out;
    }

    @Override
    public double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public double min() {
        double minValue = this.get(0);
        int i1 = 1;
        while (i1 < this.dim1) {
            double value = this.get(i1);
            if (value < minValue) {
                minValue = value;
            }
            ++i1;
        }
        return minValue;
    }

    @Override
    public double max() {
        double maxValue = this.get(0);
        int i1 = 1;
        while (i1 < this.dim1) {
            double value = this.get(i1);
            if (value > maxValue) {
                maxValue = value;
            }
            ++i1;
        }
        return maxValue;
    }

    @Override
    public double[] getMinAndMax() {
        double[] result = new double[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(double[] mm) {
        double minValue;
        double maxValue = minValue = this.get(0);
        int i1 = 1;
        while (i1 < this.dim1) {
            double value = this.get(i1);
            if (value < minValue) {
                minValue = value;
            }
            if (value > maxValue) {
                maxValue = value;
            }
            ++i1;
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public double sum() {
        double totalValue = this.get(0);
        int i1 = 1;
        while (i1 < this.dim1) {
            totalValue += this.get(i1);
            ++i1;
        }
        return totalValue;
    }

    @Override
    public double average() {
        return this.sum() / (double)this.number;
    }

    @Override
    public Byte1D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = (byte)this.get(i1);
            ++i1;
        }
        return Byte1D.wrap(out, this.dim1);
    }

    @Override
    public Short1D toShort() {
        short[] out = new short[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = (short)this.get(i1);
            ++i1;
        }
        return Short1D.wrap(out, this.dim1);
    }

    @Override
    public Int1D toInt() {
        int[] out = new int[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = (int)this.get(i1);
            ++i1;
        }
        return Int1D.wrap(out, this.dim1);
    }

    @Override
    public Long1D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = (long)this.get(i1);
            ++i1;
        }
        return Long1D.wrap(out, this.dim1);
    }

    @Override
    public Float1D toFloat() {
        float[] out = new float[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = (float)this.get(i1);
            ++i1;
        }
        return Float1D.wrap(out, this.dim1);
    }

    @Override
    public Double1D toDouble() {
        return this;
    }

    @Override
    public Double1D copy() {
        return new FlatDouble1D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Double1D src = arr.getType() == 5 ? (Double1D)arr : (Double1D)arr.toDouble();
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, src.get(i1));
            ++i1;
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i1 = 0;
            while (i1 < this.dim1) {
                this.set(i1, src.get(i1));
                ++i1;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i1 = 0;
            while (i1 < this.dim1) {
                this.set(i1, src.get(i1));
                ++i1;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Double1D create() {
        return new FlatDouble1D(this.getShape());
    }

    public static Double1D create(int dim1) {
        return new FlatDouble1D(dim1);
    }

    public static Double1D create(int[] dims) {
        return new FlatDouble1D(dims);
    }

    public static Double1D create(Shape shape) {
        return new FlatDouble1D(shape);
    }

    public static Double1D wrap(double[] data, int dim1) {
        return new FlatDouble1D(data, dim1);
    }

    public static Double1D wrap(double[] data, int[] dims) {
        return new FlatDouble1D(data, dims);
    }

    public static Double1D wrap(double[] data, Shape shape) {
        return new FlatDouble1D(data, shape);
    }

    public static Double1D wrap(double[] data, int offset, int stride1, int dim1) {
        return new StriddenDouble1D(data, offset, stride1, dim1);
    }

    @Override
    public abstract DoubleScalar slice(int var1);

    @Override
    public abstract DoubleScalar slice(int var1, int var2);

    @Override
    public abstract Double1D view(Range var1);

    @Override
    public abstract Double1D view(int[] var1);

    @Override
    public abstract Double1D as1D();
}

